/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.core;

import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.actf.core.config.IConfiguration;
import org.eclipse.actf.core.runtime.IRuntimeContext;
import org.eclipse.actf.core.runtime.RuntimeContextFactory;
import org.eclipse.actf.util.resources.ClassLoaderCache;
import org.eclipse.actf.util.resources.EclipseResourceLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class ActfCorePlugin
extends Plugin {
    public static final String ACTFCORE_PLUGIN_ID = "org.eclipse.actf.core";
    protected IRuntimeContext runtimeContext;
    protected IConfiguration configuration;
    protected ClassLoaderCache clCache = ClassLoaderCache.getDefault();
    private Logger logger = Logger.getLogger("org.eclipse.actf.core");
    private static ActfCorePlugin plugin;

    protected String getPluginId() {
        return ACTFCORE_PLUGIN_ID;
    }

    public static ActfCorePlugin getDefault() {
        if (plugin == null) {
            plugin = new ActfCorePlugin();
        }
        return plugin;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.runtimeContext = RuntimeContextFactory.getInstance().getRuntimeContext();
        this.configuration = this.runtimeContext.getConfiguration();
        EclipseResourceLocator eclipseResourceLocator = (EclipseResourceLocator)this.runtimeContext.getResourceLocator();
        eclipseResourceLocator.registerBundleName(this.getPluginId());
        this.clCache.put(this.getPluginId(), ((Object)((Object)this)).getClass().getClassLoader());
        String string = System.getProperty("java.util.logging.config.file");
        if (string == null) {
            LogManager logManager = LogManager.getLogManager();
            EclipseResourceLocator eclipseResourceLocator2 = (EclipseResourceLocator)this.runtimeContext.getResourceLocator();
            eclipseResourceLocator2.registerBundleName(ACTFCORE_PLUGIN_ID);
            InputStream inputStream = eclipseResourceLocator2.getResourceAsStream("logging", "\\", "properties", ACTFCORE_PLUGIN_ID);
            if (inputStream != null) {
                logManager.readConfiguration(inputStream);
            }
        }
        this.logger.log(Level.INFO, String.valueOf(((Object)((Object)this)).getClass().getName()) + " started");
        this.logger.log(Level.INFO, "configuration:" + this.configuration);
    }

    public IRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public void logException(String string, Throwable throwable) {
        String string2 = throwable.getClass().getName();
        String string3 = throwable.getMessage();
        string3 = string3 != null && string3.length() > 0 ? String.valueOf(string2) + " - " + string3 : string2;
        this.logger.log(Level.SEVERE, string != null ? string : "<No message>", throwable);
    }

    public void logException(Throwable throwable) {
        String string = throwable.getMessage();
        this.logger.log(Level.SEVERE, string != null && string.length() > 0 ? string : "<no message>", throwable);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.logger.log(Level.INFO, String.valueOf(((Object)((Object)this)).getClass().getName()) + " stopped");
        super.stop(bundleContext);
    }

    public boolean isDebugging(String string) {
        String string2 = Platform.getDebugOption((String)string);
        return super.isDebugging() && string2 != null && "true".equalsIgnoreCase(string2);
    }
}

