/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl;

import org.eclipse.actf.model.dom.dombycom.AnalyzedResult;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.impl.AttrImpl;
import org.eclipse.actf.model.dom.dombycom.impl.DocumentImpl;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NamedNodeMapImpl;
import org.eclipse.actf.model.dom.dombycom.impl.NodeListNextSiblingImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.HTMLElementFactory;
import org.eclipse.actf.model.dom.dombycom.impl.object.ObjectElementFactory;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public class NodeImpl
implements Node {
    protected final IDispatch inode;
    protected final short nodeType;
    private NodeImpl parentNode;
    private DocumentImpl doc;
    String uniqueName;
    private String cachedNodeName = null;
    private NodeListNextSiblingImpl cachedChildNodes;

    IDispatch getIDispatch() {
        return this.inode;
    }

    private static String getUniqueName(IDispatch iDispatch) {
        return (String)Helper.get(iDispatch, "uniqueID");
    }

    private NodeImpl newNodeByType(IDispatch iDispatch, short s) {
        switch (s) {
            case 2: {
                return new AttrImpl(this, iDispatch);
            }
            case 9: {
                return this.doc;
            }
            case 4: 
            case 8: 
            case 10: {
                return new NodeImpl(this, iDispatch, s);
            }
            case 1: {
                NodeImpl nodeImpl;
                if (Helper.hasProperty(iDispatch, "contentWindow")) {
                    return HTMLElementFactory.create(this, iDispatch, "FrameNode");
                }
                String string = (String)Helper.get(iDispatch, "nodeName");
                if (("OBJECT".equals(string) || "EMBED".equals(string)) && (nodeImpl = ObjectElementFactory.create(this, iDispatch)) != null) {
                    return nodeImpl;
                }
                return HTMLElementFactory.create(this, iDispatch, string);
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                return new NodeImpl(this, iDispatch, s);
            }
            case 3: {
                return HTMLElementFactory.create(this, iDispatch, "Text");
            }
        }
        return new NodeImpl(this, iDispatch, s);
    }

    NodeImpl newNode(IDispatch iDispatch) {
        Object object;
        if (iDispatch == null) {
            return null;
        }
        String string = NodeImpl.getUniqueName(iDispatch);
        if (string != null && (object = this.doc.lookupNode(string)) != null) {
            iDispatch.release();
            return object;
        }
        object = (Integer)Helper.get(iDispatch, "nodeType");
        if (object == null) {
            return null;
        }
        short s = (short)((Integer)object).intValue();
        NodeImpl nodeImpl = this.newNodeByType(iDispatch, s);
        if (string != null) {
            nodeImpl.uniqueName = string;
            this.doc.regNode(string, nodeImpl);
        }
        return nodeImpl;
    }

    protected NodeImpl newNode(IDispatch iDispatch, short s) {
        if (iDispatch == null) {
            return null;
        }
        String string = NodeImpl.getUniqueName(iDispatch);
        if (string != null) {
            NodeImpl nodeImpl = this.doc.lookupNode(string);
            if (nodeImpl != null) {
                iDispatch.release();
                return nodeImpl;
            }
            NodeImpl nodeImpl2 = this.newNodeByType(iDispatch, s);
            nodeImpl2.uniqueName = string;
            this.doc.regNode(string, nodeImpl2);
            return nodeImpl2;
        }
        return this.newNodeByType(iDispatch, s);
    }

    protected NodeImpl newNode(IDispatch iDispatch, short s, NodeImpl nodeImpl) {
        NodeImpl nodeImpl2 = this.newNode(iDispatch, s);
        nodeImpl2.parentNode = nodeImpl;
        return nodeImpl2;
    }

    public IDispatch getINode() {
        return this.inode;
    }

    NodeImpl(IDispatch iDispatch) {
        this.doc = (DocumentImpl)this;
        this.inode = iDispatch;
        this.nodeType = (short)9;
    }

    protected NodeImpl(NodeImpl nodeImpl, IDispatch iDispatch, short s) {
        this.doc = nodeImpl.doc;
        this.inode = iDispatch;
        this.nodeType = s;
    }

    public String getNodeName() {
        if (this.cachedNodeName == null) {
            this.cachedNodeName = (String)Helper.get(this.inode, "nodeName");
        }
        return this.cachedNodeName;
    }

    public String getNodeValue() throws DOMException {
        Object object = Helper.get(this.inode, "nodeValue");
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof IDispatch) {
            return (String)Helper.get((IDispatch)object, "data");
        }
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        Helper.put(this.inode, "nodeValue", string);
    }

    public short getNodeType() {
        return this.nodeType;
    }

    public Node getParentNode() {
        if (this.parentNode == null) {
            IDispatch iDispatch = (IDispatch)Helper.get(this.inode, "parentNode");
            this.parentNode = this.newNode(iDispatch);
        }
        return this.parentNode;
    }

    public NodeList getChildNodes() {
        if (this.cachedChildNodes != null) {
            this.cachedChildNodes.initialize();
        } else {
            this.cachedChildNodes = new NodeListNextSiblingImpl(this);
        }
        return this.cachedChildNodes;
    }

    public Node getFirstChild() {
        IDispatch iDispatch = (IDispatch)Helper.get(this.inode, "firstChild");
        return this.newNode(iDispatch);
    }

    public Node getLastChild() {
        IDispatch iDispatch = (IDispatch)Helper.get(this.inode, "lastChild");
        return this.newNode(iDispatch);
    }

    public Node getPreviousSibling() {
        IDispatch iDispatch = (IDispatch)Helper.get(this.inode, "previousSibling");
        return this.newNode(iDispatch);
    }

    public Node getNextSibling() {
        IDispatch iDispatch = (IDispatch)Helper.get(this.inode, "nextSibling");
        return this.newNode(iDispatch);
    }

    public NamedNodeMap getAttributes() {
        IDispatch iDispatch = (IDispatch)Helper.get(this.inode, "attributes");
        if (iDispatch == null) {
            return null;
        }
        return new NamedNodeMapImpl(this, iDispatch);
    }

    public Document getOwnerDocument() {
        return this.doc;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (!(node instanceof NodeImpl) || !(node2 instanceof NodeImpl)) {
            Helper.notSupported();
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        NodeImpl nodeImpl2 = (NodeImpl)node2;
        IDispatch iDispatch = (IDispatch)this.inode.invoke("insertBefore", new Object[]{nodeImpl.getINode(), nodeImpl2.getINode()});
        return this.newNode(iDispatch);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (!(node instanceof NodeImpl) || !(node2 instanceof NodeImpl)) {
            Helper.notSupported();
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        NodeImpl nodeImpl2 = (NodeImpl)node2;
        IDispatch iDispatch = (IDispatch)this.inode.invoke("replaceChild", new Object[]{nodeImpl.getINode(), nodeImpl2.getINode()});
        return this.newNode(iDispatch);
    }

    public Node removeChild(Node node) throws DOMException {
        if (!(node instanceof NodeImpl)) {
            Helper.notSupported();
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        IDispatch iDispatch = (IDispatch)this.inode.invoke1("removeChild", (Object)nodeImpl.getINode());
        return this.newNode(iDispatch);
    }

    public Node appendChild(Node node) throws DOMException {
        if (!(node instanceof NodeImpl)) {
            Helper.notSupported();
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        IDispatch iDispatch = (IDispatch)this.inode.invoke1("appendChild", (Object)nodeImpl.getINode());
        return this.newNode(iDispatch);
    }

    public boolean hasChildNodes() {
        Boolean bl = (Boolean)this.inode.invoke0("hasChildNodes");
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public Node cloneNode(boolean bl) {
        IDispatch iDispatch = (IDispatch)this.inode.invoke1("cloneNode", (Object)bl);
        return this.newNode(iDispatch);
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public String getNamespaceURI() {
        String string = (String)Helper.get(this.inode, "namespaceURI");
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "";
        }
        return string;
    }

    public String getPrefix() {
        String string = this.getNodeName();
        if (string == null) {
            return "";
        }
        int n = string.indexOf(":");
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public void setPrefix(String string) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        String string = this.getNodeName();
        if (string == null) {
            return "";
        }
        int n = string.indexOf(":");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public boolean hasAttributes() {
        IDispatch iDispatch = (IDispatch)Helper.get(this.inode, "attributes");
        return iDispatch != null;
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        return 0;
    }

    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void setTextContent(String string) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public boolean isSameNode(Node node) {
        return this == node;
    }

    public String lookupPrefix(String string) {
        throw new UnsupportedOperationException();
    }

    public boolean isDefaultNamespace(String string) {
        throw new UnsupportedOperationException();
    }

    public String lookupNamespaceURI(String string) {
        throw new UnsupportedOperationException();
    }

    public boolean isEqualNode(Node node) {
        throw new UnsupportedOperationException();
    }

    public Object getFeature(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public Object getUserData(String string) {
        throw new UnsupportedOperationException();
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return null;
    }

    public String getLinkURI() {
        String string = (String)Helper.get(this.inode, "href");
        if (string == null) {
            Node node = this.getParentNode();
            if (node instanceof INodeEx) {
                return ((INodeEx)node).getLinkURI();
            }
            return null;
        }
        return string;
    }

    public short getHeadingLevel() {
        Node node = this.getParentNode();
        if (node instanceof INodeEx) {
            return ((INodeEx)node).getHeadingLevel();
        }
        return 0;
    }

    public AnalyzedResult analyze(AnalyzedResult analyzedResult) {
        if (!Vocabulary.isValidNode().eval((IEvalTarget)this)) {
            return analyzedResult;
        }
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof INodeEx) {
                analyzedResult = ((INodeEx)node).analyze(analyzedResult);
            }
            node = node.getNextSibling();
        }
        return analyzedResult;
    }

    public void setText(String string) {
        if (Helper.hasProperty(this.inode, "value")) {
            Helper.put(this.inode, "value", string);
        } else {
            NodeImpl nodeImpl = (NodeImpl)this.getParentNode();
            if ("TEXTAREA".equals(nodeImpl.getLocalName())) {
                IDispatch iDispatch = (IDispatch)nodeImpl.inode.invoke0("createTextRange");
                Helper.put(iDispatch, "text", string);
            }
        }
    }

    public String getText() {
        String string = "";
        if (Helper.hasProperty(this.inode, "value")) {
            Object object = Helper.get(this.inode, "value");
            if (object instanceof String) {
                return (String)object;
            }
            if (object != null) {
                return object.toString();
            }
        } else {
            NodeImpl nodeImpl = (NodeImpl)this.getParentNode();
            if ("TEXTAREA".equals(nodeImpl.getLocalName())) {
                IDispatch iDispatch = (IDispatch)nodeImpl.inode.invoke0("createTextRange");
                string = (String)Helper.get(iDispatch, "text");
            }
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public int getNth() {
        IDispatch iDispatch = this.inode;
        int n = 1;
        while (iDispatch != null) {
            iDispatch = (IDispatch)Helper.get(iDispatch, "previousSibling");
            ++n;
        }
        return n;
    }

    public String getUniqueID() {
        return (String)Helper.get(this.inode, "uniqueID");
    }

    public String[] getStillPictureData() {
        String[] stringArray = new String[3];
        stringArray[1] = (String)Helper.get(this.inode, "src");
        stringArray[2] = "";
        String string = (String)Helper.get(this.inode, "mimeType");
        stringArray[0] = string == null ? "" : ((string = string.toUpperCase()).contains("GIF") ? "image/gif" : (string.contains("JPEG") ? "image/jpeg" : (string.contains("PNG") ? "image/png" : "")));
        return stringArray;
    }
}

