/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.impl.DTDParseException;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLEntityDeclaration;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLEntityReference;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.UnsynchronizedHashtable;

public class SGMLDocTypeDef {
    private static Hashtable<String, SGMLDocTypeDef> table = new Hashtable();
    private SGMLParser parser;
    protected UnsynchronizedHashtable elementDefs = new UnsynchronizedHashtable();
    private Hashtable<String, SGMLEntityReference> entityRefs = new Hashtable();
    private Hashtable<String, SGMLEntityDeclaration> entityDecls = new Hashtable();
    private String id;
    private int elementNum;
    int maxSeqLength = 0;

    protected SGMLDocTypeDef(SGMLParser sGMLParser, String string) {
        this.parser = sGMLParser;
        this.id = string;
    }

    static SGMLDocTypeDef createAnonymous(SGMLParser sGMLParser) {
        return new SGMLDocTypeDef(sGMLParser, "anonymous");
    }

    public ElementDefinition createElementDefinition(String string) {
        ElementDefinition elementDefinition = this.elementDefs.get(string = string.toUpperCase());
        if (elementDefinition == null) {
            elementDefinition = new ElementDefinition(string);
            this.elementDefs.put(string, elementDefinition);
        }
        return elementDefinition;
    }

    public static SGMLDocTypeDef createPublic(String string, SGMLParser sGMLParser) {
        return new SGMLDocTypeDef(sGMLParser, string);
    }

    static void putPublic(String string, SGMLDocTypeDef sGMLDocTypeDef) {
        table.put(string, sGMLDocTypeDef);
    }

    public ElementDefinition getElementDefinition(String string) {
        return this.elementDefs.get(string);
    }

    public ElementDefinition getElementDefinition(int n) {
        try {
            return this.elementDefs.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    SGMLEntityDeclaration getEntityDeclaration(String string) {
        return this.entityDecls.get(string);
    }

    SGMLEntityReference getEntityReference(String string) throws ParseException {
        SGMLEntityReference sGMLEntityReference = this.entityRefs.get(string);
        if (sGMLEntityReference == null) {
            SGMLEntityDeclaration sGMLEntityDeclaration = this.getEntityDeclaration(string);
            if (sGMLEntityDeclaration == null) {
                throw new DTDParseException("No Entity Definition: " + string);
            }
            sGMLEntityReference = new SGMLEntityReference(string, sGMLEntityDeclaration);
            this.entityRefs.put(string, sGMLEntityReference);
        }
        return sGMLEntityReference;
    }

    public static SGMLDocTypeDef getPublic(String string) {
        return table.get(string);
    }

    void putEntityDeclaration(String string, String string2) {
        if (this.entityDecls.get(string) != null) {
            return;
        }
        SGMLEntityDeclaration sGMLEntityDeclaration = new SGMLEntityDeclaration(string, string2, this);
        this.entityDecls.put(string, sGMLEntityDeclaration);
    }

    void putPublicEntity(String string, String string2, String string3) {
        if (this.entityDecls.get(string) != null) {
            return;
        }
        class PUBLICEntity
        extends SGMLEntityDeclaration {
            String filename;

            Reader getReplacementReader() throws IOException {
                return SGMLDocTypeDef.this.parser.getResource(this.filename);
            }

            PUBLICEntity(String string, String string2, String string3, SGMLDocTypeDef sGMLDocTypeDef2) {
                super(string, string2, sGMLDocTypeDef2);
                this.filename = string3;
            }
        }
        this.entityDecls.put(string, new PUBLICEntity(string, string2, string3, this));
    }

    public String toString() {
        return this.id;
    }

    public boolean singleton(String string) {
        ElementDefinition elementDefinition = this.getElementDefinition(string);
        return elementDefinition != null && elementDefinition.isSingleton();
    }

    public int getElementCount() {
        return this.elementNum;
    }

    void rehash() {
        this.elementNum = this.elementDefs.size();
        int n = this.elementNum + 2;
        int n2 = this.elementNum - 1;
        while (n2 >= 0) {
            this.elementDefs.get(n2).rehash(n);
            --n2;
        }
    }
}

