/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import org.eclipse.actf.visualization.internal.engines.voicebrowser.Context;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.DomUtil;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.IElementRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Packet;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StaticBUTTONRenderer
implements IElementRenderer {
    public PacketCollection getPacketCollectionIn(Element element, Context context, String string, MessageCollection messageCollection) {
        try {
            this.setContextIn(element, context);
            NamedNodeMap namedNodeMap = element.getAttributes();
            String string2 = null;
            String string3 = null;
            Node node = namedNodeMap.getNamedItem("type");
            if (node != null) {
                string2 = node.getNodeValue();
                if (string2.length() > 0) {
                    if (string2.equals("submit")) {
                        string3 = this.inputTypeSubmit(element, namedNodeMap, messageCollection, string);
                    } else if (string2.equals("reset")) {
                        string3 = this.inputTypeReset(element, namedNodeMap, messageCollection, string);
                    } else if (string2.equals("button")) {
                        string3 = this.inputTypeButton(element, namedNodeMap, messageCollection, string);
                    }
                }
            } else {
                string3 = this.inputTypeButton(element, namedNodeMap, messageCollection, string);
            }
            if (OutLoud.jwat_mode == 2) {
                context.setLineDelimiter(true);
                context.setStartSelect(true);
            }
            if (string3 != null) {
                string3 = string3.trim();
                if (DomUtil.isDisabled(element)) {
                    string3 = "(disabled)" + string3;
                }
                return new PacketCollection(new Packet(element, string3, context, true));
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private String inputTypeSubmit(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        String string2 = null;
        String string3 = null;
        Node node = namedNodeMap.getNamedItem("VALUE");
        if (node != null) {
            string3 = node.getNodeValue();
        }
        if (string3 != null && string3.length() > 0) {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "submit", "hasstr", "name=str1", string3);
            if (string2 == null) {
                string2 = "[" + string3 + ": Submit button.]";
            }
        } else {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "submit", "nostr");
            if (string2 == null) {
                string2 = "[Submit button.]";
            }
        }
        return string2;
    }

    private String inputTypeReset(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        String string2 = null;
        String string3 = null;
        Node node = namedNodeMap.getNamedItem("VALUE");
        if (node != null) {
            string3 = node.getNodeValue();
        }
        if (string3 != null && string3.length() > 0) {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "reset", "hasstr", "name=str1", string3);
            if (string2 == null) {
                string2 = "[" + string3 + ": Reset button.]";
            }
        } else {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "reset", "nostr");
            if (string2 == null) {
                string2 = "[Reset button.]";
            }
        }
        return string2;
    }

    private String inputTypeButton(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        String string2 = null;
        String string3 = null;
        Node node = namedNodeMap.getNamedItem("VALUE");
        if (node != null) {
            string3 = node.getNodeValue();
        }
        if (string3 != null && string3.length() > 0) {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "button", "hasstr", "name=str1", string3);
            if (string2 == null) {
                string2 = "[" + string3 + ": Button.]";
            }
        } else {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "button", "nostr");
            if (string2 == null) {
                string2 = "[Button.]";
            }
        }
        return string2;
    }

    public PacketCollection getPacketCollectionOut(Element element, Context context, String string, MessageCollection messageCollection) {
        this.setContextOut(element, context);
        return null;
    }

    public void setContextIn(Element element, Context context) {
        context.setGoChild(true);
        context.setLineDelimiter(false);
        context.setLinkTag(true);
    }

    public void setContextOut(Element element, Context context) {
        context.setGoChild(true);
        context.setLineDelimiter(true);
        context.setLinkTag(false);
    }
}

