/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomUtil {
    protected static int tab;
    protected static int cnt;
    private static NodeList FormChildren;

    static {
        FormChildren = null;
    }

    public DomUtil() {
        tab = 0;
        cnt = 0;
        FormChildren = null;
    }

    public static void recursiveWalk(Node node, int n) {
        DomUtil.getNodeInfo(node, n);
        ++tab;
        cnt = 0;
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            DomUtil.recursiveWalk(node2, cnt);
            node2 = node2.getNextSibling();
            ++cnt;
        }
        --tab;
    }

    public static String getString(Node node) {
        String string = null;
        if (node != null) {
            string = "[" + node.getNodeName() + "] [" + node.getNodeValue() + "]";
        }
        return string;
    }

    private static void getNodeInfo(Node node, int n) {
        DomUtil.tabbing();
        String string = node.getNodeName();
        if (node.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = ((Element)node).getAttributes();
            if (namedNodeMap.getLength() > 0) {
                String string2 = "<" + string + ":" + node.getNodeValue();
                int n2 = 0;
                while (n2 < namedNodeMap.getLength()) {
                    Attr attr = (Attr)namedNodeMap.item(n2);
                    string2 = String.valueOf(string2) + "," + attr.getName() + "=" + attr.getValue();
                    ++n2;
                }
                string2 = String.valueOf(string2) + ">";
                System.out.println(string2);
            } else {
                System.out.println("<" + string + ":" + node.getNodeValue() + ">");
            }
        } else {
            System.out.println("<" + string + ":" + node.getNodeValue() + ">");
        }
    }

    private static void tabbing() {
        int n = 0;
        while (n < tab) {
            System.out.print("\t");
            ++n;
        }
    }

    public static boolean isNameAttr(Node node) {
        NamedNodeMap namedNodeMap;
        Node node2;
        return node != null && node.getNodeType() == 1 && node.getNodeName().toLowerCase().equals("a") && (node2 = (namedNodeMap = node.getAttributes()).getNamedItem("name")) != null;
    }

    public static void dumpPC(PacketCollection packetCollection) {
        if (packetCollection == null) {
            return;
        }
        if (packetCollection.size() > 0) {
            int n = 0;
            while (n < packetCollection.size()) {
                IPacket iPacket = (IPacket)packetCollection.get(n);
                String string = iPacket.getText();
                System.out.println("[" + n + "] <" + string + ">");
                ++n;
            }
        }
    }

    public static void setFormList(Node node) {
        if (node != null) {
            FormChildren = ((Element)node).getElementsByTagName("form");
        }
    }

    public static int getFormNum(Element element) {
        if (FormChildren != null && FormChildren.getLength() > 0) {
            int n = 0;
            while (n < FormChildren.getLength()) {
                if (element == (Element)FormChildren.item(n)) {
                    return n + 1;
                }
                ++n;
            }
        }
        return 0;
    }
}

