/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.internal.util;

import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.actf.visualization.gui.TargetWindowDataProvider;
import org.eclipse.actf.visualization.gui.internal.GuiTargetWindowData;
import org.eclipse.actf.visualization.gui.internal.util.TargetWindowDataCollector;
import org.eclipse.actf.visualization.gui.internal.util.WebBrowserUtil;
import org.eclipse.swt.widgets.Composite;

public class TargetWindow {
    private static Object currentElement = null;

    public static void setCurrentElement(Object object) {
        currentElement = object;
    }

    private static void update() {
        if (currentElement == null) {
            TargetWindow.setCurrentElement(TargetWindowDataCollector.getDefaultElement());
        }
    }

    public static boolean isEmbeddedBrowser() {
        TargetWindow.update();
        return TargetWindow.isEmbeddedBrowser(currentElement);
    }

    public static int getWindowHandle() {
        TargetWindow.update();
        return TargetWindow.getWindowHandle(currentElement);
    }

    public static String getID() {
        TargetWindow.update();
        return TargetWindow.getID(currentElement);
    }

    public static int getRootWindow() {
        TargetWindow.update();
        return TargetWindow.getRootWindow(currentElement);
    }

    private static IModelService getModelService(Object object) {
        if (object instanceof IModelService) {
            return (IModelService)object;
        }
        if (object instanceof TargetWindowDataProvider) {
            return ((TargetWindowDataProvider)object).getActiveModelService();
        }
        return null;
    }

    private static int getWindowHandle(Object object) {
        IModelService iModelService = TargetWindow.getModelService(object);
        if (iModelService != null) {
            Composite composite = iModelService.getTargetComposite();
            if (composite != null) {
                return composite.handle;
            }
            Object object2 = iModelService.getAttribute("WindowHandle");
            if (object2 instanceof Integer) {
                return (Integer)object2;
            }
        }
        return 0;
    }

    public static boolean isEmbeddedBrowser(Object object) {
        IModelService iModelService = TargetWindow.getModelService(object);
        if (iModelService != null) {
            return iModelService.getTargetComposite() != null;
        }
        return false;
    }

    private static boolean isBrowser(Object object) {
        IModelService iModelService = TargetWindow.getModelService(object);
        if (iModelService instanceof GuiTargetWindowData) {
            return ((GuiTargetWindowData)iModelService).isBrowser();
        }
        return iModelService instanceof IWebBrowserACTF;
    }

    public static String getTitle(Object object) {
        IModelService iModelService = TargetWindow.getModelService(object);
        if (iModelService != null) {
            return iModelService.getTitle();
        }
        return null;
    }

    public static String getID(Object object) {
        IModelService iModelService = TargetWindow.getModelService(object);
        if (iModelService != null) {
            return iModelService.getID();
        }
        return null;
    }

    public static int getRootWindow(Object object) {
        int n;
        int n2 = TargetWindow.getWindowHandle(object);
        if (TargetWindow.isBrowser(object) && (n = TargetWindow.findBrowserChildren(n2)) != 0) {
            return n;
        }
        return n2;
    }

    private static int findBrowserChildren(int n) {
        if (n != 0) {
            String string = WindowUtil.GetWindowClassName((int)n);
            if (WebBrowserUtil.isBrowserClass(string)) {
                return n;
            }
            int n2 = WindowUtil.GetChildWindow((int)n);
            while (n2 != 0) {
                int n3 = TargetWindow.findBrowserChildren(n2);
                if (n3 != 0) {
                    return n3;
                }
                n2 = WindowUtil.GetNextWindow((int)n2);
            }
        }
        return 0;
    }
}

