/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision.ui.preferences;

import java.io.File;
import java.io.InputStream;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.PageImageFactory;
import org.eclipse.actf.visualization.lowvision.LowVisionVizPlugin;
import org.eclipse.actf.visualization.lowvision.ui.internal.Messages;
import org.eclipse.actf.visualization.lowvision.ui.internal.PartControlLowVision;
import org.eclipse.actf.visualization.lowvision.util.ParamLowVision;
import org.eclipse.actf.visualization.lowvision.util.SimulateLowVision;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class LowVisionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = LowVisionPreferencePage.class.getName();
    private static final String EYESIGHT_1_0_JP = "1.0";
    private static final String EYESIGHT_0_5_JP = "0.5";
    private static final String EYESIGHT_0_1_JP = "0.1";
    private static final String EYESIGHT_1_0 = "20/20";
    private static final String EYESIGHT_0_5 = "20/40";
    private static final String EYESIGHT_0_1 = "20/200";
    private static final String COLOR_VISION_1 = Messages.DialogSettingLowVision_Protan;
    private static final String COLOR_VISION_2 = Messages.DialogSettingLowVision_Deutan;
    private static final String COLOR_VISION_3 = Messages.DialogSettingLowVision_Tritan;
    private Button _eyesightCheckButton;
    private Label _eyeSightLabel;
    private Slider _eyeSightSlider;
    private Group _colorvisionGroup;
    private Button _colorvisionCheckButton;
    private Button _colorvision1RadioButton;
    private Button _colorvision2RadioButton;
    private Button _colorvision3RadioButton;
    private Button _colorfilterCheckButton;
    private Label _colorfilterNumLabel;
    private Slider _colorFilterSlider;
    private IPageImage _samplePageImage;
    private ImageData[] _sampleImageData;
    private Image _beforeSimulateImage;
    private ImageData _beforeSimulateImageData;
    private Canvas _beforeSimulateImageCanvas;
    private Image _afterSimulateImage;
    private ImageData _afterSimulateImageData;
    private ImageData[] _afterSimulateImageDataArray;
    private Canvas _afterSimulateImageCanvas;
    private ParamLowVision _currentSetting = null;
    private ParamLowVision _appSetting = null;
    private PartControlLowVision _partRightLowVision;
    private File simulationImageFile;

    public void init(IWorkbench iWorkbench) {
        this._appSetting = ParamLowVision.getDefaultInstance();
        this._currentSetting = (ParamLowVision)this._appSetting.clone();
        this.initSampleImage();
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.createSettingControlsPart(composite2);
        this.createSampleImagePart(composite2);
        return composite;
    }

    public boolean performOk() {
        this.setNewValue(this._appSetting);
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    private void initSampleImage() {
        Bundle bundle = LowVisionVizPlugin.getDefault().getBundle();
        try {
            this._samplePageImage = PageImageFactory.createPageImage((InputStream)FileLocator.openStream((Bundle)bundle, (IPath)new Path("vizResources/images/LowVisionSample.bmp"), (boolean)false));
        }
        catch (Exception exception) {
            this._samplePageImage = PageImageFactory.createPageImage();
        }
        this._sampleImageData = new ImageData[0];
        try {
            ImageLoader imageLoader = new ImageLoader();
            this._sampleImageData = imageLoader.load(FileLocator.openStream((Bundle)bundle, (IPath)new Path("vizResources/images/LowVisionSample.bmp"), (boolean)false));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.simulationImageFile == null) {
            try {
                this.simulationImageFile = LowVisionVizPlugin.createTempFile("preference", ".bmp");
            }
            catch (Exception exception) {}
        }
    }

    private void createSettingControlsPart(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.createEyeSightControl(composite2);
        new Label(composite2, 0);
        this.createColorVisionControl(composite2);
        new Label(composite2, 0);
        this.createColorFilterControl(composite2);
    }

    private void createEyeSightControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this._eyesightCheckButton = new Button(composite2, 32);
        this._eyesightCheckButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this._eyesightCheckButton.setText(Messages.DialogSettingLowVision_Eyesight_9);
        this._eyesightCheckButton.setSelection(this._appSetting.useEyeSight());
        this._eyesightCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (LowVisionPreferencePage.this._partRightLowVision != null && LowVisionPreferencePage.this._partRightLowVision.isChildThread()) {
                    LowVisionPreferencePage.this._eyeSightSlider.setVisible(((Button)selectionEvent.widget).getSelection());
                } else {
                    LowVisionPreferencePage.this._eyeSightSlider.setEnabled(((Button)selectionEvent.widget).getSelection());
                }
                LowVisionPreferencePage.this.doSimulate();
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite3.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 0);
        label.setText(EYESIGHT_0_1);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Label label2 = new Label(composite3, 0);
        label2.setText(EYESIGHT_0_5);
        GridData gridData = new GridData(0x1000000, 0x1000000, true, false);
        label2.setLayoutData((Object)gridData);
        Label label3 = new Label(composite3, 0);
        label3.setText(EYESIGHT_1_0);
        label3.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        Label label4 = new Label(composite3, 0);
        label4.setText(EYESIGHT_0_1_JP);
        label4.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Label label5 = new Label(composite3, 0);
        label5.setText(EYESIGHT_0_5_JP);
        gridData = new GridData(0x1000000, 0x1000000, true, false);
        label5.setLayoutData((Object)gridData);
        Label label6 = new Label(composite3, 0);
        label6.setText(EYESIGHT_1_0_JP);
        label6.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this._eyeSightSlider = new Slider(composite3, 0);
        this._eyeSightSlider.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this._eyeSightSlider.setMinimum(10);
        this._eyeSightSlider.setMaximum(101);
        this._eyeSightSlider.setIncrement(10);
        this._eyeSightSlider.setPageIncrement(10);
        this._eyeSightSlider.setThumb(1);
        this._eyeSightSlider.setSelection(this._appSetting.getEyeSightValue());
        if (this._partRightLowVision != null && this._partRightLowVision.isChildThread()) {
            this._eyeSightSlider.setVisible(this._eyesightCheckButton.getSelection());
        } else {
            this._eyeSightSlider.setEnabled(this._eyesightCheckButton.getSelection());
        }
        this._eyeSightSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LowVisionPreferencePage.this.doSimulate();
            }
        });
        this._eyeSightLabel = new Label(composite2, 0);
        gridData = new GridData(32);
        gridData.horizontalIndent = 10;
        gridData.widthHint = 25;
        this._eyeSightLabel.setLayoutData((Object)gridData);
    }

    private void createColorVisionControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite2.setLayout((Layout)new GridLayout());
        this._colorvisionCheckButton = new Button(composite2, 32);
        this._colorvisionCheckButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._colorvisionCheckButton.setText(Messages.DialogSettingLowVision_Color_Vision_Deficiency_10);
        this._colorvisionCheckButton.setSelection(this._appSetting.useColorVision());
        this._colorvisionCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LowVisionPreferencePage.this._colorvisionGroup.setEnabled(((Button)selectionEvent.widget).getSelection());
                LowVisionPreferencePage.this._colorvision1RadioButton.setEnabled(((Button)selectionEvent.widget).getSelection());
                LowVisionPreferencePage.this._colorvision2RadioButton.setEnabled(((Button)selectionEvent.widget).getSelection());
                LowVisionPreferencePage.this._colorvision3RadioButton.setEnabled(((Button)selectionEvent.widget).getSelection());
                LowVisionPreferencePage.this.doSimulate();
            }
        });
        this._colorvisionGroup = new Group(composite2, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this._colorvisionGroup.setLayoutData((Object)gridData);
        this._colorvisionGroup.setLayout((Layout)new GridLayout());
        this._colorvision1RadioButton = new Button((Composite)this._colorvisionGroup, 16);
        this._colorvision1RadioButton.setText(COLOR_VISION_1);
        this._colorvision2RadioButton = new Button((Composite)this._colorvisionGroup, 16);
        this._colorvision2RadioButton.setText(COLOR_VISION_2);
        this._colorvision3RadioButton = new Button((Composite)this._colorvisionGroup, 16);
        this._colorvision3RadioButton.setText(COLOR_VISION_3);
        int n = this._appSetting.getColorVisionValue();
        switch (n) {
            case 1: {
                this._colorvision1RadioButton.setSelection(true);
                break;
            }
            case 2: {
                this._colorvision2RadioButton.setSelection(true);
                break;
            }
            case 3: {
                this._colorvision3RadioButton.setSelection(true);
                break;
            }
            default: {
                this._colorvision1RadioButton.setSelection(true);
            }
        }
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LowVisionPreferencePage.this.doSimulate();
                if (!((Button)selectionEvent.widget).getSelection()) {
                    return;
                }
            }
        };
        this._colorvision1RadioButton.addSelectionListener((SelectionListener)selectionAdapter);
        this._colorvision2RadioButton.addSelectionListener((SelectionListener)selectionAdapter);
        this._colorvision3RadioButton.addSelectionListener((SelectionListener)selectionAdapter);
        this._colorvisionGroup.setEnabled(this._colorvisionCheckButton.getSelection());
        this._colorvision1RadioButton.setEnabled(this._colorvisionCheckButton.getSelection());
        this._colorvision2RadioButton.setEnabled(this._colorvisionCheckButton.getSelection());
        this._colorvision3RadioButton.setEnabled(this._colorvisionCheckButton.getSelection());
    }

    private void createColorFilterControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this._colorfilterCheckButton = new Button(composite2, 32);
        this._colorfilterCheckButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this._colorfilterCheckButton.setText(Messages.DialogSettingLowVision_Crystalline_lens);
        this._colorfilterCheckButton.setSelection(this._appSetting.useEyeSight());
        this._colorfilterCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (LowVisionPreferencePage.this._partRightLowVision != null && LowVisionPreferencePage.this._partRightLowVision.isChildThread()) {
                    LowVisionPreferencePage.this._colorFilterSlider.setVisible(((Button)selectionEvent.widget).getSelection());
                } else {
                    LowVisionPreferencePage.this._colorFilterSlider.setEnabled(((Button)selectionEvent.widget).getSelection());
                }
                LowVisionPreferencePage.this.doSimulate();
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite3.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 0);
        label.setText(Messages.DialogSettingLowVision_60);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Label label2 = new Label(composite3, 0);
        label2.setText(Messages.DialogSettingLowVision_40);
        label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        Label label3 = new Label(composite3, 0);
        label3.setText(Messages.DialogSettingLowVision_20);
        label3.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this._colorFilterSlider = new Slider(composite3, 0);
        this._colorFilterSlider.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this._colorFilterSlider.setMinimum(60);
        this._colorFilterSlider.setMaximum(101);
        this._colorFilterSlider.setIncrement(5);
        this._colorFilterSlider.setPageIncrement(10);
        this._colorFilterSlider.setThumb(1);
        this._colorFilterSlider.setSelection(this._appSetting.getColorFilterValue());
        if (this._partRightLowVision != null && this._partRightLowVision.isChildThread()) {
            this._colorFilterSlider.setVisible(this._colorfilterCheckButton.getSelection());
        } else {
            this._colorFilterSlider.setEnabled(this._colorfilterCheckButton.getSelection());
        }
        this._colorFilterSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LowVisionPreferencePage.this.doSimulate();
            }
        });
        this._colorfilterNumLabel = new Label(composite2, 0);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = 10;
        gridData.widthHint = 25;
        this._colorfilterNumLabel.setLayoutData((Object)gridData);
    }

    private void createSampleImagePart(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(Messages.DialogSettingLowVision_Original__24);
        this._beforeSimulateImageCanvas = new Canvas(composite2, 0x100000);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 320;
        gridData.heightHint = 130;
        this._beforeSimulateImageCanvas.setLayoutData((Object)gridData);
        this._beforeSimulateImageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (LowVisionPreferencePage.this._beforeSimulateImage != null) {
                    LowVisionPreferencePage.this.paintBeforeSimulateImage(paintEvent);
                }
            }
        });
        Label label2 = new Label(composite2, 0);
        label2.setText(" ");
        gridData = new GridData();
        gridData.heightHint = 20;
        label2.setLayoutData((Object)gridData);
        Label label3 = new Label(composite2, 0);
        label3.setText(Messages.DialogSettingLowVision_After_simulation);
        this._afterSimulateImageCanvas = new Canvas(composite2, 0x100000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 320;
        gridData.heightHint = 130;
        this._afterSimulateImageCanvas.setLayoutData((Object)gridData);
        this._afterSimulateImageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (LowVisionPreferencePage.this._afterSimulateImage != null) {
                    LowVisionPreferencePage.this.paintAfterSimulateImage(paintEvent);
                }
            }
        });
        this.initImageBeforeSimulate(composite);
        this.doSimulate();
    }

    private void initImageBeforeSimulate(Composite composite) {
        try {
            int n = 0;
            while (n < this._sampleImageData.length) {
                this.displayImageBeforeSimulate(this._sampleImageData[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void displayImageBeforeSimulate(ImageData imageData) {
        if (this._beforeSimulateImage != null) {
            this._beforeSimulateImage.dispose();
        }
        try {
            this._beforeSimulateImage = new Image((Device)this.getShell().getDisplay(), imageData);
            this._beforeSimulateImageData = imageData;
        }
        catch (SWTException sWTException) {
            sWTException.printStackTrace();
            this._beforeSimulateImage = null;
            return;
        }
        this._beforeSimulateImageCanvas.redraw();
    }

    private void displayImageAfterSimulate(ImageData imageData) {
        if (this._afterSimulateImage != null) {
            this._afterSimulateImage.dispose();
        }
        try {
            this._afterSimulateImage = new Image((Device)this.getShell().getDisplay(), imageData);
            this._afterSimulateImageData = imageData;
        }
        catch (SWTException sWTException) {
            sWTException.printStackTrace();
            this._afterSimulateImage = null;
            return;
        }
        this._afterSimulateImageCanvas.redraw();
    }

    private void doSimulate() {
        try {
            this.setNewValue(this._currentSetting);
            this._afterSimulateImageDataArray = SimulateLowVision.doSimulate(this._samplePageImage, this._currentSetting, this.simulationImageFile.getAbsolutePath());
            int n = 0;
            while (n < this._afterSimulateImageDataArray.length) {
                this.displayImageAfterSimulate(this._afterSimulateImageDataArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void paintBeforeSimulateImage(PaintEvent paintEvent) {
        paintEvent.gc.drawImage(this._beforeSimulateImage, 0, 0, this._beforeSimulateImageData.width, this._beforeSimulateImageData.height, this._beforeSimulateImageData.x, this._beforeSimulateImageData.y, Math.round(this._beforeSimulateImageData.width), Math.round(this._beforeSimulateImageData.height));
    }

    private void paintAfterSimulateImage(PaintEvent paintEvent) {
        paintEvent.gc.drawImage(this._afterSimulateImage, 0, 0, this._afterSimulateImageData.width, this._afterSimulateImageData.height, this._afterSimulateImageData.x, this._afterSimulateImageData.y, Math.round(this._afterSimulateImageData.width), Math.round(this._afterSimulateImageData.height));
    }

    private void setNewValue(ParamLowVision paramLowVision) {
        String string;
        int n;
        paramLowVision.setEyeSight(this._eyesightCheckButton.getSelection());
        if (paramLowVision.useEyeSight()) {
            paramLowVision.setEyeSightValue(this._eyeSightSlider.getSelection());
            n = this._eyeSightSlider.getSelection();
            string = n < 100 ? "0." + String.valueOf(n) : "1.00";
            this._eyeSightLabel.setText(string);
        } else {
            this._eyeSightLabel.setText("");
        }
        paramLowVision.setColorVision(this._colorvisionCheckButton.getSelection());
        if (paramLowVision.useColorVision()) {
            if (this._colorvision1RadioButton.getSelection()) {
                paramLowVision.setColorVisionValue(1);
            } else if (this._colorvision2RadioButton.getSelection()) {
                paramLowVision.setColorVisionValue(2);
            } else {
                paramLowVision.setColorVisionValue(3);
            }
        }
        paramLowVision.setColorFilter(this._colorfilterCheckButton.getSelection());
        if (paramLowVision.useColorFilter()) {
            paramLowVision.setColorFilterValue(this._colorFilterSlider.getSelection());
            n = 120 - this._colorFilterSlider.getSelection();
            string = String.valueOf(n);
            this._colorfilterNumLabel.setText(string);
        } else {
            this._colorfilterNumLabel.setText("");
        }
    }
}

