/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.problem;

import org.eclipse.actf.visualization.internal.engines.lowvision.Messages;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorLAB;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionRecommendation;

public class EnoughContrastRecommendation
extends LowVisionRecommendation {
    public static final float RECOMMENDED_DELTA_L_FOR_TEXT = 45.0f;
    public static final float MID_L = 50.0f;
    private int originalForegroundColor = -1;
    private int originalBackgroundColor = -1;
    private int recommendedForegroundColor = -1;
    private int recommendedBackgroundColor = -1;

    public EnoughContrastRecommendation(LowVisionProblem lowVisionProblem, int n, int n2) throws LowVisionProblemException {
        super((short)1, lowVisionProblem, Messages.EnoughContrastRecommendation_Provide_enough_contrast_between_foreground_and_background_colors__1);
        this.originalForegroundColor = n;
        this.originalBackgroundColor = n2;
        this.calcRecommendedColors();
    }

    private void calcRecommendedColors() throws LowVisionProblemException {
        if (this.originalForegroundColor == -1 || this.originalBackgroundColor == -1) {
            return;
        }
        try {
            ColorLAB colorLAB = new ColorIRGB(this.originalForegroundColor).toXYZ().toLAB();
            ColorLAB colorLAB2 = new ColorIRGB(this.originalBackgroundColor).toXYZ().toLAB();
            if (ColorLAB.deltaL(colorLAB, colorLAB2) >= 45.0f) {
                this.recommendedForegroundColor = this.originalForegroundColor;
                this.recommendedBackgroundColor = this.originalBackgroundColor;
                return;
            }
            float f = colorLAB.getL();
            float f2 = colorLAB.getA();
            float f3 = colorLAB.getB();
            float f4 = colorLAB2.getL();
            float f5 = colorLAB2.getA();
            float f6 = colorLAB2.getB();
            if (f > f4) {
                if (f4 >= 50.0f) {
                    f4 = f - 45.0f;
                } else if (f <= 50.0f) {
                    f = f4 + 45.0f;
                } else {
                    f = (f + f4 + 45.0f) / 2.0f;
                    f4 = f - 45.0f;
                }
            } else if (f >= 50.0f) {
                f = f4 - 45.0f;
            } else if (f4 <= 50.0f) {
                f4 = f + 45.0f;
            } else {
                f4 = (f + f4 + 45.0f) / 2.0f;
                f = f4 - 45.0f;
            }
            this.recommendedForegroundColor = new ColorLAB(f, f2, f3).toXYZ().toIRGB().toInt();
            this.recommendedBackgroundColor = new ColorLAB(f4, f5, f6).toXYZ().toIRGB().toInt();
        }
        catch (ColorException colorException) {
            colorException.printStackTrace();
            throw new LowVisionProblemException("Error occurred while calculating recommended colors.");
        }
    }

    public int getOriginalForegroundColor() {
        return this.originalForegroundColor;
    }

    public int getOriginalBackgroundColor() {
        return this.originalBackgroundColor;
    }

    public int getRecommendedForegroundColor() {
        return this.recommendedForegroundColor;
    }

    public int getRecommendedBackgroundColor() {
        return this.recommendedBackgroundColor;
    }
}

