/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import org.eclipse.actf.visualization.internal.engines.lowvision.image.Coord;

public class LineSegment {
    public static final short POINT = 0;
    public static final short HORIZONTAL_LINE = 1;
    public static final short VERTICAL_LINE = 2;
    public static final short DIAGONAL_LINE = 3;
    int x0;
    int y0;
    int x1;
    int y1;

    public LineSegment(int n, int n2, int n3, int n4) {
        if (n < n3) {
            this.x0 = n;
            this.y0 = n2;
            this.x1 = n3;
            this.y1 = n4;
        } else if (n > n3) {
            this.x0 = n3;
            this.y0 = n4;
            this.x1 = n;
            this.y1 = n2;
        } else if (n2 <= n4) {
            this.x0 = n;
            this.y0 = n2;
            this.x1 = n3;
            this.y1 = n4;
        } else {
            this.x0 = n3;
            this.y0 = n4;
            this.x1 = n;
            this.y1 = n2;
        }
    }

    public LineSegment(Coord coord, Coord coord2) {
        this(coord.x, coord.y, coord2.x, coord2.y);
    }

    public Coord getLeftPoint() {
        return new Coord(this.x0, this.y0);
    }

    public Coord getRightPoint() {
        return new Coord(this.x1, this.y1);
    }

    public Coord getUpperPoint() {
        if (this.y0 <= this.y1) {
            return new Coord(this.x0, this.y0);
        }
        return new Coord(this.x1, this.y1);
    }

    public Coord getLowerPoint() {
        if (this.y0 > this.y1) {
            return new Coord(this.x0, this.y0);
        }
        return new Coord(this.x1, this.y1);
    }

    public short getType() {
        if (this.x0 == this.x1) {
            if (this.y0 == this.y1) {
                return 0;
            }
            return 2;
        }
        if (this.y0 == this.y1) {
            return 1;
        }
        return 3;
    }

    public boolean isPoint() {
        return this.getType() == 0;
    }

    public boolean isVertical() {
        return this.getType() == 2;
    }

    public boolean isHorizontal() {
        return this.getType() == 1;
    }

    public boolean isDiagonal() {
        return this.getType() == 3;
    }

    public double getLength() {
        int n = this.x1 - this.x0 + 1;
        int n2 = this.y1 - this.y0 + 1;
        if (this.x0 == this.x1) {
            return Math.abs(n2);
        }
        if (this.y0 == this.y1) {
            return Math.abs(n);
        }
        return Math.sqrt(n * n + n2 * n2);
    }
}

