/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Coord;

public class LabeledImage {
    public static final short METHOD_8_CONNECTIVITY = 0;
    public static final short METHOD_4_CONNECTIVITY = 1;
    int width;
    int height;
    int[][] label;
    int numComponents;
    ConnectedComponent[] components;
    short method;
    int left;
    int right;
    int top;
    int bottom;
    int count;

    public LabeledImage(BinaryImage binaryImage) {
        this(binaryImage, 0);
    }

    public LabeledImage(BinaryImage binaryImage, short s) {
        int n;
        this.width = binaryImage.width;
        this.height = binaryImage.height;
        this.label = new int[this.height][this.width];
        this.method = s;
        Vector<ConnectedComponent> vector = new Vector<ConnectedComponent>();
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.height) {
            n = 0;
            while (n < this.width) {
                if (binaryImage.data[n3][n] > 0 && this.label[n3][n] == 0) {
                    this.label[n3][n] = n2;
                    this.count = 1;
                    this.labelNeighbor(binaryImage, n, n3, n2, s);
                    ConnectedComponent connectedComponent = new ConnectedComponent(this.left, this.top, this.right - this.left + 1, this.bottom - this.top + 1, this.count);
                    int n4 = this.top;
                    while (n4 <= this.bottom) {
                        int n5 = this.left;
                        while (n5 <= this.right) {
                            if (this.label[n4][n5] == n2) {
                                connectedComponent.shape.data[n4 - this.top][n5 - this.left] = 1;
                            }
                            ++n5;
                        }
                        ++n4;
                    }
                    vector.addElement(connectedComponent);
                    ++n2;
                }
                ++n;
            }
            ++n3;
        }
        this.numComponents = n2 - 1;
        this.components = new ConnectedComponent[this.numComponents];
        n3 = 0;
        if (this.method == 0) {
            n3 = 2;
        } else if (this.method == 1) {
            n3 = 1;
        }
        n = 0;
        while (n < this.numComponents) {
            this.components[n] = (ConnectedComponent)vector.elementAt(n);
            this.components[n].connectivity = (short)n3;
            ++n;
        }
    }

    private void labelNeighbor(BinaryImage binaryImage, int n, int n2, int n3, short s) {
        this.left = n;
        this.right = n;
        this.top = n2;
        this.bottom = n2;
        Stack<Coord> stack = new Stack<Coord>();
        Coord coord = new Coord(n, n2);
        stack.push(coord);
        while (!stack.empty()) {
            Coord coord2;
            Coord coord3 = (Coord)stack.pop();
            int n4 = coord3.x;
            int n5 = coord3.y;
            if (n4 < this.width - 1 && binaryImage.data[n5][n4 + 1] > 0 && this.label[n5][n4 + 1] == 0) {
                this.label[n5][n4 + 1] = n3;
                ++this.count;
                if (this.right < n4 + 1) {
                    this.right = n4 + 1;
                }
                coord2 = new Coord(n4 + 1, n5);
                stack.push(coord2);
            }
            if (n4 > 0 && binaryImage.data[n5][n4 - 1] > 0 && this.label[n5][n4 - 1] == 0) {
                this.label[n5][n4 - 1] = n3;
                ++this.count;
                if (this.left > n4 - 1) {
                    this.left = n4 - 1;
                }
                coord2 = new Coord(n4 - 1, n5);
                stack.push(coord2);
            }
            if (n5 > 0 && binaryImage.data[n5 - 1][n4] > 0 && this.label[n5 - 1][n4] == 0) {
                this.label[n5 - 1][n4] = n3;
                ++this.count;
                if (this.top > n5 - 1) {
                    this.top = n5 - 1;
                }
                coord2 = new Coord(n4, n5 - 1);
                stack.push(coord2);
            }
            if (n5 < this.height - 1 && binaryImage.data[n5 + 1][n4] > 0 && this.label[n5 + 1][n4] == 0) {
                this.label[n5 + 1][n4] = n3;
                ++this.count;
                if (this.bottom < n5 + 1) {
                    this.bottom = n5 + 1;
                }
                coord2 = new Coord(n4, n5 + 1);
                stack.push(coord2);
            }
            if (s != 0) continue;
            if (n5 > 0 && n4 > 0 && binaryImage.data[n5 - 1][n4 - 1] > 0 && this.label[n5 - 1][n4 - 1] == 0) {
                this.label[n5 - 1][n4 - 1] = n3;
                ++this.count;
                if (this.left > n4 - 1) {
                    this.left = n4 - 1;
                }
                if (this.top > n5 - 1) {
                    this.top = n5 - 1;
                }
                coord2 = new Coord(n4 - 1, n5 - 1);
                stack.push(coord2);
            }
            if (n5 > 0 && n4 < this.width - 1 && binaryImage.data[n5 - 1][n4 + 1] > 0 && this.label[n5 - 1][n4 + 1] == 0) {
                this.label[n5 - 1][n4 + 1] = n3;
                ++this.count;
                if (this.right < n4 + 1) {
                    this.right = n4 + 1;
                }
                if (this.top > n5 - 1) {
                    this.top = n5 - 1;
                }
                coord2 = new Coord(n4 + 1, n5 - 1);
                stack.push(coord2);
            }
            if (n5 < this.height - 1 && n4 > 0 && binaryImage.data[n5 + 1][n4 - 1] > 0 && this.label[n5 + 1][n4 - 1] == 0) {
                this.label[n5 + 1][n4 - 1] = n3;
                ++this.count;
                if (this.left > n4 - 1) {
                    this.left = n4 - 1;
                }
                if (this.bottom < n5 + 1) {
                    this.bottom = n5 + 1;
                }
                coord2 = new Coord(n4 - 1, n5 + 1);
                stack.push(coord2);
            }
            if (n5 >= this.height - 1 || n4 >= this.width - 1 || binaryImage.data[n5 + 1][n4 + 1] <= 0 || this.label[n5 + 1][n4 + 1] != 0) continue;
            this.label[n5 + 1][n4 + 1] = n3;
            ++this.count;
            if (this.right < n4 + 1) {
                this.right = n4 + 1;
            }
            if (this.bottom < n5 + 1) {
                this.bottom = n5 + 1;
            }
            coord2 = new Coord(n4 + 1, n5 + 1);
            stack.push(coord2);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[][] getLabel() {
        return this.label;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public ConnectedComponent[] getComponents() {
        return this.components;
    }

    public short getMethod() {
        return this.method;
    }

    public BinaryImage toBinaryImage() {
        BinaryImage binaryImage = new BinaryImage(this.width, this.height);
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                if (this.label[n][n2] != 0) {
                    binaryImage.data[n][n2] = 1;
                }
                ++n2;
            }
            ++n;
        }
        return binaryImage;
    }

    public BufferedImage toBufferedImage() throws ImageException {
        if (this.numComponents >> 24 != 0) {
            throw new ImageException("Too many labels to make bufferedImage.");
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        WritableRaster writableRaster = bufferedImage.copyData(null);
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        int n = 0;
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                nArray[n] = ColorUtil.distinguishableColor(this.label[n2][n3]);
                ++n;
                ++n3;
            }
            ++n2;
        }
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    public void dump(PrintStream printStream, boolean bl) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.dump(printWriter, bl);
    }

    public void dump(PrintWriter printWriter, boolean bl) {
        if (bl) {
            this.dumpLabel(printWriter);
        } else {
            this.dumpComponents(printWriter);
        }
    }

    public void dumpLabel(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.dumpLabel(printWriter);
    }

    public void dumpLabel(PrintWriter printWriter) {
        printWriter.println("-------------------------------");
        printWriter.println("Dumping a labeledImage");
        printWriter.println("Width = " + this.width + ", Height = " + this.height);
        int n = 0;
        while (n < this.height) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < this.width) {
                if (this.label[n][n2] == 0) {
                    stringBuffer.append(".");
                } else {
                    stringBuffer.append("" + this.label[n][n2] % 10);
                }
                ++n2;
            }
            printWriter.println(stringBuffer.toString());
            ++n;
        }
        printWriter.println("-------------------------------");
    }

    public void dumpComponents(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.dumpComponents(printWriter);
    }

    public void dumpComponents(PrintWriter printWriter) {
        printWriter.println("-------------------------------");
        printWriter.println("Dumping components");
        printWriter.println("# of components = " + this.numComponents);
        int n = 0;
        while (n < this.numComponents) {
            this.dumpComponents(printWriter, n);
            ++n;
        }
        printWriter.println("-------------------------------");
    }

    public void dumpComponents(PrintStream printStream, int n) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.dumpComponents(printWriter, n);
    }

    public void dumpComponents(PrintWriter printWriter, int n) {
        printWriter.println("-----");
        printWriter.println("Components # = " + n);
        this.components[n].dump(printWriter);
    }
}

