/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Coord;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.LabeledImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.LineSegment;

public class BinaryImage {
    public static final short METHOD_SPECIFY_FOREGROUND = 0;
    public static final short METHOD_SPECIFY_BACKGROUND = 1;
    public static final int NOT_MEASURED = -1;
    int width;
    int height;
    public byte[][] data;
    private int area = -1;

    public BinaryImage(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.data = new byte[this.height][this.width];
    }

    public BinaryImage(int n, int n2, int[][] nArray, short s, int n3) throws ImageException {
        this(new Int2D(n, n2, nArray), s, n3);
    }

    public BinaryImage(IInt2D iInt2D, short s, int n) {
        this.width = iInt2D.getWidth();
        this.height = iInt2D.getHeight();
        this.data = new byte[this.height][this.width];
        if (s == 0) {
            this.setDataSpecifyForeground(iInt2D, n);
        }
        if (s == 1) {
            this.setDataSpecifyBackground(iInt2D, n);
        }
    }

    private void setDataSpecifyForeground(IInt2D iInt2D, int n) {
        this.area = 0;
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                if (iInt2D.getData()[n2][n3] == n) {
                    this.data[n2][n3] = 1;
                    ++this.area;
                } else {
                    this.data[n2][n3] = 0;
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void setDataSpecifyBackground(IInt2D iInt2D, int n) {
        this.area = 0;
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                if (iInt2D.getData()[n2][n3] == n) {
                    this.data[n2][n3] = 0;
                } else {
                    this.data[n2][n3] = 1;
                    ++this.area;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public BinaryImage(BufferedImage bufferedImage, short s, int n) {
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.data = new byte[this.height][this.width];
        if (s == 0) {
            this.setDataSpecifyForeground(bufferedImage, n);
        }
        if (s == 1) {
            this.setDataSpecifyBackground(bufferedImage, n);
        }
    }

    private void setDataSpecifyForeground(BufferedImage bufferedImage, int n) {
        WritableRaster writableRaster = bufferedImage.copyData(null);
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        this.area = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = 0;
            while (n4 < this.width) {
                if (nArray[n2] == n) {
                    this.data[n3][n4] = 1;
                    ++this.area;
                } else {
                    this.data[n3][n4] = 0;
                }
                ++n2;
                ++n4;
            }
            ++n3;
        }
    }

    private void setDataSpecifyBackground(BufferedImage bufferedImage, int n) {
        WritableRaster writableRaster = bufferedImage.copyData(null);
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        this.area = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = 0;
            while (n4 < this.width) {
                if (nArray[n2] == n) {
                    this.data[n3][n4] = 0;
                } else {
                    this.data[n3][n4] = 1;
                    ++this.area;
                }
                ++n2;
                ++n4;
            }
            ++n3;
        }
    }

    public BinaryImage(int n, int n2, Coord[] coordArray) {
        this(n, n2);
        Coord[] coordArray2 = null;
        int n3 = coordArray.length;
        if (coordArray[0].equals(coordArray[n3 - 1])) {
            coordArray2 = coordArray;
        } else {
            coordArray2 = new Coord[n3 + 1];
            int n4 = 0;
            while (n4 < n3) {
                coordArray2[n4] = coordArray[n4];
                ++n4;
            }
            coordArray2[n3] = coordArray[0];
            ++n3;
        }
        Coord coord = new Coord(-1, -1);
        int n5 = 0;
        while (n5 < this.height) {
            int n6 = 0;
            while (n6 < this.width) {
                this.data[n5][n6] = 1;
                coord.set(n6, n5);
                int n7 = 0;
                while (n7 < n3 - 1) {
                    if (Coord.isLeftToVector(coordArray2[n7], coordArray2[n7 + 1], coord)) {
                        this.data[n5][n6] = 0;
                        break;
                    }
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        this.measureArea();
    }

    public BinaryImage deepCopy() {
        BinaryImage binaryImage = new BinaryImage(this.width, this.height);
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                binaryImage.data[n][n2] = this.data[n][n2];
                ++n2;
            }
            ++n;
        }
        binaryImage.area = this.area;
        return binaryImage;
    }

    public BinaryImage offsetCopy(int n, int n2, int n3, int n4, boolean bl) throws ImageException {
        BinaryImage binaryImage = new BinaryImage(n, n2);
        if (n3 < 0 || n <= n3) {
            throw new ImageException("Bad offset value.");
        }
        if (n4 < 0 || n2 <= n4) {
            throw new ImageException("Bad offset value.");
        }
        int n5 = this.width;
        int n6 = this.height;
        int n7 = n3 + this.width - n;
        int n8 = n4 + this.height - n2;
        if (n7 > 0) {
            if (bl) {
                throw new ImageException("Not enough image area.");
            }
            n5 -= n7;
        }
        if (n8 > 0) {
            if (bl) {
                throw new ImageException("Not enough image area.");
            }
            n6 -= n8;
        }
        int n9 = 0;
        while (n9 < n6) {
            int n10 = 0;
            while (n10 < n5) {
                binaryImage.data[n9 + n4][n10 + n3] = this.data[n9][n10];
                ++n10;
            }
            ++n9;
        }
        return binaryImage;
    }

    public BinaryImage offsetCopy(int n, int n2, int n3, int n4) throws ImageException {
        return this.offsetCopy(n, n2, n3, n4, true);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[][] getData() {
        return this.data;
    }

    public int getArea() {
        if (this.area == -1) {
            this.measureArea();
        }
        return this.area;
    }

    public int measureArea() {
        this.area = 0;
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                if (this.data[n][n2] != 0) {
                    ++this.area;
                }
                ++n2;
            }
            ++n;
        }
        return this.area;
    }

    public boolean equals(BinaryImage binaryImage) {
        if (this.width != binaryImage.width) {
            return false;
        }
        if (this.height != binaryImage.height) {
            return false;
        }
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                if (this.data[n][n2] != binaryImage.data[n][n2]) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public BufferedImage toBufferedImage() {
        return this.toBufferedImage(0, 0xFFFFFF);
    }

    public BufferedImage toBufferedImage(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        WritableRaster writableRaster = bufferedImage.copyData(null);
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.height) {
            int n5 = 0;
            while (n5 < this.width) {
                nArray[n3] = this.data[n4][n5] == 0 ? n2 : n;
                ++n3;
                ++n5;
            }
            ++n4;
        }
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    public LabeledImage labelConnectedComponents() {
        return new LabeledImage(this);
    }

    public LabeledImage labelConnectedComponents(short s) {
        return new LabeledImage(this, s);
    }

    public Coord[] extractPoints() {
        Vector<Coord> vector = new Vector<Coord>();
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                if (this.data[n][n2] != 0) {
                    Coord coord = new Coord(n2, n);
                    vector.addElement(coord);
                }
                ++n2;
            }
            ++n;
        }
        n = vector.size();
        if (n > 0) {
            Coord[] coordArray = new Coord[n];
            int n3 = 0;
            while (n3 < n) {
                coordArray[n3] = (Coord)vector.elementAt(n3);
                ++n3;
            }
            return coordArray;
        }
        return null;
    }

    public void putPoints(Coord[] coordArray) {
        if (coordArray == null || coordArray.length == 0) {
            return;
        }
        int n = coordArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coord coord = coordArray[n2];
            this.data[coord.y][coord.x] = 1;
            ++n2;
        }
    }

    public Coord topLeftPoint() {
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                if (this.data[n][n2] != 0) {
                    return new Coord(n2, n);
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public static BinaryImage subtract(BinaryImage binaryImage, BinaryImage binaryImage2) throws ImageException {
        int n = binaryImage.width;
        int n2 = binaryImage.height;
        if (n != binaryImage2.width || n2 != binaryImage2.height) {
            throw new ImageException("subtract(): Sizes of the two image must be the same");
        }
        BinaryImage binaryImage3 = new BinaryImage(n, n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                if (binaryImage.data[n3][n4] != 0 && binaryImage2.data[n3][n4] == 0) {
                    binaryImage3.data[n3][n4] = 1;
                }
                ++n4;
            }
            ++n3;
        }
        return binaryImage3;
    }

    public BinaryImage subtract(BinaryImage binaryImage) throws ImageException {
        return BinaryImage.subtract(this, binaryImage);
    }

    public LineSegment detectLongestHorizontalLine() {
        return this.detectLongestHorizontalLine(this.height - 1);
    }

    public LineSegment detectLongestHorizontalLine(int n) {
        int n2 = 0;
        Coord coord = new Coord(-1, -1);
        Coord coord2 = new Coord(-1, -1);
        Coord coord3 = new Coord(-1, -1);
        int n3 = 0;
        while (n3 <= n) {
            boolean bl = false;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.width) {
                if (this.data[n3][n5] != 0) {
                    if (bl) {
                        ++n4;
                    } else {
                        bl = true;
                        n4 = 1;
                        coord3.set(n5, n3);
                    }
                } else if (bl) {
                    if (n4 >= n2) {
                        n2 = n4;
                        coord.copy(coord3);
                        coord2.set(n5 - 1, n3);
                    }
                    bl = false;
                }
                ++n5;
            }
            if (bl && n4 >= n2) {
                n2 = n4;
                coord.copy(coord3);
                coord2.set(this.width - 1, n3);
            }
            ++n3;
        }
        if (n2 > 0) {
            return new LineSegment(coord, coord2);
        }
        return null;
    }

    public BinaryImage drawUnderline() throws ImageException {
        return this.drawLongestHorizontalLine();
    }

    public BinaryImage drawLongestHorizontalLine() throws ImageException {
        LineSegment lineSegment = this.detectLongestHorizontalLine();
        if (lineSegment == null) {
            return null;
        }
        if (lineSegment.isVertical() || lineSegment.isDiagonal()) {
            throw new ImageException("Endpoints cannot be successfully detected");
        }
        BinaryImage binaryImage = new BinaryImage(this.width, this.height);
        Coord coord = lineSegment.getLeftPoint();
        Coord coord2 = lineSegment.getRightPoint();
        int n = coord.x;
        while (n <= coord2.x) {
            binaryImage.data[coord.y][n] = 1;
            ++n;
        }
        return binaryImage;
    }

    public BinaryImage drawLongestHorizontalLineWithThick() throws ImageException {
        LineSegment lineSegment = this.detectLongestHorizontalLine();
        if (lineSegment == null) {
            return null;
        }
        if (lineSegment.isVertical() || lineSegment.isDiagonal()) {
            throw new ImageException("Endpoints cannot be successfully detected");
        }
        BinaryImage binaryImage = new BinaryImage(this.width, this.height);
        Coord coord = lineSegment.getLeftPoint();
        Coord coord2 = lineSegment.getRightPoint();
        int n = coord.x;
        while (n <= coord2.x) {
            binaryImage.data[coord.y][n] = 1;
            ++n;
        }
        n = coord.y - 1;
        int n2 = coord.x;
        int n3 = coord2.x;
        while (n > 0) {
            LineSegment lineSegment2 = this.detectLongestHorizontalLine(n);
            if (lineSegment2 == null) break;
            if (lineSegment2.isVertical() || lineSegment2.isDiagonal()) {
                throw new ImageException("Endpoints cannot be successfully detected");
            }
            Coord coord3 = lineSegment.getLeftPoint();
            Coord coord4 = lineSegment.getRightPoint();
            if (coord3.y != n || coord3.x != n2 || coord4.x != n3) break;
            int n4 = coord3.x;
            while (n4 <= coord4.x) {
                binaryImage.data[n][n4] = 1;
                ++n4;
            }
            --n;
        }
        return binaryImage;
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.dump(printWriter);
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("-------------------------------");
        printWriter.println("Dumping a BinaryImage");
        printWriter.println("Width = " + this.width + ", Height = " + this.height);
        int n = 0;
        while (n < this.height) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < this.width) {
                if (this.data[n][n2] == 0) {
                    stringBuffer.append("0");
                } else {
                    stringBuffer.append("1");
                }
                ++n2;
            }
            printWriter.println(stringBuffer.toString());
            ++n;
        }
        printWriter.println("-------------------------------");
    }

    public void dump(PrintStream printStream, int n, int n2, int n3, int n4) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.dump(printWriter, n, n2, n3, n4);
    }

    public void dump(PrintWriter printWriter, int n, int n2, int n3, int n4) {
        printWriter.println("-------------------------------");
        printWriter.println("Dumping a part of a BinaryImage");
        printWriter.println("Image width = " + this.width + ", Image height = " + this.height);
        printWriter.println("Start point = ( " + n + ", " + n2 + ")");
        printWriter.println("Printed width = " + n3 + ", Printed height = " + n4);
        int n5 = 0;
        while (n5 < n4) {
            StringBuffer stringBuffer = new StringBuffer();
            int n6 = 0;
            while (n6 < n3) {
                if (this.data[n5 + n2][n6 + n] == 0) {
                    stringBuffer.append("0");
                } else {
                    stringBuffer.append("1");
                }
                ++n6;
            }
            printWriter.println(stringBuffer.toString());
            ++n5;
        }
        printWriter.println("-------------------------------");
    }
}

