/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.lowvision;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.actf.model.ui.ImagePositionInfo;
import org.eclipse.actf.model.ui.editor.browser.ICurrentStyles;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.DebugUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.DecisionMaker;
import org.eclipse.actf.visualization.internal.engines.lowvision.LowVisionProblemConverter;
import org.eclipse.actf.visualization.internal.engines.lowvision.PageElement;
import org.eclipse.actf.visualization.internal.engines.lowvision.ScoreUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.ImageWriter;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemGroup;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ProblemItemLV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageEvaluation {
    private static final int UNSET = -1;
    private IPageImage pageImage = null;
    private ImagePositionInfo[] tmpInteriorImagePositions = null;
    private PageElement[] pageElements = null;
    private String[] allowedForegroundColors = null;
    private String[] allowedBackgroundColors = null;
    private int pageWidth = -1;
    private int pageHeight = -1;
    private String overallRatingString = "";
    private String overallRatingImageString = "";
    private static final int PROBLEM_MAP_LENGTH = 100;

    public PageEvaluation(IPageImage iPageImage) {
        this.pageImage = iPageImage;
        if (this.pageImage != null) {
            if (this.pageImage.hasInteriorImageArraySet()) {
                try {
                    this.pageImage.extractCharacters();
                }
                catch (ImageException imageException) {
                    imageException.printStackTrace();
                }
            } else if (this.tmpInteriorImagePositions != null) {
                this.pageImage.setInteriorImagePosition(this.tmpInteriorImagePositions);
                this.tmpInteriorImagePositions = null;
                try {
                    this.pageImage.extractCharacters();
                }
                catch (ImageException imageException) {
                    imageException.printStackTrace();
                }
            }
            this.pageWidth = this.pageImage.getWidth();
            this.pageHeight = this.pageImage.getHeight();
        }
    }

    public IPageImage getPageImage() {
        return this.pageImage;
    }

    public ImagePositionInfo[] getInteriorImagePosition() {
        if (this.pageImage == null) {
            return null;
        }
        return this.pageImage.getInteriorImagePosition();
    }

    public void setInteriorImagePosition(ImagePositionInfo[] imagePositionInfoArray) {
        if (this.pageImage != null) {
            this.pageImage.setInteriorImagePosition(imagePositionInfoArray);
            try {
                this.pageImage.extractCharacters();
            }
            catch (ImageException imageException) {
                imageException.printStackTrace();
            }
        } else {
            this.tmpInteriorImagePositions = imagePositionInfoArray;
        }
    }

    public void setCurrentStyles(Map<String, ICurrentStyles> map) {
        Set<String> set = map.keySet();
        int n = set.size();
        this.pageElements = new PageElement[n];
        int n2 = 0;
        for (String string : set) {
            try {
                this.pageElements[n2] = new PageElement(string, map.get(string));
            }
            catch (ImageException imageException) {
                imageException.printStackTrace();
                this.pageElements[n2] = null;
            }
            ++n2;
        }
    }

    public String[] getAllowedForegroundColors() {
        return this.allowedForegroundColors;
    }

    public String[] getAllowedBackgroundColors() {
        return this.allowedBackgroundColors;
    }

    public void setAllowedColors(String[] stringArray, String[] stringArray2) {
        this.allowedForegroundColors = stringArray;
        this.allowedBackgroundColors = stringArray2;
    }

    public List<IProblemItem> check(LowVisionType lowVisionType, String string, int n) {
        List<IProblemItem> list = new ArrayList<IProblemItem>();
        if (this.pageImage != null) {
            try {
                list = this.pageImage.checkCharacters(lowVisionType, string, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.pageElements != null) {
            LowVisionProblemGroup[] lowVisionProblemGroupArray;
            Vector<LowVisionProblemGroup> vector = new Vector<LowVisionProblemGroup>();
            int n2 = this.pageElements.length;
            int n3 = 0;
            while (n3 < n2) {
                lowVisionProblemGroupArray = this.pageElements[n3];
                if (lowVisionProblemGroupArray != null) {
                    LowVisionProblem[] lowVisionProblemArray = lowVisionProblemGroupArray.check(lowVisionType, this.allowedForegroundColors, this.allowedBackgroundColors);
                    int n4 = 0;
                    if (lowVisionProblemArray != null) {
                        n4 = lowVisionProblemArray.length;
                    }
                    int n5 = 0;
                    while (n5 < n4) {
                        Vector<LowVisionProblem> vector2 = new Vector<LowVisionProblem>();
                        vector2.addElement(lowVisionProblemArray[n5]);
                        LowVisionProblemGroup lowVisionProblemGroup = null;
                        try {
                            lowVisionProblemGroup = new LowVisionProblemGroup(vector2);
                            vector.addElement(lowVisionProblemGroup);
                        }
                        catch (LowVisionProblemException lowVisionProblemException) {
                            lowVisionProblemException.printStackTrace();
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
            n3 = vector.size();
            lowVisionProblemGroupArray = new LowVisionProblemGroup[n3];
            vector.toArray(lowVisionProblemGroupArray);
            list.addAll(LowVisionProblemConverter.convert(lowVisionProblemGroupArray, string, n));
        }
        this.calcOverallRating(list);
        return list;
    }

    private void calcOverallRating(List<IProblemItem> list) {
        int n = 0;
        for (IProblemItem iProblemItem : list) {
            if (!(iProblemItem instanceof ProblemItemLV)) continue;
            n += ((IProblemItemImage)iProblemItem).getSeverityLV();
        }
        this.overallRatingString = ScoreUtil.getScoreString(n);
        this.overallRatingImageString = ScoreUtil.getScoreImageString(n);
    }

    public void unsupportedModeReport(File file) throws LowVisionException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML>\n<HEAD>\n<TITLE>Report from LowVision Evaulator</TITLE>\n");
        stringBuffer.append("</HEAD><BODY>");
        stringBuffer.append("</BODY>\n</HTML>\n");
        if (file != null) {
            try {
                PrintWriter printWriter = new PrintWriter(file);
                printWriter.println(stringBuffer.toString());
                printWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new LowVisionException("Could not write to " + file);
            }
        }
    }

    public void generateReport(String string, String string2, String string3, List<IProblemItem> list) throws LowVisionException {
        String string4;
        boolean bl = true;
        if (this.pageImage == null) {
            bl = false;
        }
        if (!(string4 = string).endsWith(File.separator)) {
            string4 = String.valueOf(string4) + File.separator;
        }
        String string5 = String.valueOf(string4) + string2;
        String string6 = String.valueOf(string4) + string3;
        int n = 0;
        if (list != null) {
            n = list.size();
        }
        Int2D int2D = null;
        if (bl) {
            int n2;
            int n3;
            int n4;
            int n5 = this.pageWidth;
            if (this.pageWidth > this.pageHeight) {
                n5 = this.pageHeight;
            }
            if ((n4 = (int)Math.ceil((double)n5 / 100.0)) <= 0) {
                throw new LowVisionException("scale is out of range: " + n4);
            }
            int n6 = (int)Math.ceil((double)this.pageWidth / (double)n4);
            int n7 = (int)Math.ceil((double)this.pageHeight / (double)n4);
            int2D = new Int2D(n6, n7);
            int n8 = 0;
            while (n8 < n) {
                if (list.get(n8) instanceof ProblemItemLV) {
                    int n9;
                    ProblemItemLV problemItemLV = (ProblemItemLV)list.get(n8);
                    n3 = problemItemLV.getX();
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if ((n2 = problemItemLV.getY()) < 0) {
                        n2 = 0;
                    }
                    int n10 = problemItemLV.getWidth();
                    int n11 = problemItemLV.getHeight();
                    int n12 = n3 + n10;
                    if (this.pageWidth < n12) {
                        n12 = this.pageWidth;
                    }
                    if (this.pageHeight < (n9 = n2 + n11)) {
                        n9 = this.pageHeight;
                    }
                    int n13 = n2;
                    while (n13 < n9) {
                        int n14 = n3;
                        while (n14 < n12) {
                            try {
                                int[] nArray = int2D.getData()[n13 / n4];
                                int n15 = n14 / n4;
                                nArray[n15] = nArray[n15] + problemItemLV.getSeverityLV();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                DebugUtil.errMsg(this, "i=" + n14 + ", j=" + n13 + ", groupX=" + n3 + ", groupY=" + n2 + ", groupWidth=" + n10 + ", groupHeight=" + n11 + ", pageWidth=" + this.pageWidth + ", pageHeight=" + this.pageHeight);
                                throw new LowVisionException("Error while making problem map");
                            }
                            ++n14;
                        }
                        ++n13;
                    }
                }
                ++n8;
            }
            double d = n4 * n4;
            n3 = 0;
            while (n3 < n7) {
                n2 = 0;
                while (n2 < n6) {
                    int2D.getData()[n3][n2] = DecisionMaker.getScoreMapColor((double)int2D.getData()[n3][n2] / 100.0 / d);
                    ++n2;
                }
                ++n3;
            }
            try {
                ImageWriter.writeBufferedImage(int2D.toBufferedImage(), string6);
            }
            catch (LowVisionIOException lowVisionIOException) {
                lowVisionIOException.printStackTrace();
                throw new LowVisionException("An IO error occurred while writing the problem map file of this page.");
            }
        }
        int2D = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML>\n<HEAD>\n<TITLE>Report from LowVision Evaulator</TITLE>\n");
        stringBuffer.append("<STYLE type=\"text/css\">\n");
        stringBuffer.append("IMG {border:2 solid black}\n");
        stringBuffer.append("</STYLE>\n");
        stringBuffer.append("</HEAD><BODY>");
        stringBuffer.append("<DIV>\nOverall rating: <IMG src=\"./img/" + this.overallRatingImageString + "\" alt=\"" + this.overallRatingString + "\"></DIV>\n");
        stringBuffer.append("<HR>");
        stringBuffer.append("<DIV align=\"center\">\n");
        if (bl) {
            stringBuffer.append("Problem Map<BR>\n");
            stringBuffer.append("<IMG src=\"" + string3 + "\" alt=\"score map\" ");
            if (this.pageWidth >= this.pageHeight) {
                stringBuffer.append("width=\"75%\"");
            } else {
                stringBuffer.append("height=\"75%\"");
            }
            stringBuffer.append(">\n");
        } else {
            stringBuffer.append("Problem map is not available for this page.");
        }
        stringBuffer.append("</DIV>\n");
        stringBuffer.append("</BODY>\n</HTML>\n");
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string5));
            printWriter.println(stringBuffer.toString());
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LowVisionException("Could not write to " + string5);
        }
    }
}

