/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.AccessibleObjectFactory;
import org.eclipse.actf.accservice.swtbridge.MSAA;
import org.eclipse.actf.accservice.swtbridge.event.IAccessibleEventListener;
import org.eclipse.actf.accservice.swtbridge.event.IAccessibleEventMonitor;
import org.eclipse.actf.accservice.swtbridge.ia2.Accessible2;
import org.eclipse.actf.accservice.swtbridge.ia2.TextSegment;
import org.eclipse.actf.ai.voice.VoiceUtil;
import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.GuiPlugin;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.internal.util.ScreenReaderRenderer;
import org.eclipse.actf.visualization.gui.internal.util.TTSMonitor;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAEventView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSAAEventView
extends ViewPart
implements IMSAAEventView,
IAccessibleEventListener {
    private StyledText text;
    private Action clearAction;
    private Action speakEventAction;
    private Action openPreferencesAction;
    private Action eventFilterAction;
    private Action showTTSEventAction;
    private boolean showRawEvent = false;
    private IPreferenceStore preferenceStore = GuiPlugin.getDefault().getPreferenceStore();
    private static final int[] SUPPORTED_EVENTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 32768, 32769, 32770, 32771, 32772, 32773, 32774, 32775, 32776, 32777, 32778, 32779, 32780, 32781, 32782, 32783, 32784, 32785, 32786, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290};
    private static final int[] DEFAULT_EVENTS = new int[]{32773};
    private IAccessibleEventMonitor monitor = null;
    private boolean refreshing = false;
    private Map<Integer, Boolean> filters = this.getDefaultFilters();
    private long lastTime = 0L;

    public void createPartControl(Composite composite) {
        this.text = new StyledText(composite, 832);
        this.text.setEditable(false);
        this.text.setLayout((Layout)new GridLayout());
        this.text.setLayoutData((Object)new GridData());
        this.resetFont();
        this.preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("MSAAEventView_Font".equals(propertyChangeEvent.getProperty())) {
                    MSAAEventView.this.resetFont();
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.reset();
        TTSMonitor.startThread(this);
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                MSAAEventView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.text);
        this.text.setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.eventFilterAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.speakEventAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.openPreferencesAction);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.clearAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.clearAction);
    }

    private void makeActions() {
        this.clearAction = new Action(){

            public void run() {
                MSAAEventView.this.text.setText("");
            }
        };
        this.clearAction.setText(Messages.msaa_clear);
        this.clearAction.setToolTipText(Messages.msaa_clear_tip);
        this.clearAction.setImageDescriptor(GuiImages.IMAGE_CLEAR);
        this.speakEventAction = new Action(Messages.msaa_speak_event, 2){

            public void run() {
            }
        };
        final Shell shell = this.getViewSite().getShell();
        this.openPreferencesAction = new Action(Messages.msaa_preferences){

            public void run() {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.actf.visualization.gui.preferences.GuiPreferencePage", null, null).open();
            }
        };
        this.showTTSEventAction = new Action(Messages.msaa_showTTSEvents, 2){

            public void run() {
            }
        };
        this.showTTSEventAction.setChecked(true);
        this.eventFilterAction = new Action(Messages.msaa_filters_menu){

            public void run() {
                EventFiltersDialog eventFiltersDialog = new EventFiltersDialog(shell, MSAAEventView.this.intArrayToObjectArray(SUPPORTED_EVENTS), MSAAEventView.this.showRawEvent);
                if (eventFiltersDialog.open() == 0) {
                    MSAAEventView.this.filters.clear();
                    Object[] objectArray = eventFiltersDialog.getResult();
                    int n = 0;
                    while (n < objectArray.length) {
                        MSAAEventView.this.filters.put((Integer)objectArray[n], Boolean.TRUE);
                        ++n;
                    }
                    MSAAEventView.this.showRawEvent = eventFiltersDialog.getShowDetails();
                    if (MSAAEventView.this.monitor != null) {
                        MSAAEventView.this.monitor.installEventHook(MSAAEventView.this, MSAAEventView.this.getFilter());
                    }
                }
            }
        };
    }

    private Integer[] intArrayToObjectArray(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            integerArray[n] = new Integer(nArray[n]);
            ++n;
        }
        return integerArray;
    }

    private void resetFont() {
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)this.preferenceStore, (String)"MSAAEventView_Font");
        this.text.setFont(new Font((Device)this.text.getDisplay(), fontData));
    }

    public void setFocus() {
        this.text.setFocus();
    }

    public void dispose() {
        super.dispose();
        TTSMonitor.stopThread();
        if (this.monitor != null) {
            this.monitor.removeEventHook();
            this.monitor = null;
        }
    }

    private void showEventInfo(int n, int n2, int n3, int n4, AccessibleObject accessibleObject) {
        if (this.text.isDisposed() || this.text.isFocusControl()) {
            return;
        }
        boolean bl = false;
        if (accessibleObject == null) {
            accessibleObject = AccessibleObjectFactory.getAccessibleObjectFromEvent(n2, n3, n4);
            bl = true;
        }
        if (accessibleObject != null) {
            Object object;
            Object object2;
            boolean bl2;
            int n5 = accessibleObject.getAccRole();
            int n6 = accessibleObject.getAccState();
            boolean bl3 = bl2 = (n6 & 0x8000) != 0;
            if (!bl2) {
                switch (n) {
                    case 32773: {
                        object2 = accessibleObject.getAccessible2();
                        if (object2 == null || (object = (IMSAAOutlineView)MSAAViewRegistory.findView(IGuiViewIDs.ID_OUTLINEVIEW)) == null) break;
                        AccessibleObject accessibleObject2 = MSAAEventView.getCachedChildFromUID(MSAAViewRegistory.rootObject, object2.getUniqueID());
                        object.setSelection(accessibleObject2);
                        if (accessibleObject2 != null) break;
                        bl = !MSAAViewRegistory.showProperties(accessibleObject);
                        break;
                    }
                    case 32780: {
                        break;
                    }
                    case 32778: 
                    case 32782: {
                        bl2 = (4 & n6) == 0;
                        break;
                    }
                    case 32768: {
                        if (16 == n5 && (MSAAEventView.validate(MSAAViewRegistory.rootObject, 5, 10) || this.delayedRefresh(2000))) break;
                        bl2 = true;
                    }
                }
            }
            if (!bl2 && this.getFilterEnabled(n)) {
                Object object3;
                this.checkInterval();
                int n7 = -1;
                if (43 == n5) {
                    n7 = MSAAEventView.getChildIndex(accessibleObject);
                }
                if (this.showRawEvent) {
                    this.text.append("event=" + MSAA.getEventTypeText(n) + ",  " + "accName=" + accessibleObject.getAccName() + ",  " + "accRole=" + accessibleObject.getRoleText() + ",  " + "accState=" + MSAA.getStateText(n6) + "(0x" + Integer.toHexString(n6) + ")\n");
                }
                object = null;
                boolean bl4 = true;
                switch (n) {
                    case 283: {
                        object3 = accessibleObject.getAccessibleText();
                        if (object3 != null) {
                            TextSegment textSegment;
                            Point point = object3.getSelection(0);
                            if (point != null) {
                                object = object3.getTextRange(point.x, point.y);
                            } else {
                                textSegment = object3.getTextAtIndex(object3.getCaretPosition(), 0);
                                if (textSegment != null) {
                                    object = textSegment.text;
                                }
                            }
                            if (object != null) {
                                this.text.append(" ");
                                textSegment = new StyleRange();
                                ((StyleRange)textSegment).background = Display.getCurrent().getSystemColor(7);
                                ((StyleRange)textSegment).start = this.text.getCharCount();
                                ((StyleRange)textSegment).length = ((String)object).length();
                                this.text.append((String)object);
                                this.text.setStyleRange((StyleRange)textSegment);
                            }
                        }
                        bl4 = false;
                        break;
                    }
                    case 289: {
                        bl4 = false;
                    }
                }
                if (bl4 && ((String)(object = ((ScreenReaderRenderer)(object3 = new ScreenReaderRenderer(this.text, null))).renderEvent(n))).length() == 0) {
                    object = ((ScreenReaderRenderer)object3).renderItem(accessibleObject, false, n7);
                }
                this.text.setSelection(this.text.getCharCount());
                if (this.speakEventAction.isChecked() && object != null && ((String)object).length() > 0) {
                    VoiceUtil.getVoice().speak((String)object, true);
                }
            }
            if (bl) {
                object2 = accessibleObject.getCachedParent();
                try {
                    if (object2 != null) {
                        object2.dispose();
                    } else {
                        accessibleObject.dispose();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private boolean delayedRefresh(int n) {
        if (this.refreshing) {
            return false;
        }
        this.refreshing = true;
        this.text.getDisplay().timerExec(n, new Runnable(){

            public void run() {
                try {
                    if (!MSAAEventView.this.text.isDisposed()) {
                        MSAAViewRegistory.refreshRootObject();
                    }
                }
                finally {
                    MSAAEventView.this.refreshing = false;
                }
            }
        });
        return true;
    }

    private Map<Integer, Boolean> getDefaultFilters() {
        HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
        int n = 0;
        while (n < DEFAULT_EVENTS.length) {
            hashMap.put(new Integer(DEFAULT_EVENTS[n]), Boolean.TRUE);
            ++n;
        }
        return hashMap;
    }

    public boolean getFilterEnabled(int n) {
        Integer n2 = new Integer(n);
        Boolean bl = this.filters.get(n2);
        if (bl == null) {
            bl = Boolean.FALSE;
            this.filters.put(n2, bl);
        }
        return bl;
    }

    @Override
    public void setTTSText(final String string) {
        if (string != null && string.length() > 0) {
            this.text.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (MSAAEventView.this.text.isFocusControl() || !MSAAEventView.this.showTTSEventAction.isChecked()) {
                        return;
                    }
                    MSAAEventView.this.checkInterval();
                    StyleRange styleRange = new StyleRange();
                    styleRange.foreground = Display.getCurrent().getSystemColor(6);
                    styleRange.start = MSAAEventView.this.text.getCharCount();
                    styleRange.length = string.length();
                    MSAAEventView.this.text.append(string);
                    MSAAEventView.this.text.setStyleRange(styleRange);
                    MSAAEventView.this.text.setSelection(MSAAEventView.this.text.getCharCount());
                    if (MSAAEventView.this.speakEventAction.isChecked()) {
                        VoiceUtil.getVoice().speak(string, true);
                    }
                }
            });
        }
    }

    private void checkInterval() {
        long l = System.currentTimeMillis();
        if (0L != this.lastTime) {
            try {
                long l2 = Math.abs(l - this.lastTime);
                if (l2 > 1000L) {
                    String string = MessageFormat.format((String)Messages.msaa_ns_passed, (Object[])new Object[]{new Float((float)l2 / 1000.0f)});
                    StyleRange styleRange = new StyleRange();
                    styleRange.foreground = Display.getCurrent().getSystemColor(15);
                    styleRange.start = this.text.getCharCount();
                    int n = styleRange.start - 1;
                    if (n > 0 && !"\n".equals(this.text.getText(n, n))) {
                        this.text.append("\n");
                    }
                    this.text.append(string);
                    this.text.append("\n");
                    styleRange.length = this.text.getCharCount() - styleRange.start;
                    this.text.setStyleRange(styleRange);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.lastTime = l;
    }

    @Override
    public void handleEvent(final int n, final int n2, final int n3, final int n4, final AccessibleObject accessibleObject) {
        if (this.checkShowInfo(n, n2)) {
            this.text.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MSAAEventView.this.showEventInfo(n, n2, n3, n4, accessibleObject);
                }
            });
        }
    }

    private Set<Integer> getFilter() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Integer n : this.filters.keySet()) {
            Boolean bl = this.filters.get(n);
            if (bl == null || !bl.booleanValue()) continue;
            hashSet.add(n);
        }
        hashSet.add(new Integer(32768));
        return hashSet;
    }

    private boolean checkShowInfo(int n, int n2) {
        int n3;
        boolean bl = false;
        if (MSAAViewRegistory.getUpdateRef() == 0 && MSAAViewRegistory.rootObject != null && MSAA.getEventTypeText(n) != null && (n3 = MSAAViewRegistory.rootObject.getWindow()) != 0) {
            bl = 32773 == n && WindowUtil.isPopupMenu((int)n2);
            int n4 = n2;
            while (!bl && n4 != 0) {
                bl = n3 == n4;
                n4 = WindowUtil.GetParentWindow((int)n4);
            }
        }
        return bl;
    }

    private static AccessibleObject getCachedChildFromUID(AccessibleObject accessibleObject, int n) {
        Accessible2 accessible2 = accessibleObject.getAccessible2();
        if (accessible2 != null && n == accessible2.getUniqueID()) {
            return accessibleObject;
        }
        AccessibleObject[] accessibleObjectArray = accessibleObject.getCachedChildren();
        int n2 = 0;
        while (n2 < accessibleObjectArray.length) {
            AccessibleObject accessibleObject2 = MSAAEventView.getCachedChildFromUID(accessibleObjectArray[n2], n);
            if (accessibleObject2 != null) {
                return accessibleObject2;
            }
            ++n2;
        }
        return null;
    }

    private static int getChildIndex(AccessibleObject accessibleObject) {
        AccessibleObject accessibleObject2 = null;
        try {
            AccessibleObject accessibleObject3 = accessibleObject.getCachedParent();
            if (accessibleObject3 == null && (accessibleObject3 = (accessibleObject2 = accessibleObject.getAccParent())) == null) {
                return 0;
            }
            AccessibleObject[] accessibleObjectArray = accessibleObject3.getChildren();
            Rectangle rectangle = accessibleObject.getAccLocation();
            if (rectangle != null) {
                int n = 0;
                while (n < accessibleObjectArray.length) {
                    if (accessibleObject.equals(accessibleObjectArray[n]) || rectangle.equals((Object)accessibleObjectArray[n].getAccLocation())) {
                        int n2 = n;
                        return n2;
                    }
                    ++n;
                }
            }
        }
        finally {
            if (accessibleObject2 != null) {
                try {
                    accessibleObject2.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return 0;
    }

    private static boolean validate(AccessibleObject accessibleObject, int n, int n2) {
        if (accessibleObject.getAccName() == null && accessibleObject.getAccLocation() == null && accessibleObject.getAccKeyboardShortcut() == null) {
            return false;
        }
        AccessibleObject accessibleObject2 = accessibleObject.getCachedParent();
        AccessibleObject[] accessibleObjectArray = accessibleObject.getCachedChildren();
        if (accessibleObject2 == null && accessibleObjectArray.length == 0) {
            return false;
        }
        if (n-- > 0) {
            AccessibleObject accessibleObject3;
            int n3 = accessibleObjectArray.length;
            int n4 = Math.min(n3, n2);
            int n5 = 0;
            while (n5 < n4) {
                accessibleObject3 = accessibleObjectArray[n5];
                if (accessibleObject3 != null && !MSAAEventView.validate(accessibleObject3, n, n2)) {
                    return false;
                }
                ++n5;
            }
            if ((n4 = n3 - n4) > 0) {
                n5 = 0;
                while (n5 < n4) {
                    accessibleObject3 = accessibleObjectArray[n3 - 1 - n5];
                    if (accessibleObject3 != null && !MSAAEventView.validate(accessibleObject3, n, n2)) {
                        return false;
                    }
                    ++n5;
                }
            }
        }
        return true;
    }

    @Override
    public void reset() {
        if (this.monitor != null) {
            this.monitor.removeEventHook();
            this.monitor = null;
        }
        this.monitor = AccessibleObjectFactory.getAccessibleEventMonitor();
        if (this.monitor != null) {
            this.monitor.installEventHook(this, this.getFilter());
        }
    }

    class EventFiltersContentProvider
    implements IStructuredContentProvider {
        EventFiltersContentProvider() {
        }

        public Object[] getElements(Object object) {
            if (object instanceof Integer[]) {
                return (Object[])object;
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }
    }

    class EventFiltersDialog
    extends ListSelectionDialog {
        private boolean showDetails;
        private Button showDetailsButton;

        public EventFiltersDialog(Shell shell, Integer[] integerArray, boolean bl) {
            super(shell, (Object)integerArray, (IStructuredContentProvider)new EventFiltersContentProvider(), (ILabelProvider)new EventFiltersLabelProvider(), Messages.msaa_filters_message);
            this.setTitle(Messages.msaa_filters_title);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n = 0;
            while (n < integerArray.length) {
                if (MSAAEventView.this.getFilterEnabled(integerArray[n])) {
                    arrayList.add(integerArray[n]);
                }
                ++n;
            }
            this.setInitialElementSelections(arrayList);
            this.showDetails = bl;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            Control[] controlArray = composite2.getChildren();
            Composite composite3 = (Composite)controlArray[controlArray.length - 1];
            Button button = new Button(composite3, 8);
            button.setText(Messages.msaa_filters_default);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    EventFiltersDialog.this.getViewer().setCheckedElements((Object[])MSAAEventView.this.intArrayToObjectArray(DEFAULT_EVENTS));
                    EventFiltersDialog.this.showDetailsButton.setSelection(false);
                }
            });
            this.showDetailsButton = new Button(composite2, 32);
            this.showDetailsButton.setText(Messages.msaa_showRawEvents);
            this.showDetailsButton.setSelection(this.showDetails);
            this.showDetailsButton.setFont(composite.getFont());
            this.showDetailsButton.moveAbove((Control)composite3);
            ++((GridLayout)composite3.getLayout()).numColumns;
            button.moveAbove(null);
            return composite2;
        }

        protected void okPressed() {
            this.showDetails = this.showDetailsButton.getSelection();
            super.okPressed();
        }

        public boolean getShowDetails() {
            return this.showDetails;
        }
    }

    class EventFiltersLabelProvider
    extends LabelProvider {
        EventFiltersLabelProvider() {
        }

        public String getText(Object object) {
            if (object instanceof Integer) {
                return MSAA.getEventTypeText((Integer)object);
            }
            return null;
        }
    }
}

