/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.eclipse.actf.model.internal.flash.proxy.SWFUtil;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPLocalServer;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyConnection;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyTranscoder;
import org.eclipse.actf.util.httpproxy.proxy.ISecretManager;
import org.eclipse.actf.util.httpproxy.util.HTTPUtil;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.httpproxy.util.ParseURI;

public class HTTPLocalServerSWF
implements IHTTPLocalServer {
    private static final String OK = "OK";
    private static final String RESPONSE_200 = "200";
    private static final boolean LOCAL_FILE_ACCESS = false;
    private static final int HTTP_WELL_KNOWN_PORT = 80;
    private static final byte[] MIME_TYPE_APPLICATION_XML_A = "application/xml".getBytes();
    private static final Logger LOGGER = Logger.getLogger(HTTPLocalServerSWF.class);
    private static HashMap<String, MIMEType> mimeTypeMap = new HashMap();
    private static byte[] bridgeInitSwf;
    private static byte[] bridgeInitSwfV9;
    private int swfORBPort = -1;

    public static void addMIMEType(String string, String string2, String string3) {
        mimeTypeMap.put(string, new MIMEType(string, string2, string3));
    }

    public static MIMEType getMIMEType(String string) {
        return mimeTypeMap.get(string);
    }

    private static byte[] readBridgeSWFFile(InputStream inputStream) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new byte[0];
        }
    }

    public static void setBridgeInitSwf(InputStream inputStream) {
        bridgeInitSwf = HTTPLocalServerSWF.readBridgeSWFFile(inputStream);
    }

    public static void setBridgeInitSwfV9(InputStream inputStream) {
        bridgeInitSwfV9 = HTTPLocalServerSWF.readBridgeSWFFile(inputStream);
    }

    private IHTTPResponseMessage processBridgeInitSwf(IHTTPRequestMessage iHTTPRequestMessage) {
        IHTTPResponseMessage iHTTPResponseMessage = HTTPUtil.createHTTPResponseInMemoryMessage((long)iHTTPRequestMessage.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])bridgeInitSwf);
        iHTTPResponseMessage.setHeader(IHTTPHeader.CONTENT_TYPE_A, SWFUtil.MIME_TYPE_APPLICATION_X_SHOCKWAVE_FLASH_A);
        return iHTTPResponseMessage;
    }

    private IHTTPResponseMessage processBridgeInitSwfV9(IHTTPRequestMessage iHTTPRequestMessage) {
        IHTTPResponseMessage iHTTPResponseMessage = HTTPUtil.createHTTPResponseInMemoryMessage((long)iHTTPRequestMessage.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])bridgeInitSwfV9);
        iHTTPResponseMessage.setHeader(IHTTPHeader.CONTENT_TYPE_A, SWFUtil.MIME_TYPE_APPLICATION_X_SHOCKWAVE_FLASH_A);
        return iHTTPResponseMessage;
    }

    private IHTTPResponseMessage processLoadVarsForSwf(IHTTPRequestMessage iHTTPRequestMessage, ISecretManager iSecretManager) {
        IHTTPResponseMessage iHTTPResponseMessage = HTTPUtil.createHTTPResponseInMemoryMessage((long)iHTTPRequestMessage.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])iSecretManager.requestSecret());
        iHTTPResponseMessage.setHeader(IHTTPHeader.CONTENT_TYPE_A, SWFUtil.MIME_TYPE_APPLICATION_X_WWW_FORM_URLENCODED_A);
        return iHTTPResponseMessage;
    }

    private IHTTPResponseMessage processSwfCrossDomainPolicyFile(IHTTPRequestMessage iHTTPRequestMessage) {
        LOGGER.info("Request crossdomain.xml policy file.");
        String string = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<cross-domain-policy><allow-access-from domain=\"*\"/></cross-domain-policy>\n";
        IHTTPResponseMessage iHTTPResponseMessage = HTTPUtil.createHTTPResponseInMemoryMessage((long)iHTTPRequestMessage.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])string.getBytes());
        iHTTPResponseMessage.setHeader(IHTTPHeader.CONTENT_TYPE_A, MIME_TYPE_APPLICATION_XML_A);
        return iHTTPResponseMessage;
    }

    private IHTTPResponseMessage processLocalFile(int n, IHTTPRequestMessage iHTTPRequestMessage, String string, IHTTPProxyTranscoder iHTTPProxyTranscoder) {
        String string2;
        MIMEType mIMEType;
        int n2;
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        LOGGER.info("Local Server Mode. Send:" + string);
        File file = new File(string);
        if (!file.canRead()) {
            return null;
        }
        int n3 = (int)file.length();
        byte[] byArray = new byte[n3];
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray, 0, n3);
            }
            catch (Exception exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {}
        IHTTPResponseMessage iHTTPResponseMessage = HTTPUtil.createHTTPResponseInMemoryMessage((long)iHTTPRequestMessage.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])byArray);
        int n4 = string.lastIndexOf(".");
        if (n4 > 0 && n4 > (n2 = string.lastIndexOf("/")) && (mIMEType = HTTPLocalServerSWF.getMIMEType(string2 = string.substring(n4 + 1))) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(mIMEType.type).append('/').append(mIMEType.subtype);
            iHTTPResponseMessage.setHeader(IHTTPHeader.CONTENT_TYPE_A, stringBuffer.toString().getBytes());
        }
        if (iHTTPProxyTranscoder != null) {
            iHTTPResponseMessage = iHTTPProxyTranscoder.transcode(n, iHTTPRequestMessage, iHTTPResponseMessage);
        }
        return iHTTPResponseMessage;
    }

    public boolean processRequest(int n, IHTTPProxyConnection iHTTPProxyConnection, IHTTPRequestMessage iHTTPRequestMessage, IHTTPProxyTranscoder iHTTPProxyTranscoder) throws InterruptedException, IOException {
        IHTTPHeader iHTTPHeader;
        String string;
        if (!"GET".equals(iHTTPRequestMessage.getMethodAsString())) {
            return false;
        }
        String string2 = iHTTPRequestMessage.getRequestURIString();
        String string3 = ParseURI.getAuthority((String)string2);
        String string4 = ParseURI.getAbsolutePath((String)string2);
        if (string3 != null) {
            string = string3;
        } else {
            iHTTPHeader = iHTTPRequestMessage.getHeader(IHTTPHeader.HOST_A);
            if (iHTTPHeader == null) {
                return false;
            }
            string = new String(iHTTPHeader.getValue());
        }
        String string5 = ParseURI.parseHost((String)string);
        int n2 = ParseURI.parsePort((String)string, (int)80);
        iHTTPHeader = null;
        if (string4.endsWith("Eclipse-ACTF-SWF-Initialize-Bridge-Package-1082017309130187472.swf")) {
            iHTTPHeader = this.processBridgeInitSwf(iHTTPRequestMessage);
        } else if (string4.endsWith("bridge_as3.swf")) {
            iHTTPHeader = this.processBridgeInitSwfV9(iHTTPRequestMessage);
        } else if (string4.endsWith("Eclipse-ACTF-SWF-LoadVars-1082017309130187472.txt")) {
            iHTTPHeader = this.processLoadVarsForSwf(iHTTPRequestMessage, iHTTPProxyConnection.getSecretManager());
        } else {
            if (!"localhost".equals(string5)) {
                return false;
            }
            if (n2 == 80 && "/crossdomain.xml".equals(string4)) {
                iHTTPHeader = this.processSwfCrossDomainPolicyFile(iHTTPRequestMessage);
            } else {
                return false;
            }
        }
        if (iHTTPHeader == null) {
            HTTPUtil.sendFailedToClient((IHTTPProxyConnection)iHTTPProxyConnection, (IHTTPRequestMessage)iHTTPRequestMessage);
            return true;
        }
        try {
            iHTTPProxyConnection.sendResponse(0L, (IHTTPResponseMessage)iHTTPHeader);
        }
        catch (TimeoutException timeoutException) {
            LOGGER.fatal("Timeout in local server mode", (Throwable)timeoutException);
        }
        return true;
    }

    public int getSwfORBPort() {
        if (this.swfORBPort < 0) {
            throw new IllegalStateException("swfORBPort is not set");
        }
        return this.swfORBPort;
    }

    public void setSwfORBPort(int n) {
        this.swfORBPort = n;
    }

    public HTTPLocalServerSWF() {
        HTTPLocalServerSWF.addMIMEType("html", "text", "html");
        HTTPLocalServerSWF.addMIMEType("htm", "text", "html");
        HTTPLocalServerSWF.addMIMEType("js", "application", "x-javascript");
        HTTPLocalServerSWF.addMIMEType("swf", "application", "x-shockwave-flash");
        HTTPLocalServerSWF.addMIMEType("gif", "image", "gif");
        HTTPLocalServerSWF.addMIMEType("jpeg", "image", "jpeg");
        HTTPLocalServerSWF.addMIMEType("jpg", "image", "jpeg");
        HTTPLocalServerSWF.addMIMEType("png", "image", "png");
    }

    public static class MIMEType {
        public final String suffix;
        public final String type;
        public final String subtype;

        MIMEType(String string, String string2, String string3) {
            this.suffix = string;
            this.type = string2;
            this.subtype = string3;
        }
    }
}

