/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision.ui.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.actf.mediator.IACTFReport;
import org.eclipse.actf.mediator.IACTFReportGenerator;
import org.eclipse.actf.mediator.Mediator;
import org.eclipse.actf.model.dom.dombycom.IElementEx;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.model.ui.ImagePositionInfo;
import org.eclipse.actf.model.ui.ModelServiceImageCreator;
import org.eclipse.actf.model.ui.editor.browser.ICurrentStyles;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.editor.browser.WaitForBrowserReadyHandler;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.ui.util.timer.WaitExecSyncEventHandler;
import org.eclipse.actf.ui.util.timer.WaitExecSyncEventListener;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.IVisualizationConst;
import org.eclipse.actf.visualization.engines.lowvision.PageEvaluation;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.PageImageFactory;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.lowvision.LowVisionVizPlugin;
import org.eclipse.actf.visualization.lowvision.eval.CheckResultLowVision;
import org.eclipse.actf.visualization.lowvision.eval.SaveReportLowVision;
import org.eclipse.actf.visualization.lowvision.eval.SummaryEvaluationLV;
import org.eclipse.actf.visualization.lowvision.ui.internal.LowVisionSimulationView;
import org.eclipse.actf.visualization.lowvision.ui.internal.Messages;
import org.eclipse.actf.visualization.lowvision.ui.views.LowVisionView;
import org.eclipse.actf.visualization.lowvision.util.LowVisionUtil;
import org.eclipse.actf.visualization.lowvision.util.ParamLowVision;
import org.eclipse.actf.visualization.lowvision.util.SimulateLowVision;
import org.eclipse.actf.visualization.ui.IPositionSize;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartControlLowVision
implements ISelectionListener,
IVisualizationConst {
    private static final CheckResultLowVision dummyResult = new CheckResultLowVision();
    private String[] frameUrl;
    private IPageImage[] framePageImage;
    private ImagePositionInfo[][] imageInfoInHtmlArray;
    private ArrayList<Map<String, ICurrentStyles>> styleInfoArray;
    private Vector<ExtractCheckThread> checkThreads;
    private LowVisionSimulationView lowVisionView;
    private ParamLowVision paramLowVision;
    private Shell _shell;
    private String targetUrlS;
    private boolean[] isFinished;
    private SaveReportLowVision _saveReportLowVision;
    private boolean _isInSimulate;
    private boolean is1stSimulateDone = false;
    private int dump_image_size = 7000000;
    private CheckResultLowVision checkResult = new CheckResultLowVision();
    private File reportFile;
    private File reportImageFile;
    private File visResultFile;
    private File dumpImgFile;
    private File sourceHtmlFile;
    private String dumpImageFile;
    private LowVisionView checker;
    private Mediator mediator = Mediator.getInstance();
    private IWebBrowserACTF webBrowser = null;
    private IModelService targetModelService;
    private HashMap<String, WaitExecSyncEventListener> eventhandlerHolder = new HashMap();
    private static final String LISTENER_KEY = "browser";
    private ArrayList<IElementEx> highlightElements = new ArrayList();

    public PartControlLowVision(LowVisionView lowVisionView, Composite composite) {
        this.checker = lowVisionView;
        this._shell = composite.getShell();
        this.paramLowVision = ParamLowVision.getDefaultInstance();
        this._saveReportLowVision = new SaveReportLowVision(this._shell);
        this.lowVisionView = new LowVisionSimulationView(composite);
        this._isInSimulate = false;
        try {
            this.removeTempFile(this.dumpImgFile);
            this.dumpImgFile = LowVisionVizPlugin.createTempFile("screenshot", ".bmp");
            this.dumpImageFile = this.dumpImgFile.getAbsolutePath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveReport() {
        IModelService iModelService = ModelServiceUtils.getActiveModelService();
        if (this.is1stSimulateDone && !this.isBInSimulate() && iModelService != null) {
            this._saveReportLowVision.doSave(iModelService.getURL(), this.checkResult.getProblemList(), this.visResultFile, this.reportImageFile);
        }
    }

    public void saveReport(int n, int[] nArray, String string, String string2, String string3, Document document, String string4, int n2) {
        this._saveReportLowVision.doSave(n, nArray, string, string2, document, string4, this.checkResult.getProblemList(), this.visResultFile, this.reportImageFile);
    }

    private void allocate(int n) {
        this.framePageImage = new IPageImage[n];
        this.imageInfoInHtmlArray = new ImagePositionInfo[n][];
        this.styleInfoArray = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            this.styleInfoArray.add(new HashMap());
            ++n2;
        }
        this.isFinished = new boolean[n];
        n2 = 0;
        while (n2 < n) {
            this.isFinished[n2] = false;
            ++n2;
        }
    }

    public void doSimulate() {
        this.clearHighlight();
        Display.getCurrent().timerExec(50, new Runnable(){

            public void run() {
                PartControlLowVision.this.doSimulateInternal();
            }
        });
    }

    private void doSimulateInternal() {
        this.is1stSimulateDone = true;
        if (this.isBInSimulate()) {
            return;
        }
        this._isInSimulate = true;
        this._shell.setCursor(new Cursor((Device)this._shell.getDisplay(), 1));
        IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
        IViewReference iViewReference = iWorkbenchPage.findViewReference("org.eclipse.actf.visualization.lowvision.ui.views.LowVisionView");
        if (iViewReference.isFastView() && iWorkbenchPage.getPartState((IWorkbenchPartReference)iViewReference) == 2) {
            iWorkbenchPage.setPartState((IWorkbenchPartReference)iViewReference, 0);
        }
        Mediator.getInstance().setReport((IACTFReportGenerator)this.checker, (IACTFReport)dummyResult);
        this.checkResult = new CheckResultLowVision();
        this.lowVisionView.clearImage();
        this._shell.getDisplay().update();
        this.checkThreads = new Vector();
        this.targetModelService = ModelServiceUtils.getActiveModelService();
        if (this.targetModelService == null) {
            IEditorPart iEditorPart = ModelServiceUtils.reopenInACTFBrowser();
            if (iEditorPart instanceof IModelServiceHolder) {
                this.targetModelService = ((IModelServiceHolder)iEditorPart).getModelService();
                WaitForBrowserReadyHandler waitForBrowserReadyHandler = new WaitForBrowserReadyHandler((IWebBrowserACTF)this.targetModelService, 30.0, false, new Runnable(){

                    public void run() {
                        PartControlLowVision.this.eventhandlerHolder.remove(PartControlLowVision.LISTENER_KEY);
                        PartControlLowVision.this.doSimulate();
                    }
                });
                this.eventhandlerHolder.put(LISTENER_KEY, new WaitExecSyncEventListener((WaitExecSyncEventHandler)waitForBrowserReadyHandler));
            }
            this._shell.setCursor(new Cursor((Device)this._shell.getDisplay(), 0));
            this._isInSimulate = false;
            return;
        }
        this.webBrowser = null;
        if (this.targetModelService instanceof IWebBrowserACTF) {
            this.webBrowser = (IWebBrowserACTF)this.targetModelService;
        }
        this.frameUrl = new String[0];
        int n = 0;
        if (this.webBrowser != null) {
            n = this.frameUrl.length;
            if (n == 0) {
                this.allocate(1);
            } else {
                this.allocate(n);
                int n2 = this.dump_image_size / n - this.dump_image_size / 10 * (n - 1);
                if (n2 < this.dump_image_size / 10) {
                    n2 = this.dump_image_size / 10;
                }
            }
        } else {
            this.allocate(1);
        }
        this.targetUrlS = this.targetModelService.getURL();
        if (this.webBrowser != null) {
            try {
                this.removeTempFile(this.sourceHtmlFile);
                this.sourceHtmlFile = LowVisionVizPlugin.createTempFile("source", ".html");
                this.webBrowser.saveOriginalDocument(this.sourceHtmlFile.getAbsolutePath());
                this.checkResult.setSourceFile(this.sourceHtmlFile);
            }
            catch (Exception exception) {}
        }
        if (n == 0) {
            this.frameUrl = new String[1];
            this.frameUrl[0] = this.targetUrlS;
            this.prepareInt2Ds(this.targetModelService, 0, 0);
        }
    }

    private void prepareInt2Ds(IModelService iModelService, int n, int n2) {
        try {
            this.checker.setStatusMessage(Messages.LowVisionView_dump_the_image_in_the_web_browser__26);
            ModelServiceImageCreator modelServiceImageCreator = new ModelServiceImageCreator(iModelService);
            modelServiceImageCreator.getScreenImageAsBMP(this.dumpImageFile, this.checker.isWholepage() && this.targetModelService.getScrollManager().getScrollType() != -1);
            this.framePageImage[n] = PageImageFactory.createPageImage((String)this.dumpImageFile);
            IWebBrowserACTF iWebBrowserACTF = null;
            if (iModelService instanceof IWebBrowserACTF) {
                iWebBrowserACTF = (IWebBrowserACTF)iModelService;
            }
            if (this.framePageImage[n] != null) {
                this.checker.setStatusMessage(Messages.LowVisionView_get_information_of_all_images__25);
                if (iWebBrowserACTF != null) {
                    this.imageInfoInHtmlArray[n] = iWebBrowserACTF.getAllImagePosition();
                    this.styleInfoArray.set(n, iWebBrowserACTF.getStyleInfo().getCurrentStyles());
                } else {
                    this.styleInfoArray.set(n, new HashMap());
                }
                if (n2 > 1) {
                    this.imageInfoInHtmlArray[n] = LowVisionUtil.trimInfoImageInHtml(this.imageInfoInHtmlArray[n], this.framePageImage[n].getHeight());
                    this.styleInfoArray.set(n, LowVisionUtil.trimStyleInfoArray(this.styleInfoArray.get(n), this.framePageImage[n].getHeight()));
                }
                this.checker.setStatusMessage(Messages.LowVisionView_begin_to_make_PageImage__2);
                ExtractCheckThread extractCheckThread = new ExtractCheckThread(n, this.frameUrl[n]);
                extractCheckThread.start();
                this.checkThreads.add(extractCheckThread);
                this.isFinished[n] = true;
                if (iWebBrowserACTF != null) {
                    if (n == n2) {
                        if (n2 > 0) {
                            iWebBrowserACTF.navigate(this.targetUrlS);
                        }
                        this.doSimulateAfterHalf();
                    } else {
                        ++n;
                    }
                } else {
                    this.doSimulateAfterHalf();
                }
            } else {
                this._shell.setCursor(null);
                this._isInSimulate = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doSimulateAfterHalf() {
        IPageImage iPageImage = this.framePageImage.length > 1 ? PageImageFactory.joinPageImages((IPageImage[])this.framePageImage) : this.framePageImage[0];
        this.checker.setStatusMessage(Messages.LowVisionView_prepare_Simulation_Image__29);
        try {
            this.removeTempFile(this.visResultFile);
            this.visResultFile = LowVisionVizPlugin.createTempFile("visualization", ".bmp");
            ImageData[] imageDataArray = SimulateLowVision.doSimulate(iPageImage, this.paramLowVision, this.visResultFile.getAbsolutePath());
            if (imageDataArray.length > 0) {
                this.lowVisionView.displayImage(imageDataArray[0], this.targetModelService, this.checker.isWholepage());
                imageDataArray = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.checkResult.setFrameOffsetToProblems(this.framePageImage);
        new WaitExtractThread(null).start();
    }

    public void setHighlightPositions(List<IPositionSize> list) {
        this.lowVisionView.highlight(list);
    }

    public void setParamLowVision(ParamLowVision paramLowVision) {
        this.paramLowVision = paramLowVision;
    }

    public boolean isChildThread() {
        return false;
    }

    public void setLVParamStatus() {
        if (!this.isBInSimulate()) {
            this.checker.setInfoMessage(this.paramLowVision.toString());
        }
    }

    public void simulateForMoreParameter() {
        this._isInSimulate = true;
        this.checkResult = new CheckResultLowVision();
        this.lowVisionView.clearImage();
        this.checkThreads = new Vector();
        IModelService iModelService = ModelServiceUtils.getActiveModelService();
        if (this.frameUrl.length == 0) {
            this.checker.setStatusMessage(Messages.LowVisionView_begin_to_make_PageImage__2);
            ExtractCheckThread extractCheckThread = new ExtractCheckThread(0, iModelService.getURL());
            extractCheckThread.start();
            this.checkThreads.add(extractCheckThread);
        } else {
            int n = 0;
            while (n < this.frameUrl.length) {
                ExtractCheckThread extractCheckThread = new ExtractCheckThread(n, this.frameUrl[n]);
                extractCheckThread.start();
                this.checkThreads.add(extractCheckThread);
                ++n;
            }
        }
        this.doSimulateAfterHalf();
    }

    public boolean isBInSimulate() {
        return this._isInSimulate;
    }

    public boolean isInSaveReport() {
        return this._saveReportLowVision.isInSaveReport();
    }

    public int getReportColorNum() {
        return this._saveReportLowVision.getNumColorProblem();
    }

    public int getReportFontNum() {
        return this._saveReportLowVision.getNumFontProblem();
    }

    public void setDump_image_size(int n) {
        this.dump_image_size = n;
    }

    private void clearHighlight() {
        for (IElementEx iElementEx : this.highlightElements) {
            if (iElementEx == null) continue;
            iElementEx.unhighlight();
        }
        this.highlightElements.clear();
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        this.clearHighlight();
        if (iSelection == null || !(iSelection instanceof IStructuredSelection)) {
            DebugPrintUtil.devOrDebugPrintln((Object)(String.valueOf(this.getClass().getName()) + ": Iselection"));
            return;
        }
        ArrayList<IPositionSize> arrayList = new ArrayList<IPositionSize>();
        for (IProblemItem iProblemItem : (IStructuredSelection)iSelection) {
            IPositionSize iPositionSize;
            if (this.checkResult.getProblemList().contains(iProblemItem)) {
                iPositionSize = (IPositionSize)iProblemItem;
                arrayList.add(iPositionSize);
            }
            if (!(iProblemItem.getTargetNode() instanceof IElementEx)) continue;
            iPositionSize = (IElementEx)iProblemItem.getTargetNode();
            iPositionSize.highlight();
            this.highlightElements.add((IElementEx)iPositionSize);
        }
        this.setHighlightPositions(arrayList);
    }

    public void setCurrentModelService(IModelService iModelService) {
        this.lowVisionView.setCurrentModelService(iModelService);
    }

    private void removeTempFile(File file) {
        if (file != null) {
            file.delete();
        }
    }

    private class ExtractCheckThread
    extends Thread {
        int frameId;
        String address;
        PageEvaluation targetPage;
        private List<IProblemItem> lowvisionProblemList;

        ExtractCheckThread(int n, String string) {
            this.frameId = n;
            this.address = string;
        }

        public void run() {
            try {
                this.targetPage = new PageEvaluation(PartControlLowVision.this.framePageImage[this.frameId]);
                this.targetPage.setInteriorImagePosition(PartControlLowVision.this.imageInfoInHtmlArray[this.frameId]);
                this.targetPage.setCurrentStyles((Map)PartControlLowVision.this.styleInfoArray.get(this.frameId));
                PartControlLowVision.this._shell.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        PartControlLowVision.this.checker.setStatusMessage(Messages.LowVisionView_begin_to_check_problems__4);
                    }
                });
                this.lowvisionProblemList = this.targetPage.check(PartControlLowVision.this.paramLowVision.getLowVisionType(), this.address, this.frameId);
                try {
                    PartControlLowVision.this.removeTempFile(PartControlLowVision.this.reportFile);
                    PartControlLowVision.this.reportFile = LowVisionVizPlugin.createTempFile("report", ".html");
                    if (PartControlLowVision.this.webBrowser != null) {
                        PartControlLowVision.this.removeTempFile(PartControlLowVision.this.reportImageFile);
                        PartControlLowVision.this.reportImageFile = LowVisionVizPlugin.createTempFile("report", ".bmp");
                        this.targetPage.generateReport(PartControlLowVision.this.reportFile.getParent(), PartControlLowVision.this.reportFile.getName(), PartControlLowVision.this.reportImageFile.getName(), this.lowvisionProblemList);
                    } else {
                        PartControlLowVision.this.reportImageFile = null;
                        this.targetPage.unsupportedModeReport(PartControlLowVision.this.reportFile);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.targetPage = null;
                PartControlLowVision.this.checkResult.addProblemItems(this.lowvisionProblemList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class WaitExtractThread
    extends Thread {
        Thread simulateThread;

        WaitExtractThread(Thread thread) {
            this.simulateThread = thread;
        }

        public void run() {
            if (this.simulateThread == null && PartControlLowVision.this.checkThreads == null) {
                return;
            }
            boolean bl = true;
            int n = 0;
            while (bl) {
                if (this.simulateThread == null || !this.simulateThread.isAlive()) {
                    bl = false;
                    this.simulateThread = null;
                    int n2 = 0;
                    while (n2 < PartControlLowVision.this.checkThreads.size()) {
                        bl = bl || ((ExtractCheckThread)PartControlLowVision.this.checkThreads.get(n2)).isAlive();
                        ++n2;
                    }
                }
                if (n >= 200) break;
                ++n;
                try {
                    WaitExtractThread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            PartControlLowVision.this._shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (PartControlLowVision.this.webBrowser != null) {
                        PartControlLowVision.this.checkResult.setSummaryReportText(new SummaryEvaluationLV(PartControlLowVision.this.checkResult.getProblemList()).getOverview());
                    } else {
                        PartControlLowVision.this.checkResult.setSummaryReportText(SummaryEvaluationLV.notSupported());
                    }
                    PartControlLowVision.this.checkResult.setLineStyleListener((LineStyleListener)SummaryEvaluationLV.getHighLightStringListener());
                    PartControlLowVision.this.checkResult.setSummaryReportUrl(PartControlLowVision.this.reportFile.getAbsolutePath());
                    PartControlLowVision.this.mediator.setReport((IACTFReportGenerator)PartControlLowVision.this.checker, (IACTFReport)PartControlLowVision.this.checkResult);
                    PartControlLowVision.this.checker.setStatusMessage(Messages.LowVisionView_simulation_of_current_page_is_over__8);
                    PartControlLowVision.this._shell.setCursor(null);
                    PartControlLowVision.this._isInSimulate = false;
                    PlatformUIUtil.showView((String)"org.eclipse.actf.visualization.lowvision.ui.views.LowVisionView");
                    PartControlLowVision.this.checkThreads = new Vector();
                }
            });
        }
    }
}

