/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.ui.editor.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.actf.model.internal.ui.FavoritesChangeEvent;
import org.eclipse.actf.model.internal.ui.FavoritesChangeListener;
import org.eclipse.actf.model.internal.ui.FavoritesUtil;
import org.eclipse.actf.model.internal.ui.editor.actions.AddFavoritesAction;
import org.eclipse.actf.model.internal.ui.editor.actions.ArrangeFavoritesAction;
import org.eclipse.actf.model.internal.ui.editor.actions.FavoritesItemAction;
import org.eclipse.actf.model.ui.util.ModelServiceMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoritesMenu
extends MenuManager
implements FavoritesChangeListener {
    private IWorkbenchWindow _window;
    private List<String> _favoritesItemIdList = new ArrayList<String>();
    private boolean useExistingEditor;

    public FavoritesMenu(IWorkbenchWindow iWorkbenchWindow) {
        this(iWorkbenchWindow, false);
    }

    public FavoritesMenu(IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        super(ModelServiceMessages.MenuConst_F_avorites_8);
        this._window = iWorkbenchWindow;
        this.useExistingEditor = bl;
        Map<String, String> map = FavoritesUtil.getFavoritesMap();
        AddFavoritesAction addFavoritesAction = new AddFavoritesAction(iWorkbenchWindow, map);
        this.add((IAction)addFavoritesAction);
        addFavoritesAction.addFavoritesChangeListener(this);
        ArrangeFavoritesAction arrangeFavoritesAction = new ArrangeFavoritesAction(this._window, map);
        this.add((IAction)arrangeFavoritesAction);
        arrangeFavoritesAction.addFavoritesChangeListener(this);
        this.add((IContributionItem)new Separator());
        this.updateAllFavoritesItems(map);
    }

    @Override
    public void favoritesChanged(FavoritesChangeEvent favoritesChangeEvent) {
        this.updateAllFavoritesItems(favoritesChangeEvent.getFavoritesMap());
    }

    private void updateAllFavoritesItems(Map<String, String> map) {
        Iterator<String> iterator = map.keySet().iterator();
        this.removeAllFavoritesItemAction();
        while (iterator.hasNext()) {
            String string = iterator.next();
            String string2 = map.get(string);
            this.addFavoritesItemAction(string, string2);
        }
        FavoritesUtil.saveFavoritesMap(map);
    }

    private void removeAllFavoritesItemAction() {
        int n = 0;
        while (n < this._favoritesItemIdList.size()) {
            this.remove(this._favoritesItemIdList.get(n));
            ++n;
        }
        this._favoritesItemIdList.clear();
    }

    private void addFavoritesItemAction(String string, String string2) {
        FavoritesItemAction favoritesItemAction = new FavoritesItemAction(this._window, string, string2, this.useExistingEditor);
        this.add((IAction)favoritesItemAction);
        this._favoritesItemIdList.add(String.valueOf(FavoritesItemAction.ID) + "_" + string);
    }
}

