/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.proxy;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import org.eclipse.actf.util.httpproxy.ExternalProxyConfig;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.proxy.IClientStateManager;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPLocalServer;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPLocalServerFactory;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyTranscoder;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPSessionOverrider;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPSessionOverriderFactory;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.httpproxy.util.ParseURI;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseInMemoryMessage;
import org.eclipse.actf.util.internal.httpproxy.core.RequestDispatcher;
import org.eclipse.actf.util.internal.httpproxy.core.Session;
import org.eclipse.actf.util.internal.httpproxy.proxy.HTTPProxyConnection;
import org.eclipse.actf.util.internal.httpproxy.proxy.HTTPServerConnection;

public class HTTPRequestDispatcher
extends RequestDispatcher {
    private static final Logger LOGGER = Logger.getLogger(HTTPRequestDispatcher.class);
    private final IClientStateManager clientStateManager;
    private final HTTPProxyConnection fClient;
    private final ExternalProxyConfig fExProxyConf;
    private final int timeout;
    private static final int HTTP_WELL_KNOWN_PORT = 80;
    private static final int HTTPS_WELL_KNOWN_PORT = 443;
    private static CacheConfig[] cacheConfigs = new CacheConfig[]{new CacheConfig("http://.*\\abcnews\\.go\\.com/Video/.*", "no-cache")};
    private IHTTPSessionOverrider overrider = null;
    private IHTTPLocalServer localServer = null;
    private ArrayList<HTTPServerConnection> serverConnectionCache = new ArrayList();
    private IHTTPProxyTranscoder transcoder = null;

    private IHTTPResponseMessage addCacheControl(String string, IHTTPResponseMessage iHTTPResponseMessage) {
        int n = 0;
        while (n < cacheConfigs.length) {
            if (string.matches(HTTPRequestDispatcher.cacheConfigs[n].urlPattern)) {
                System.err.println("match-to:" + HTTPRequestDispatcher.cacheConfigs[n].urlPattern);
                iHTTPResponseMessage.setHeader(IHTTPHeader.CACHE_CONTROL_A, HTTPRequestDispatcher.cacheConfigs[n].control);
                return iHTTPResponseMessage;
            }
            ++n;
        }
        return iHTTPResponseMessage;
    }

    public HTTPRequestDispatcher(HTTPProxyConnection hTTPProxyConnection, IClientStateManager iClientStateManager, Socket socket, int n, int n2) {
        super("HTTPRequestDispatcher-" + socket.getLocalPort(), new Session(), hTTPProxyConnection, socket, n);
        this.fClient = hTTPProxyConnection;
        this.fExProxyConf = hTTPProxyConnection.getExternalProxyConfig();
        this.clientStateManager = iClientStateManager;
        this.timeout = n2;
        IHTTPLocalServerFactory iHTTPLocalServerFactory = hTTPProxyConnection.getProxy().getLocalServerFactory();
        IHTTPSessionOverriderFactory iHTTPSessionOverriderFactory = hTTPProxyConnection.getProxy().getSessionOverriderFactory();
        if (iHTTPLocalServerFactory != null) {
            this.localServer = iHTTPLocalServerFactory.newInstance();
        }
        if (iHTTPSessionOverriderFactory != null) {
            this.overrider = iHTTPSessionOverriderFactory.newInstance(this.getDispatcherId());
        }
    }

    private boolean processLocalServerRequest(IHTTPRequestMessage iHTTPRequestMessage) throws InterruptedException, IOException {
        if (this.localServer == null) {
            return false;
        }
        return this.localServer.processRequest(this.getDispatcherId(), this.fClient, iHTTPRequestMessage, this.transcoder);
    }

    private HTTPServerConnection getConnection(String string, int n) {
        HTTPServerConnection hTTPServerConnection;
        int n2 = this.serverConnectionCache.size();
        int n3 = 0;
        while (n3 < n2) {
            hTTPServerConnection = this.serverConnectionCache.get(n3);
            if (string.equals(hTTPServerConnection.getHost()) && n == hTTPServerConnection.getPort()) {
                if (hTTPServerConnection.getStat() < 0) {
                    hTTPServerConnection.deactivate();
                    hTTPServerConnection = HTTPServerConnection.newConnection(this, string, n, this.timeout);
                    this.serverConnectionCache.set(n3, hTTPServerConnection);
                }
                return hTTPServerConnection;
            }
            if (hTTPServerConnection.getStat() < 0) {
                hTTPServerConnection.deactivate();
                this.serverConnectionCache.remove(n3);
                --n2;
                continue;
            }
            ++n3;
        }
        hTTPServerConnection = HTTPServerConnection.newConnection(this, string, n, this.timeout);
        this.serverConnectionCache.add(hTTPServerConnection);
        return hTTPServerConnection;
    }

    private HTTPServerConnection newConnectionForServer(IHTTPRequestMessage iHTTPRequestMessage, boolean bl) {
        IHTTPHeader iHTTPHeader;
        Object object;
        int n;
        String string;
        String string2 = iHTTPRequestMessage.getRequestURIString();
        String string3 = ParseURI.getAuthority(string2);
        IHTTPHeader iHTTPHeader2 = iHTTPRequestMessage.getHeader(IHTTPHeader.HOST_A);
        if (bl) {
            string = ParseURI.parseHost(string2);
            n = ParseURI.parsePort(string2, 443);
        } else if (iHTTPHeader2 != null) {
            object = new String(iHTTPHeader2.getValue());
            string = ParseURI.parseHost((String)object);
            n = ParseURI.parsePort((String)object, 80);
        } else if (string3 != null) {
            string = ParseURI.parseHost(string3);
            n = ParseURI.parsePort(string3, 80);
            iHTTPRequestMessage.setHeader(IHTTPHeader.HOST_A, string.getBytes());
        } else {
            return null;
        }
        if (string3 != null) {
            object = ParseURI.getAbsolutePath(string2);
            iHTTPRequestMessage.setRequestURIString((String)object);
        }
        if ((object = iHTTPRequestMessage.getHeader(IHTTPHeader.PROXY_CONNECTION_A)) != null) {
            object.setRemoved(true);
            iHTTPRequestMessage.setHeader(IHTTPHeader.CONNECTION_A, object.getValue());
        }
        if ((iHTTPHeader = iHTTPRequestMessage.getHeader(IHTTPHeader.PRAGMA_A)) != null) {
            iHTTPHeader.setRemoved(true);
        }
        return this.getConnection(string, n);
    }

    private HTTPServerConnection newConnectionForProxy() {
        return this.getConnection(this.fExProxyConf.getExternalProxyHost(), this.fExProxyConf.getExternalProxyPort());
    }

    public void setTranscoder(IHTTPProxyTranscoder iHTTPProxyTranscoder) {
        this.transcoder = iHTTPProxyTranscoder;
    }

    private IHTTPResponseMessage transcode(IHTTPRequestMessage iHTTPRequestMessage, IHTTPResponseMessage iHTTPResponseMessage) {
        if (this.transcoder != null) {
            return this.transcoder.transcode(this.getDispatcherId(), iHTTPRequestMessage, iHTTPResponseMessage);
        }
        return iHTTPResponseMessage;
    }

    private void sendGatewayTimeout(IHTTPRequestMessage iHTTPRequestMessage) throws InterruptedException, IOException {
        this.fClient.sendResponse(new HTTPResponseInMemoryMessage(iHTTPRequestMessage.getSerial(), IHTTPHeader.HTTP_VERSION_1_0_A, "504".getBytes(), "Gateway Timeout".getBytes(), IHTTPResponseMessage.EMPTY_BODY));
    }

    private void sendBadGateway(IHTTPRequestMessage iHTTPRequestMessage) throws InterruptedException, IOException {
        this.fClient.sendResponse(new HTTPResponseInMemoryMessage(iHTTPRequestMessage.getSerial(), IHTTPHeader.HTTP_VERSION_1_0_A, "502".getBytes(), "Bad Gateway".getBytes(), IHTTPResponseMessage.EMPTY_BODY));
    }

    private void sendNotFound(IHTTPRequestMessage iHTTPRequestMessage) throws InterruptedException, IOException {
        this.fClient.sendResponse(new HTTPResponseInMemoryMessage(iHTTPRequestMessage.getSerial(), IHTTPHeader.HTTP_VERSION_1_0_A, "404".getBytes(), "Not Found".getBytes(), IHTTPResponseMessage.EMPTY_BODY));
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[DOLOOP]], but top level block is 18[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void close() {
        super.close();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[id:").append(this.getDispatcherId()).append("] HTTPRequestDispatcher");
        return stringBuffer.toString();
    }

    protected final void DEBUG(String string) {
        if (LOGGER.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.toString()).append(": ").append(string);
            LOGGER.debug(stringBuffer.toString());
        }
    }

    protected final void WARNING(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString()).append(": ").append(string);
        LOGGER.warning(stringBuffer.toString());
    }

    protected final void INFO(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString()).append(": ").append(string);
        LOGGER.info(stringBuffer.toString());
    }

    private static class CacheConfig {
        public final String urlPattern;
        public final byte[] control;

        public CacheConfig(String string, String string2) {
            this.urlPattern = string;
            this.control = string2.getBytes();
        }
    }
}

