/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLConstants;
import org.eclipse.actf.model.internal.dom.sgml.impl.AttributeDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParser;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class InsTokenizer
implements ISGMLConstants,
Locator {
    private boolean extractChar = true;
    private boolean extractNum = true;
    private int state;
    private boolean pushBacked;
    public String sval;
    public int ttype;
    private Reader reader;
    private SGMLParser parser;
    private int etagStartIndex;
    private int[] entityBuf = new int[64];
    private int entityBufIndex;
    private char[] endTagBuffer = new char[64];
    private int endTagBufferIndex = 0;
    private char[] attrValBuffer = new char[8192];
    private boolean prsvWS = false;
    private int index = 0;
    private char[] charBuffer = new char[8192];
    public static final int INITIAL_BUF_SIZ = 8192;
    public static final int READ_UNIT = 1024;
    private int bufLimit = 0;
    private char[] miscBuffer = new char[8192];
    private int miscIndex = 0;
    private boolean skipLF;
    private int lastLFindex = -1;
    private int lineNumber = 0;

    void extractCharEntity(boolean bl) {
        this.extractChar = bl;
    }

    void extractNumEntity(boolean bl) {
        this.extractNum = bl;
    }

    public InsTokenizer(Reader reader, SGMLParser sGMLParser) {
        this(reader, 0, sGMLParser);
    }

    InsTokenizer(Reader reader, int n, SGMLParser sGMLParser) {
        this.reader = reader;
        this.state = n;
        this.parser = sGMLParser;
        this.pushBacked = false;
    }

    private boolean forward(String string, boolean bl) throws IOException {
        int n;
        int[] nArray = new int[string.length()];
        boolean bl2 = true;
        if (!bl) {
            n = 0;
            while (n < nArray.length) {
                nArray[n] = this.read();
                if (nArray[n] != string.charAt(n)) {
                    bl2 = false;
                    ++n;
                    break;
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < nArray.length) {
                nArray[n] = this.read();
                if (Character.toUpperCase((char)nArray[n]) != Character.toUpperCase(string.charAt(n)) && Character.toLowerCase((char)nArray[n]) != Character.toLowerCase(string.charAt(n))) {
                    bl2 = false;
                    ++n;
                    break;
                }
                ++n;
            }
        }
        while (n > 0) {
            this.unread(nArray[--n]);
        }
        return bl2;
    }

    private int eatComment() throws IOException, ParseException {
        this.miscIndex = 0;
        int n = this.read();
        if (n == 45) {
            n = this.read();
            if (n == 45) {
                while (true) {
                    int n2;
                    if ((n = this.read()) != 45 && n != -1) {
                        this.setCharToMiscBuffer(this.miscIndex, (char)n);
                        ++this.miscIndex;
                        continue;
                    }
                    n = this.read();
                    if (n == 45) {
                        n = this.read();
                        if (n == 45) {
                            if (this.miscBuffer.length <= this.miscIndex + 2) {
                                this.expandMiscBuffer();
                            }
                            this.miscBuffer[this.miscIndex + 2] = 45;
                            this.miscBuffer[this.miscIndex + 1] = 45;
                            this.miscBuffer[this.miscIndex] = 45;
                            this.miscIndex += 3;
                            this.storeUntil('>');
                            if (Character.isWhitespace(this.miscBuffer[this.miscIndex - 1]) || this.miscBuffer[this.miscIndex - 1] == '-' || this.miscBuffer[this.miscIndex - 1] == '!') {
                                if (this.miscBuffer[this.miscIndex - 2] == '-' && this.miscBuffer[this.miscIndex - 1] == '-') {
                                    this.miscIndex -= 2;
                                }
                                this.state = 0;
                                this.sval = new String(this.miscBuffer, 0, this.miscIndex);
                                this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
                                this.ttype = 13;
                                return 13;
                            }
                            this.setCharToMiscBuffer(this.miscIndex, '>');
                            ++this.miscIndex;
                            continue;
                        }
                        if (n == 33) {
                            n = this.read();
                            if (n == 62) {
                                this.state = 0;
                                this.sval = new String(this.miscBuffer, 0, this.miscIndex);
                                this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
                                this.ttype = 13;
                                return 13;
                            }
                            if (this.miscBuffer.length <= this.miscIndex + 2) {
                                this.expandMiscBuffer();
                            }
                            this.miscBuffer[this.miscIndex + 1] = 45;
                            this.miscBuffer[this.miscIndex] = 45;
                            this.miscBuffer[this.miscIndex + 2] = 33;
                            this.miscIndex += 3;
                            this.unread(n);
                            continue;
                        }
                        n2 = 0;
                        char[] cArray = null;
                        if (Character.isWhitespace((char)n)) {
                            cArray = new char[256];
                            cArray[0] = (char)n;
                            cArray[1] = '\u0001';
                            while (Character.isWhitespace((char)n)) {
                                if (n == cArray[n2]) {
                                    int n3 = n2 + 1;
                                    cArray[n3] = (char)(cArray[n3] + '\u0001');
                                } else {
                                    cArray[n2 += 2] = (char)n;
                                    cArray[n2 + 1] = '\u0001';
                                }
                                n = this.read();
                            }
                        }
                        if (n == 62) {
                            this.state = 0;
                            this.sval = new String(this.miscBuffer, 0, this.miscIndex);
                            this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
                            this.ttype = 13;
                            return 13;
                        }
                        if (this.miscBuffer.length <= this.miscIndex + 2) {
                            this.expandMiscBuffer();
                        }
                        this.miscBuffer[this.miscIndex + 1] = 45;
                        this.miscBuffer[this.miscIndex] = 45;
                        this.miscIndex += 2;
                        int n4 = 0;
                        while (n4 < n2) {
                            int n5 = 0;
                            while (n5 < cArray[n4 + 1]) {
                                this.setCharToMiscBuffer(this.miscIndex, cArray[n4]);
                                ++n5;
                            }
                            ++this.miscIndex;
                            n4 += 2;
                        }
                        this.unread(n);
                        continue;
                    }
                    if (n == -1) {
                        this.parser.error(10, "Unexpected EOF in comment.");
                        n2 = 0;
                        while (n2 < this.miscBuffer.length) {
                            if (this.miscBuffer[n2] == '>') {
                                this.unread(this.miscBuffer, n2 + 1, this.miscIndex - n2 - 1);
                                this.state = 0;
                                this.sval = new String(this.miscBuffer, 0, n2);
                                this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
                                this.ttype = 13;
                                return 13;
                            }
                            ++n2;
                        }
                        throw new ParseException("Unexpected EOF in comment.");
                    }
                    this.setCharToMiscBuffer(this.miscIndex, '-');
                    ++this.miscIndex;
                    this.setCharToMiscBuffer(this.miscIndex, (char)n);
                    ++this.miscIndex;
                }
            }
            this.sval = "-" + (char)n + this.eatUntil('>');
            char[] cArray = this.sval.toCharArray();
            this.parser.setCharacter(cArray, 0, cArray.length);
            this.ttype = 13;
            return 13;
        }
        if ((n == 68 || n == 100) && this.forward("OCTYPE", true)) {
            this.unread(n);
            this.state = 1;
            this.ttype = 1;
            return 1;
        }
        this.sval = String.valueOf((char)n) + this.eatUntil('>');
        char[] cArray = this.sval.toCharArray();
        this.parser.setCharacter(cArray, 0, cArray.length);
        this.ttype = 13;
        return 13;
    }

    private int defaultState() throws IOException, ParseException, SAXException {
        this.miscIndex = 0;
        int n = this.read();
        while (Character.isWhitespace((char)n)) {
            this.addCharToMiscBuffer((char)n);
            n = this.read();
        }
        if (this.miscIndex > 0 && this.prsvWS) {
            this.unread(n);
            this.sval = new String(this.miscBuffer, 0, this.miscIndex);
            this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
            this.ttype = 15;
            return 15;
        }
        switch (n) {
            case 60: {
                DocumentHandler documentHandler;
                if (this.miscIndex > 0 && !this.prsvWS && (documentHandler = this.parser.getDocumentHandler()) != null) {
                    this.unread(n);
                    documentHandler.ignorableWhitespace(this.miscBuffer, 0, this.miscIndex);
                    this.read();
                }
                this.miscIndex = 0;
                n = this.read();
                if (n == 47) {
                    n = this.read();
                    if (Character.isLowerCase((char)n) || Character.isUpperCase((char)n)) {
                        this.unread(n);
                        this.state = 2;
                        this.etagStartIndex = this.miscIndex;
                        this.addCharToMiscBuffer('<');
                        this.addCharToMiscBuffer('/');
                        this.ttype = 8;
                        return 8;
                    }
                    this.addCharToMiscBuffer('<');
                    this.addCharToMiscBuffer('/');
                    return this.readPCDATA(n);
                }
                if (n == 63) {
                    this.miscIndex = 0;
                    while ((n = this.read()) != 62 && n != -1) {
                        this.addCharToMiscBuffer((char)n);
                    }
                    this.sval = new String(this.miscBuffer, 0, this.miscIndex);
                    this.ttype = 17;
                    return 17;
                }
                if (n == 33) {
                    return this.eatComment();
                }
                if (Character.isLowerCase((char)n) || Character.isUpperCase((char)n)) {
                    this.unread(n);
                    this.state = 1;
                    this.ttype = 60;
                    return 60;
                }
                this.addCharToMiscBuffer('<');
                return this.readPCDATA(n);
            }
            case -1: {
                this.ttype = -1;
                return -1;
            }
        }
        return this.readPCDATA(n);
    }

    private int rslvCharEnt() throws IOException, ParseException, SAXException {
        int n;
        this.entityBufIndex = 0;
        this.entityBuf[this.entityBufIndex++] = this.read();
        int n2 = this.entityBuf[this.entityBufIndex++];
        if (n2 == 35) {
            int n3;
            int n4 = this.read();
            this.entityBuf[this.entityBufIndex++] = n4;
            n2 = n4;
            int n5 = 10;
            if (n2 == 120 || n2 == 88) {
                n5 = 16;
                int n6 = this.read();
                this.entityBuf[this.entityBufIndex++] = n6;
                n2 = n6;
            }
            if ((n3 = Character.digit((char)n2, n5)) >= 0) {
                n = n3;
                int n7 = this.read();
                this.entityBuf[this.entityBufIndex++] = n7;
                n2 = n7;
                while ((n3 = Character.digit((char)n2, n5)) >= 0) {
                    n = n * n5 + n3;
                    int n8 = this.read();
                    this.entityBuf[this.entityBufIndex++] = n8;
                    n2 = n8;
                }
                if (n2 == 59) {
                    char[] cArray = new char[this.entityBufIndex - 1];
                    int n9 = 0;
                    while (n9 < this.entityBufIndex - 1) {
                        cArray[n9] = (char)this.entityBuf[n9];
                        ++n9;
                    }
                    this.parser.putCharNumEntity(new Character((char)n), new String(cArray));
                    return n;
                }
            }
        } else if (Character.isLowerCase((char)n2) || Character.isUpperCase((char)n2)) {
            while (Character.isLowerCase((char)(n2 = (this.entityBuf[this.entityBufIndex++] = this.read()))) || Character.isUpperCase((char)n2)) {
            }
            if (n2 == 59) {
                char[] cArray = new char[this.entityBufIndex - 1];
                int n10 = 0;
                while (n10 < this.entityBufIndex - 1) {
                    cArray[n10] = (char)this.entityBuf[n10];
                    ++n10;
                }
                String string = new String(cArray);
                n = this.parser.getCharEntity(string);
                if (n != -1) {
                    this.parser.putCharNumEntity(new Character((char)n), string);
                    return n;
                }
            }
        }
        int n11 = this.entityBufIndex - 1;
        while (n11 >= 0) {
            this.unread(this.entityBuf[n11]);
            --n11;
        }
        return -1;
    }

    private void setCharToMiscBuffer(int n, char c) {
        if (this.miscBuffer.length <= n) {
            this.expandMiscBuffer();
        }
        this.miscBuffer[n] = c;
    }

    private void addCharToMiscBuffer(char c) {
        if (this.miscBuffer.length <= this.miscIndex) {
            this.expandMiscBuffer();
        }
        this.miscBuffer[this.miscIndex++] = c;
    }

    private int readPCDATA(int n) throws IOException, ParseException, SAXException {
        int n2;
        int n3;
        int n4 = this.lastLFindex;
        if (!this.extractChar && !this.extractNum) {
            this.setCharToMiscBuffer(this.miscIndex, (char)n);
            ++this.miscIndex;
            while (!((n = this.read()) == 60 && (Character.isLowerCase((char)(n3 = this.sence())) || Character.isUpperCase((char)n3) || n3 == 33 || n3 == 63 || n3 == 47 && (Character.isLowerCase((char)(n3 = this.sence(1))) || Character.isUpperCase((char)n3))) || n == -1)) {
                this.setCharToMiscBuffer(this.miscIndex, (char)n);
                if (this.miscBuffer[this.miscIndex - 1] == '\n' && n != 10) {
                    n4 = this.index - 1;
                }
                ++this.miscIndex;
            }
        } else if (n != -1) {
            do {
                if (n == 38) {
                    if (!this.extractNum) {
                        n = this.read();
                        if (n == 35) {
                            this.addCharToMiscBuffer('&');
                            this.addCharToMiscBuffer('#');
                            continue;
                        }
                        this.unread(n);
                    }
                    if ((n2 = this.rslvCharEnt()) == -1) {
                        this.addCharToMiscBuffer('&');
                        continue;
                    }
                    this.addCharToMiscBuffer((char)n2);
                    continue;
                }
                this.setCharToMiscBuffer(this.miscIndex, (char)n);
                if (this.miscIndex > 0 && this.miscBuffer[this.miscIndex - 1] == '\n' && n != 10) {
                    n4 = this.index - 2;
                }
                ++this.miscIndex;
            } while (((n = this.read()) != 60 || !Character.isLowerCase((char)(n3 = this.sence())) && !Character.isUpperCase((char)n3) && n3 != 33 && n3 != 63 && (n3 != 47 || !Character.isLowerCase((char)(n3 = this.sence(1))) && !Character.isUpperCase((char)n3))) && n != -1);
        }
        if (n != -1) {
            this.unread(n);
        }
        if (!this.prsvWS) {
            n2 = 0;
            while ((n = this.miscBuffer[n2]) == 13 || n == 10) {
                ++n2;
            }
            int n5 = this.miscIndex - 1;
            try {
                while ((n = this.miscBuffer[n5]) == 13 || n == 10) {
                    --n5;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.sval = new String(this.miscBuffer, 0, this.miscIndex);
                this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
                this.ttype = 14;
                return 14;
            }
            int n6 = n5 + 1 - n2;
            this.sval = new String(this.miscBuffer, n2, n6);
            this.parser.setCharacter(this.miscBuffer, n2, n6);
            if (n5 != this.miscIndex - 1) {
                this.unread(this.miscBuffer, n5 + 1, this.miscIndex - n5 - 1);
                this.lastLFindex = n4;
            }
        } else {
            this.sval = new String(this.miscBuffer, 0, this.miscIndex);
            this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
            this.ttype = 15;
            return 15;
        }
        this.ttype = 14;
        return 14;
    }

    final String rawText(String string) throws IOException, ParseException {
        char[] cArray = string.toUpperCase().toCharArray();
        this.miscIndex = 0;
        int n = 0;
        boolean bl = false;
        block0: while (true) {
            int n2 = this.read();
            if (!bl && n2 == 60) {
                n2 = this.read();
                if (n2 == 47) {
                    if (n == 0) {
                        n = this.miscIndex;
                    }
                    this.endTagBufferIndex = 0;
                    int n3 = 0;
                    while (n3 < string.length()) {
                        this.endTagBuffer[this.endTagBufferIndex] = (char)this.read();
                        if ((this.endTagBuffer[this.endTagBufferIndex] & 0xFFDF) == cArray[this.endTagBufferIndex]) {
                            ++this.endTagBufferIndex;
                        } else {
                            ++this.endTagBufferIndex;
                            this.addCharToMiscBuffer('<');
                            this.addCharToMiscBuffer('/');
                            int n4 = 0;
                            while (true) {
                                if (n4 >= this.endTagBufferIndex) continue block0;
                                this.addCharToMiscBuffer(this.endTagBuffer[n4]);
                                ++n4;
                            }
                        }
                        ++n3;
                    }
                    while (Character.isWhitespace((char)(n2 = this.read()))) {
                        this.endTagBuffer[this.endTagBufferIndex++] = (char)n2;
                    }
                    if (n2 == 62) {
                        this.endTagBufferIndex += 3;
                        this.unread(this.endTagBuffer, 0, this.endTagBufferIndex);
                        return new String(this.miscBuffer, 0, this.miscIndex);
                    }
                    this.endTagBuffer[this.endTagBufferIndex++] = (char)n2;
                    this.addCharToMiscBuffer('<');
                    this.addCharToMiscBuffer('/');
                    n3 = 0;
                    while (true) {
                        if (n3 >= this.endTagBufferIndex) continue block0;
                        this.addCharToMiscBuffer(this.endTagBuffer[n3]);
                        ++n3;
                    }
                }
                if (n2 == 33) {
                    this.addCharToMiscBuffer('<');
                    this.addCharToMiscBuffer((char)n2);
                    n2 = this.read();
                    this.addCharToMiscBuffer((char)n2);
                    if (n2 != 45) continue;
                    n2 = this.read();
                    this.addCharToMiscBuffer((char)n2);
                    if (n2 != 45) continue;
                    bl = true;
                    continue;
                }
                this.addCharToMiscBuffer('<');
                this.addCharToMiscBuffer((char)n2);
                continue;
            }
            if (n2 == -1) {
                this.parser.error(10, "Unexpected EOF in CDATA after " + string);
                this.endTagBufferIndex = 0;
                if (n != 0) {
                    this.unread(this.miscBuffer, n, this.miscIndex - n);
                    return new String(this.miscBuffer, 0, n);
                }
                return new String(this.miscBuffer, 0, this.miscIndex);
            }
            if (bl && n2 == 45) {
                this.addCharToMiscBuffer((char)n2);
                n2 = this.read();
                this.addCharToMiscBuffer((char)n2);
                if (n2 != 45) continue;
                n2 = this.read();
                this.addCharToMiscBuffer((char)n2);
                if (n2 != 62) continue;
                bl = false;
                continue;
            }
            this.addCharToMiscBuffer((char)n2);
        }
    }

    void eatCDATAEndTag() throws IOException {
        int n = this.endTagBufferIndex;
        while (n > 0) {
            this.read();
            --n;
        }
    }

    private static boolean includeAngleBracket(char[] cArray, int n, int n2) {
        while (n < n2) {
            char c;
            if ((c = cArray[n++]) != '>' && c != '<') continue;
            return true;
        }
        return false;
    }

    private void checkAttrValBuffer(int n) {
        int n2 = this.attrValBuffer.length;
        if (n2 < n + 128) {
            char[] cArray = new char[n2 + 8192];
            System.arraycopy(this.attrValBuffer, 0, cArray, 0, n2);
            this.attrValBuffer = cArray;
        }
    }

    final String readAttributeValue(AttributeDefinition attributeDefinition, ElementDefinition elementDefinition) throws IOException, ParseException, SAXException {
        int n;
        int n2;
        while (Character.isWhitespace((char)(n2 = this.read()))) {
        }
        this.miscIndex = 0;
        int n3 = 0;
        this.addCharToMiscBuffer((char)n2);
        if (n2 == 39 || n2 == 34) {
            n = n2;
            while ((n2 = this.read()) != -1 && n2 != n) {
                this.checkAttrValBuffer(n3);
                this.setCharToMiscBuffer(this.miscIndex, (char)n2);
                ++this.miscIndex;
                if (n2 == 38 && (this.extractChar || this.extractNum)) {
                    int n4;
                    if (!this.extractNum) {
                        n2 = this.read();
                        if (n2 == 35) {
                            this.attrValBuffer[n3++] = 38;
                            this.attrValBuffer[n3++] = 35;
                            continue;
                        }
                        this.unread(n2);
                    }
                    if ((n4 = this.rslvCharEnt()) == -1) {
                        this.attrValBuffer[n3++] = 38;
                        continue;
                    }
                    this.attrValBuffer[n3++] = (char)n4;
                    int n5 = 0;
                    while (n5 < this.entityBufIndex) {
                        this.addCharToMiscBuffer((char)this.entityBuf[n5]);
                        ++n5;
                    }
                    continue;
                }
                try {
                    this.attrValBuffer[n3] = (char)n2;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    char[] cArray = new char[this.attrValBuffer.length * 2];
                    System.arraycopy(this.attrValBuffer, 0, cArray, 0, n3);
                    this.attrValBuffer = cArray;
                }
                ++n3;
            }
            if (n2 != -1) {
                this.addCharToMiscBuffer((char)n2);
            } else {
                this.parser.error(11, "EOF in attribute value.");
            }
            if (this.miscIndex > 1 && (InsTokenizer.includeAngleBracket(this.miscBuffer, 1, this.miscIndex - 1) || this.miscBuffer[this.miscIndex - 2] == '=') && this.parser.handleError(11, new String(this.miscBuffer, 0, this.miscIndex))) {
                return this.readAttributeValue(attributeDefinition, elementDefinition);
            }
        } else {
            if (n2 == 62) {
                this.unread(n2);
                return "";
            }
            n = -1;
            if (!this.isUnquotedChar((char)n2) && (n = this.sence()) == 34 || n == 39 || Character.isWhitespace((char)n)) {
                return this.readAttributeValue(attributeDefinition, elementDefinition);
            }
            this.attrValBuffer[n3++] = (char)n2;
            while ((n2 = this.read()) != -1 && n2 != 62 && !Character.isWhitespace((char)n2)) {
                this.checkAttrValBuffer(n3);
                if (n2 == 38 && (this.extractChar || this.extractNum)) {
                    int n6;
                    if (!this.extractNum) {
                        n2 = this.read();
                        if (n2 == 35) {
                            this.attrValBuffer[n3++] = 38;
                            this.attrValBuffer[n3++] = 35;
                            continue;
                        }
                        this.unread(n2);
                    }
                    if ((n6 = this.rslvCharEnt()) == -1) {
                        this.attrValBuffer[n3++] = 38;
                        continue;
                    }
                    this.attrValBuffer[n3++] = (char)n6;
                    continue;
                }
                this.attrValBuffer[n3++] = (char)n2;
            }
            if (n2 == 62) {
                this.unread(n2);
            }
        }
        n2 = this.read();
        String string = new String(this.attrValBuffer, 0, n3);
        if (n2 == 34 || n2 == 39) {
            if (!this.parser.handleError(12, "\"")) {
                this.parser.error(9, "requires attribute name after \"" + string + '\"');
            }
        } else {
            this.unread(n2);
        }
        return string;
    }

    private int sence(int n) throws IOException {
        switch (n) {
            case 0: {
                int n2 = this.read();
                this.unread(n2);
                return n2;
            }
            case 1: {
                int n3 = this.read();
                int n4 = this.read();
                this.unread(n4);
                this.unread(n3);
                return n4;
            }
        }
        int[] nArray = new int[n];
        int n5 = 0;
        while (n5 < n) {
            nArray[n5] = this.read();
            ++n5;
        }
        n5 = n - 1;
        while (n5 >= 0) {
            this.unread(nArray[n5]);
            --n5;
        }
        return nArray[n - 1];
    }

    private int sence() throws IOException {
        int n = this.read();
        this.unread(n);
        return n;
    }

    private boolean isUnquotedChar(char c) {
        return Character.isLowerCase(c) || Character.isUpperCase(c) || Character.isDigit(c) || c == '-' || c == '.';
    }

    private int etag() throws ParseException, IOException {
        int n;
        while (Character.isWhitespace((char)(n = this.read()))) {
            this.addCharToMiscBuffer((char)n);
        }
        this.addCharToMiscBuffer((char)n);
        if (n == 62) {
            this.state = 0;
            this.sval = ">";
            this.parser.setCharacter(this.miscBuffer, this.etagStartIndex, this.miscIndex - this.etagStartIndex);
            this.ttype = 62;
            return 62;
        }
        if (n == -1) {
            this.state = 0;
            this.sval = "";
            this.ttype = -1;
            return -1;
        }
        if (Character.isLowerCase((char)n) || Character.isUpperCase((char)n)) {
            int n2 = this.miscIndex - 1;
            do {
                n = this.read();
                this.setCharToMiscBuffer(this.miscIndex, (char)n);
                ++this.miscIndex;
            } while (Character.isLowerCase((char)n) || Character.isUpperCase((char)n) || Character.isDigit((char)n) || n == 46 || n == 45 || n == 58 || n == 35);
            this.unread(n);
            --this.miscIndex;
            this.sval = new String(this.miscBuffer, n2, this.miscIndex - n2);
            this.ttype = 11;
            return 11;
        }
        return this.etag();
    }

    private int tag() throws ParseException, IOException {
        int n;
        this.miscIndex = 0;
        while (Character.isWhitespace((char)(n = this.read()))) {
        }
        if (n == 33) {
            System.out.println("comment between DOCTYPE and HTML !!!");
            return this.eatComment();
        }
        if (n == 62) {
            this.state = 0;
            this.sval = ">";
            this.ttype = 62;
            return 62;
        }
        if (n == -1) {
            this.state = 0;
            this.sval = "";
            this.ttype = -1;
            return -1;
        }
        if (Character.isLowerCase((char)n) || Character.isUpperCase((char)n)) {
            do {
                this.setCharToMiscBuffer(this.miscIndex, (char)n);
                ++this.miscIndex;
            } while (Character.isLowerCase((char)(n = this.read())) || Character.isUpperCase((char)n) || Character.isDigit((char)n) || n == 46 || n == 45 || n == 58 || n == 35);
            this.unread(n);
            this.sval = new String(this.miscBuffer, 0, this.miscIndex);
            this.ttype = 11;
            return 11;
        }
        if (Character.isDigit((char)n)) {
            do {
                this.addCharToMiscBuffer((char)n);
            } while (Character.isDigit((char)(n = this.read())));
            if (n == 37) {
                this.addCharToMiscBuffer((char)n);
            } else {
                this.unread(n);
            }
            this.sval = new String(this.miscBuffer, 0, this.miscIndex);
            this.ttype = 12;
            return 12;
        }
        if (n == 60) {
            n = this.read();
            if (n == 47) {
                this.sval = "</";
                this.miscBuffer[0] = 60;
                this.miscBuffer[1] = 47;
                this.etagStartIndex = 0;
                this.state = 8;
                this.ttype = 8;
                return 8;
            }
            this.unread(n);
            this.sval = "<";
            this.ttype = 60;
            return 60;
        }
        this.ttype = n;
        return this.ttype;
    }

    final void consumeUntil(char c) throws IOException {
        while (c != this.read()) {
        }
    }

    void setPreserveWhitespace(boolean bl) {
        this.prsvWS = bl;
    }

    private void expandBuffer(int n) {
        if (this.bufLimit != this.index) {
            n += this.index < this.bufLimit ? this.bufLimit + this.index : this.charBuffer.length - this.index + this.bufLimit;
        }
        int n2 = this.charBuffer.length * 2;
        while (n2 < n) {
            n2 *= 2;
        }
        char[] cArray = new char[n2];
        if (this.index < this.bufLimit) {
            System.arraycopy(this.charBuffer, this.index, cArray, this.index, this.bufLimit - this.index);
        } else if (this.index != this.bufLimit) {
            System.arraycopy(this.charBuffer, 0, cArray, 0, this.bufLimit);
            System.arraycopy(this.charBuffer, this.index, cArray, n2 - this.charBuffer.length + this.index, this.charBuffer.length - this.index);
            this.index = n2 - this.charBuffer.length + this.index;
        }
        this.charBuffer = cArray;
    }

    private void expandMiscBuffer() {
        char[] cArray = this.miscBuffer.length < 32768 ? new char[this.miscBuffer.length * 2] : new char[this.miscBuffer.length + 32768];
        System.arraycopy(this.miscBuffer, 0, cArray, 0, this.miscIndex);
        this.miscBuffer = cArray;
    }

    private void storeUntil(char c) throws IOException {
        int n = this.read();
        while (n != c && n != -1) {
            this.setCharToMiscBuffer(this.miscIndex, (char)n);
            ++this.miscIndex;
            n = this.read();
        }
    }

    final String eatUntil(char c) throws IOException {
        this.miscIndex = 0;
        int n = this.read();
        while (n != c && n != -1) {
            this.setCharToMiscBuffer(this.miscIndex, (char)n);
            ++this.miscIndex;
            n = this.read();
        }
        return new String(this.miscBuffer, 0, this.miscIndex);
    }

    private boolean fillBuffer() throws IOException {
        if (this.bufLimit == this.charBuffer.length) {
            this.index = 0;
            this.bufLimit = this.reader.read(this.charBuffer, 0, 1024);
            if (this.bufLimit == -1) {
                return false;
            }
        } else if (this.bufLimit + 1024 < this.charBuffer.length) {
            int n = this.reader.read(this.charBuffer, this.bufLimit, 1024);
            if (n == -1) {
                return false;
            }
            this.bufLimit += n;
        } else {
            int n = this.reader.read(this.charBuffer, this.bufLimit, this.charBuffer.length - this.bufLimit);
            if (n == -1) {
                return false;
            }
            this.bufLimit += n;
        }
        return true;
    }

    private int read() throws IOException {
        if (this.bufLimit == this.index) {
            if (!this.fillBuffer()) {
                return -1;
            }
        } else if (this.index == this.charBuffer.length) {
            this.index = 0;
        }
        char c = this.charBuffer[this.index++];
        if (this.skipLF) {
            if (c == '\n') {
                if (this.bufLimit == this.index) {
                    if (!this.fillBuffer()) {
                        return -1;
                    }
                } else if (this.index == this.charBuffer.length) {
                    this.index = 0;
                }
                ++this.lastLFindex;
                c = this.charBuffer[this.index++];
            }
            this.skipLF = false;
        }
        switch (c) {
            case '\r': {
                this.skipLF = true;
            }
            case '\n': {
                ++this.lineNumber;
                this.lastLFindex = this.index - 1;
                return 10;
            }
        }
        return c;
    }

    private void unread(int n) throws IOException {
        if (n == 10) {
            --this.lineNumber;
        }
        if (this.index == 0) {
            this.index = this.charBuffer.length - 1;
            this.charBuffer[this.index] = (char)n;
        } else {
            this.charBuffer[--this.index] = (char)n;
        }
    }

    void unread(String string) throws IOException {
        this.unread(string.toCharArray());
    }

    private void unread(char[] cArray, int n, int n2) {
        if (this.bufLimit >= this.index) {
            if (this.charBuffer.length - (this.bufLimit - this.index) < n2) {
                this.expandBuffer(n2);
            }
        } else if (this.index - this.bufLimit < n2) {
            this.expandBuffer(n2);
        }
        if (this.index < n2) {
            int n3 = n + n2 - 1;
            int n4 = this.index - 1;
            while (n4 >= 0) {
                if ((this.charBuffer[n4] = cArray[n3--]) == '\n') {
                    --this.lineNumber;
                }
                --n4;
            }
            n4 = this.charBuffer.length - 1;
            while (n3 >= n) {
                if ((this.charBuffer[n4] = cArray[n3--]) == '\n') {
                    --this.lineNumber;
                }
                --n4;
            }
            this.index = n4 + 1;
        } else {
            int n5 = n + n2 - 1;
            while (n5 >= n) {
                this.charBuffer[--this.index] = cArray[n5];
                if (this.charBuffer[--this.index] == '\n') {
                    --this.lineNumber;
                }
                --n5;
            }
        }
    }

    private void unread(char[] cArray) {
        this.unread(cArray, 0, cArray.length);
    }

    final int nextToken() throws IOException, ParseException, SAXException {
        if (this.pushBacked) {
            this.pushBacked = false;
            return this.ttype;
        }
        switch (this.state) {
            case 0: {
                return this.defaultState();
            }
            case 1: {
                return this.tag();
            }
            case 2: {
                return this.etag();
            }
        }
        this.ttype = -1;
        return -1;
    }

    final void pushBack() {
        this.pushBacked = true;
    }

    final int getCurrentLine() {
        return this.lineNumber + 1;
    }

    final int getCurrentCol() {
        return this.getColumnNumber();
    }

    final void switchTo(int n) {
        this.state = n;
    }

    final void close() throws IOException {
        this.reader.close();
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber + 1;
    }

    public int getColumnNumber() {
        int n = this.index >= this.lastLFindex ? this.index - this.lastLFindex : this.charBuffer.length - this.lastLFindex + this.index;
        return n;
    }
}

