/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.html;

import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;

public class NodeUtil {
    public static Node commonAncestor(Node node, Node node2) {
        Node node3 = node.getParentNode();
        while (node3 != null) {
            Node node4 = node2.getParentNode();
            while (node4 != null) {
                if (node3 == node4) {
                    return node3;
                }
                node4 = node4.getParentNode();
            }
            node3 = node3.getParentNode();
        }
        return null;
    }

    public static void remove(Node node) {
        Node node2 = node.getParentNode();
        if (node2 == null) {
            throw new IllegalArgumentException(node + " doesn't have a parent");
        }
        Node node3 = node.getFirstChild();
        while (node3 != null) {
            node.removeChild(node3);
            node2.insertBefore(node3, node);
            node3 = node.getFirstChild();
        }
        node2.removeChild(node);
    }

    public static void add(Node node, Node node2, Node node3, Node node4) {
        if (node == null) {
            throw new IllegalArgumentException("parent=null");
        }
        if (node2.getParentNode() != null) {
            throw new IllegalArgumentException(node2 + " already has its parent");
        }
        if (node3 != null) {
            if (node3.getParentNode() != node) {
                throw new IllegalArgumentException(node3 + "'s parent isn't " + node);
            }
            if (node4.getParentNode() != node) {
                throw new IllegalArgumentException(node4 + "'s parent isn't " + node);
            }
            Node node5 = node3;
            while (node5 != null) {
                if (node5 == node4) {
                    node.insertBefore(node2, node3);
                    node5 = node3;
                    while (node5 != node4) {
                        node.removeChild(node5);
                        node2.insertBefore(node5, null);
                        node5 = node2.getNextSibling();
                    }
                    node.removeChild(node4);
                    node2.insertBefore(node4, null);
                    return;
                }
                node5 = node5.getNextSibling();
            }
            throw new IllegalArgumentException("No link from " + node3 + " to " + node4);
        }
        node.insertBefore(node2, null);
    }

    public static Node commonAncestor(HTMLCollection hTMLCollection) {
        switch (hTMLCollection.getLength()) {
            case 0: {
                return null;
            }
            case 1: {
                return hTMLCollection.item(0).getParentNode();
            }
        }
        Node node = NodeUtil.commonAncestor(hTMLCollection.item(0), hTMLCollection.item(1));
        int n = 2;
        while (n < hTMLCollection.getLength()) {
            Node node2 = NodeUtil.commonAncestor(hTMLCollection.item(n - 1), hTMLCollection.item(n));
            if (node != node2) {
                node = NodeUtil.commonAncestor(node, node2);
            }
            ++n;
        }
        return node;
    }
}

