/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.core.adapt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.actf.core.adapt.IAdaptor;
import org.eclipse.actf.core.adapt.IAdaptorFactory;
import org.eclipse.actf.util.resources.ClassLoaderCache;

public class DefaultAdaptorFactory
implements IAdaptorFactory {
    protected static final ClassLoaderCache _clCache = ClassLoaderCache.getDefault();
    private static DefaultAdaptorFactory factoryInstance;
    private Map _adaptorMap = new HashMap();

    protected DefaultAdaptorFactory() {
    }

    public static DefaultAdaptorFactory getInstance() {
        if (factoryInstance == null) {
            factoryInstance = new DefaultAdaptorFactory();
        }
        return factoryInstance;
    }

    public void registerAdaptor(Class clazz, IAdaptor iAdaptor) {
        String string = clazz.getName();
        LinkedList<IAdaptor> linkedList = (LinkedList<IAdaptor>)this._adaptorMap.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<IAdaptor>();
            this._adaptorMap.put(string, linkedList);
        }
        linkedList.add(iAdaptor);
    }

    public IAdaptor[] getAdaptors(Class clazz) {
        return this.getAdaptors(clazz.getName());
    }

    public IAdaptor[] getAdaptors(String string) {
        List list = (List)this._adaptorMap.get(string);
        return list == null ? new IAdaptor[]{} : list.toArray(new IAdaptor[list.size()]);
    }

    public IAdaptor[] getAllAdaptors(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        ArrayList<IAdaptor> arrayList = new ArrayList<IAdaptor>();
        do {
            List list;
            if ((list = (List)this._adaptorMap.get(clazz.getName())) == null || list.isEmpty()) continue;
            arrayList.addAll(list);
        } while ((clazz = clazz.getSuperclass()) != null);
        int n = 0;
        while (n < classArray.length) {
            List<IAdaptor> list;
            List list2 = (List)this._adaptorMap.get(classArray[n].getName());
            if (list2 != null && !list2.isEmpty()) {
                arrayList.addAll(list2);
            }
            if ((list = Arrays.asList(this.getAllAdaptors(classArray[n]))) != null && !list.isEmpty()) {
                arrayList.addAll(list);
            }
            ++n;
        }
        return arrayList.isEmpty() ? new IAdaptor[]{} : arrayList.toArray(new IAdaptor[arrayList.size()]);
    }
}

