/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.emf.compare.reports.html;

import com.google.common.base.Objects;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.sphinx.emf.compare.report.AbstractModelCompareReportGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ModelCompareHTMLReportGenerator
extends AbstractModelCompareReportGenerator {
    private static final String MODEL_DIFF_REPORT_TARGET_HTML_FILE_NAME = "{0}_{1}_diffs.html";

    protected CharSequence doGenerate(Comparison comparison) {
        return this.generateHTML(comparison);
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
        this.generate(comparison);
    }

    public void generate(Comparison comparison) {
        boolean _notEquals;
        IProject targetProject = this.getTargetProject(comparison);
        boolean bl = _notEquals = !Objects.equal((Object)targetProject, null);
        if (_notEquals) {
            boolean _not;
            IFolder folder = targetProject.getFolder("reports");
            boolean _exists = folder.exists();
            boolean bl2 = _not = !_exists;
            if (_not) {
                this.createFolder(folder);
            }
            Notifier _leftObject = this.getLeftObject(comparison);
            String _name = this.getName(_leftObject);
            Notifier _rightObject = this.getRightObject(comparison);
            String _name_1 = this.getName(_rightObject);
            String _format = MessageFormat.format(MODEL_DIFF_REPORT_TARGET_HTML_FILE_NAME, _name, _name_1);
            IFile targetFile = folder.getFile(_format);
            this.generate(comparison, targetFile);
        }
    }

    public CharSequence generateHTML(Comparison comparison) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal((Object)comparison, null);
        if (_notEquals) {
            Notifier leftObject = this.getLeftObject(comparison);
            _builder.newLineIfNotEmpty();
            Notifier rightObject = this.getRightObject(comparison);
            _builder.newLineIfNotEmpty();
            _builder.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
            _builder.newLine();
            _builder.append("<html>");
            _builder.newLine();
            _builder.append("<head>");
            _builder.newLine();
            _builder.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            _builder.newLine();
            _builder.append("<style>");
            _builder.newLine();
            _builder.append(".AlignLeft { text-align: left; }");
            _builder.newLine();
            _builder.append(".AlignCenter { text-align: center; }");
            _builder.newLine();
            _builder.append(".AlignRight { text-align: right; }");
            _builder.newLine();
            _builder.append("body { font-family: sans-serif; font-size: 11pt; }");
            _builder.newLine();
            _builder.append("td, th { vertical-align: top; padding-left: 4px; padding-right: 4px; }");
            _builder.newLine();
            _builder.append("tr.SectionAll td, th { border-left: none; border-top: none; border-bottom: 1px solid Black; border-right: 1px solid Black; }");
            _builder.newLine();
            _builder.append("table.fc { border-top: 1px solid Black; border-left: 1px solid Black; width: 100%; font-family: monospace; font-size: 10pt; }");
            _builder.newLine();
            _builder.append("td.Text { color: #000000; background-color: #FFFFFF; }");
            _builder.newLine();
            _builder.append("</style>");
            _builder.newLine();
            _builder.append("<title>Model Differences (");
            String _modelCompareInputText = this.getModelCompareInputText(leftObject);
            _builder.append(_modelCompareInputText, "");
            _builder.append(" - ");
            String _modelCompareInputText_1 = this.getModelCompareInputText(rightObject);
            _builder.append(_modelCompareInputText_1, "");
            _builder.append(")</title>");
            _builder.newLineIfNotEmpty();
            _builder.append("</head>");
            _builder.newLine();
            _builder.append("<body>");
            _builder.newLine();
            _builder.append("Model Differences<br>");
            _builder.newLine();
            _builder.append("&nbsp; &nbsp;");
            _builder.newLine();
            _builder.append("<br>");
            _builder.newLine();
            _builder.append("<table class=\"fc\" cellspacing=\"0\" cellpadding=\"0\">");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("<tbody>");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("<tr class=\"SectionAll\">");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("<th colspan=\"2\">Left: ");
            String _modelCompareInputText_2 = this.getModelCompareInputText(leftObject);
            _builder.append(_modelCompareInputText_2, "\t\t\t");
            _builder.append("</th>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("<th>  </th>");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("<th colspan=\"2\">Right: ");
            String _modelCompareInputText_3 = this.getModelCompareInputText(rightObject);
            _builder.append(_modelCompareInputText_3, "\t\t\t");
            _builder.append("</th>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("</tr>");
            _builder.newLine();
            EList _differences = comparison.getDifferences();
            for (Diff diff : _differences) {
                _builder.append("\t\t");
                _builder.append("<tr class=\"SectionAll\">");
                _builder.newLine();
                _builder.append("\t\t");
                Map differences = this.handleDifferences(comparison, diff);
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("<td class=\"Text\">");
                Object _get = differences.get("leftURI");
                _builder.append(_get, "\t\t\t");
                _builder.append("</td>");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("<td class=\"Text\">");
                Object _get_1 = differences.get("leftChangeText");
                _builder.append(_get_1, "\t\t\t");
                _builder.append("</td>");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("<td class=\"AlignCenter\">");
                Object _get_2 = differences.get("kind");
                _builder.append(_get_2, "\t\t\t");
                _builder.append("</td>");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("<td class=\"Text\">");
                Object _get_3 = differences.get("rightURI");
                _builder.append(_get_3, "\t\t\t");
                _builder.append("</td>");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("<td class=\"Text\">");
                Object _get_4 = differences.get("rightChangeText");
                _builder.append(_get_4, "\t\t\t");
                _builder.append("</td>");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("</tr>");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("</tbody>");
            _builder.newLine();
            _builder.append("</table>");
            _builder.newLine();
            _builder.append("<br>");
            _builder.newLine();
            _builder.append("</body></html>");
            _builder.newLine();
        }
        return _builder;
    }
}

