/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.eclipse.ui.services.model;

import org.eclipse.ecf.mgmt.framework.IServiceManagerAsync;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.AbstractServicesNode;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.ServiceNode;

public class RemoteServiceManagerNode
extends AbstractServicesNode {
    private final IRemoteServiceReference managerRef;
    private final IServiceManagerAsync rsaManager;

    public RemoteServiceManagerNode(IRemoteServiceReference managerRef, IServiceManagerAsync rsaManager) {
        this.managerRef = managerRef;
        this.rsaManager = rsaManager;
    }

    public IServiceManagerAsync getRemoteServiceManager() {
        return this.rsaManager;
    }

    public IRemoteServiceReference getRemoteServiceReference() {
        return this.managerRef;
    }

    public String getManagerContainer() {
        return this.managerRef.getID().getContainerID().getName();
    }

    public String getName() {
        return String.valueOf(this.getManagerContainer()) + ":" + this.managerRef.getID().getContainerRelativeID();
    }

    public ServiceNode getServiceNode(long id) {
        AbstractServicesNode[] abstractServicesNodeArray = this.getChildren();
        int n = abstractServicesNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceNode serviceNode;
            AbstractServicesNode sn = abstractServicesNodeArray[n2];
            if (sn instanceof ServiceNode && (serviceNode = (ServiceNode)sn).getServiceId() == id) {
                return serviceNode;
            }
            ++n2;
        }
        return null;
    }
}

