/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.eclipse.ui.services.model;

import org.eclipse.ecf.mgmt.framework.IBundleManagerAsync;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.AbstractBundlesNode;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.BundleNode;

public class RemoteBundleManagerNode
extends AbstractBundlesNode {
    private final IRemoteServiceReference managerRef;
    private final IBundleManagerAsync bundleManager;

    public RemoteBundleManagerNode(IRemoteServiceReference managerRef, IBundleManagerAsync bundleManager) {
        this.managerRef = managerRef;
        this.bundleManager = bundleManager;
    }

    public IBundleManagerAsync getBundleManager() {
        return this.bundleManager;
    }

    public IRemoteServiceReference getBundleManagerRef() {
        return this.managerRef;
    }

    public String getManagerContainer() {
        return this.managerRef.getID().getContainerID().getName();
    }

    public String getName() {
        return String.valueOf(this.getManagerContainer()) + ":" + this.managerRef.getID().getContainerRelativeID();
    }

    public BundleNode getBundleNode(long bundleId) {
        AbstractBundlesNode[] abstractBundlesNodeArray = this.getChildren();
        int n = abstractBundlesNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleNode bundleNode;
            AbstractBundlesNode bn = abstractBundlesNodeArray[n2];
            if (bn instanceof BundleNode && (bundleNode = (BundleNode)bn).getId() == bundleId) {
                return bundleNode;
            }
            ++n2;
        }
        return null;
    }
}

