/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.eclipse.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MqttConnectDialog
extends Dialog {
    private static final int RESET_ID = 22;
    private Text brokerUrlField;
    private Text usernameField;
    private Text passwordField;
    private String brokerUrlDefault;
    private String title;
    private String brokerUrl;
    private String username;
    private String password;

    public MqttConnectDialog(Shell parentShell, String title, String brokerUrlDefault) {
        super(parentShell);
        this.brokerUrlDefault = brokerUrlDefault;
        this.title = title;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.numColumns = 2;
        Label brokerUrlLabel = new Label(comp, 131072);
        brokerUrlLabel.setText("Broker URL: ");
        this.brokerUrlField = new Text(comp, 4);
        if (this.brokerUrlDefault != null) {
            this.brokerUrlField.setText(this.brokerUrlDefault);
        }
        Label usernameLabel = new Label(comp, 131072);
        usernameLabel.setText("Username: ");
        this.usernameField = new Text(comp, 4);
        GridData data = new GridData(768);
        this.usernameField.setLayoutData((Object)data);
        Label passwordLabel = new Label(comp, 131072);
        passwordLabel.setText("Password: ");
        this.passwordField = new Text(comp, 0x400004);
        data = new GridData(768);
        this.passwordField.setLayoutData((Object)data);
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 22, "Reset All", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 22) {
            this.brokerUrlField.setText(this.brokerUrlDefault);
            this.usernameField.setText("");
            this.passwordField.setText("");
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        this.brokerUrl = this.brokerUrlField.getText();
        this.username = this.usernameField.getText();
        this.password = this.passwordField.getText();
        super.okPressed();
    }

    public String getBrokerUrl() {
        if (this.brokerUrl == null || "".equals(this.brokerUrl)) {
            return null;
        }
        return this.brokerUrl;
    }

    public String getUsername() {
        if (this.username == null || "".equals(this.username)) {
            return null;
        }
        return this.username;
    }

    public String getPassword() {
        if (this.password == null || "".equals(this.password)) {
            return null;
        }
        return this.password;
    }
}

