/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.eclipse.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.mgmt.framework.BundleEventMTO;
import org.eclipse.ecf.mgmt.framework.IBundleEventHandler;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.IBundleEventHandlerDelegate;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;

public class BundleEventHandler
implements IBundleEventHandler {
    private static Map<IRemoteServiceID, IBundleEventHandlerDelegate> behs = new HashMap<IRemoteServiceID, IBundleEventHandlerDelegate>();
    private ID containerID;
    private long rsid;

    public BundleEventHandler(RemoteServiceAdmin.ImportReference importReference) {
        this.containerID = importReference.getContainerID();
        this.rsid = importReference.getRemoteServiceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDelegate(IRemoteServiceID rsID, IBundleEventHandlerDelegate delegate) {
        Map<IRemoteServiceID, IBundleEventHandlerDelegate> map = behs;
        synchronized (map) {
            behs.put(rsID, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDelegate(IRemoteServiceID rsID) {
        Map<IRemoteServiceID, IBundleEventHandlerDelegate> map = behs;
        synchronized (map) {
            behs.remove(rsID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDelegates() {
        Map<IRemoteServiceID, IBundleEventHandlerDelegate> map = behs;
        synchronized (map) {
            behs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBundleEvent(BundleEventMTO bundleEvent) {
        IRemoteServiceID rsID = null;
        IBundleEventHandlerDelegate beh = null;
        Map<IRemoteServiceID, IBundleEventHandlerDelegate> map = behs;
        synchronized (map) {
            for (IRemoteServiceID rsid : behs.keySet()) {
                if (!rsid.getContainerID().equals((Object)this.containerID) || rsid.getContainerRelativeID() != this.rsid) continue;
                rsID = rsid;
                beh = behs.get(rsID);
                break;
            }
        }
        if (beh != null) {
            beh.handleBundleEvent(rsID, bundleEvent);
        } else {
            System.out.println("RECEIVED bundleEvent=" + bundleEvent);
        }
    }
}

