/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.match;

import org.locationtech.jts.algorithm.distance.DiscreteFrechetDistance;
import org.locationtech.jts.algorithm.match.HausdorffSimilarityMeasure;
import org.locationtech.jts.algorithm.match.SimilarityMeasure;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class FrechetSimilarityMeasure
implements SimilarityMeasure {
    @Override
    public double measure(Geometry g1, Geometry g2) {
        if (!g1.getGeometryType().equals(g2.getGeometryType())) {
            throw new IllegalArgumentException("g1 and g2 are of different type");
        }
        double frechetDistance = DiscreteFrechetDistance.distance(g1, g2);
        if (frechetDistance == 0.0) {
            return 1.0;
        }
        Envelope env = new Envelope(g1.getEnvelopeInternal());
        env.expandToInclude(g2.getEnvelopeInternal());
        double envDiagSize = HausdorffSimilarityMeasure.diagonalSize(env);
        return 1.0 - frechetDistance / envDiagSize;
    }
}

