/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;

@Experimental
public class AsyncIteratorBuffer
extends LookAheadIteration<BindingSet> {
    private final CloseableIteration<BindingSet> iteration;
    private final ConcurrentLinkedQueue<BindingSet> queue = new ConcurrentLinkedQueue();
    private Future<ArrayDeque<BindingSet>> future;
    ArrayDeque<BindingSet> nextBuffer;
    BindingSet next;

    public AsyncIteratorBuffer(CloseableIteration<BindingSet> iteration) throws QueryEvaluationException {
        this.iteration = iteration;
    }

    public static CloseableIteration<BindingSet> getInstance(QueryEvaluationStep iterationPrepared, BindingSet bindings, QueryEvaluationContext context) {
        CloseableIteration<BindingSet> iter = iterationPrepared.evaluate(bindings);
        if (iter == QueryEvaluationStep.EMPTY_ITERATION) {
            return iter;
        }
        return new AsyncIteratorBuffer(iter);
    }

    void calculateNext() {
        if (this.next != null) {
            return;
        }
        if (this.future == null) {
            try {
                this.async();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        this.next = this.queue.poll();
        if (this.next != null) {
            return;
        }
        while (!this.future.isDone() && !this.future.isCancelled() && this.queue.isEmpty()) {
            Thread.onSpinWait();
        }
        this.next = this.queue.poll();
    }

    private void async() throws ExecutionException, InterruptedException {
        this.future = ForkJoinPool.commonPool().submit(() -> {
            while (this.iteration.hasNext()) {
                this.queue.add((BindingSet)this.iteration.next());
            }
            return null;
        });
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        this.calculateNext();
        BindingSet temp = this.next;
        this.next = null;
        return temp;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
        finally {
            this.iteration.close();
        }
    }
}

