/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model;

import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ModelNamespace;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.NamespaceAware;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;

public interface Model
extends Set<Statement>,
Serializable,
NamespaceAware {
    public Model unmodifiable();

    default public Namespace setNamespace(String prefix, String name) {
        Optional<Namespace> result = this.getNamespace(prefix);
        if (!result.isPresent() || !result.get().getName().equals(name)) {
            result = Optional.of(new ModelNamespace(prefix, name));
            this.setNamespace(result.get());
        }
        return result.get();
    }

    public void setNamespace(Namespace var1);

    public Optional<Namespace> removeNamespace(String var1);

    public boolean contains(Resource var1, IRI var2, Value var3, Resource ... var4);

    public boolean add(Resource var1, IRI var2, Value var3, Resource ... var4);

    public boolean clear(Resource ... var1);

    public boolean remove(Resource var1, IRI var2, Value var3, Resource ... var4);

    default public Iterable<Statement> getStatements(Resource subject, IRI predicate, Value object, Resource ... contexts) {
        return () -> this.filter(subject, predicate, object, contexts).iterator();
    }

    public Model filter(Resource var1, IRI var2, Value var3, Resource ... var4);

    public Set<Resource> subjects();

    public Set<IRI> predicates();

    public Set<Value> objects();

    default public Set<Resource> contexts() {
        Set<Resource> subjects = this.stream().map(st -> st.getContext()).collect(Collectors.toSet());
        return subjects;
    }
}

