/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.access.jdt.JdtTypeProviderFactory;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.testing.ContentAssistProcessorTestBuilder;
import org.eclipse.xtext.ui.testing.util.JavaProjectSetupUtil;
import org.eclipse.xtext.ui.testing.util.ResourceLoadHelper;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;

public abstract class AbstractContentAssistTest
implements ResourceLoadHelper,
IJavaProjectProvider {
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    private Injector injector;
    private static IJavaProject javaProject;

    @BeforeClass
    @BeforeAll
    public static void setUp() throws CoreException {
        javaProject = JavaProjectSetupUtil.createJavaProject("contentAssistTest");
    }

    @AfterClass
    @AfterAll
    public static void tearDown() throws CoreException {
        IProject project = javaProject.getProject();
        project.delete(true, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public XtextResource getResourceFor(InputStream stream) {
        XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
        this.initializeTypeProvider(resourceSet);
        try {
            URI resourceUri = URI.createURI((String)("Test." + this.fileExtensionProvider.getPrimaryFileExtension()));
            Resource resource = resourceSet.createResource(resourceUri);
            resource.load(stream, null);
            return (XtextResource)resource;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IJavaProject getJavaProject(ResourceSet resourceSet) {
        return javaProject;
    }

    protected List<String> expect(String[] ... arrays) {
        ArrayList<String> expectation = new ArrayList<String>();
        String[][] stringArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            String[] array = stringArray[n2];
            expectation.addAll(Arrays.asList(array));
            ++n2;
        }
        return expectation;
    }

    protected ContentAssistProcessorTestBuilder newBuilder() throws Exception {
        return new ContentAssistProcessorTestBuilder(this.injector, this);
    }

    protected void initializeTypeProvider(XtextResourceSet resourceSet) {
        JdtTypeProviderFactory typeProviderFactory = new JdtTypeProviderFactory((IJavaProjectProvider)this);
        typeProviderFactory.findOrCreateTypeProvider((ResourceSet)resourceSet);
        resourceSet.setClasspathURIContext((Object)this.getJavaProject((ResourceSet)resourceSet));
    }
}

