/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.MetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerMessages;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.DeployedImportResolver;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.osgi.util.NLS;

public class DeployedQvtModule
extends QvtModule {
    private Module myModule;
    private CompiledUnit myUnit;
    private QVTOCompiler myCompiler;
    private String moduleID;

    public DeployedQvtModule(String qvtModuleID) {
        if (qvtModuleID == null || qvtModuleID.length() == 0) {
            throw new IllegalArgumentException("Invalid QVT module ID");
        }
        this.moduleID = qvtModuleID;
    }

    protected IMetamodelRegistryProvider creatMetamodelRegistryProvider() {
        return new MetamodelRegistryProvider();
    }

    public Module getModule() throws MdaException {
        if (this.myModule == null) {
            DeployedImportResolver unitResolver = DeployedImportResolver.INSTANCE;
            UnitProxy srcUnit = unitResolver.resolveDeployedUnitOnly(this.moduleID);
            if (srcUnit == null) {
                throw new MdaException(NLS.bind((String)CompilerMessages.importedModuleNotFound, (Object)this.moduleID));
            }
            QVTOCompiler qvtCompiler = new QVTOCompiler((UnitResolver)unitResolver, this.creatMetamodelRegistryProvider());
            QvtCompilerOptions options = this.getQvtCompilerOptions();
            if (options == null) {
                options = new QvtCompilerOptions();
                options.setGenerateCompletionData(false);
            }
            this.myUnit = qvtCompiler.compile(srcUnit, options, null);
            if (!options.isModuleWithErrorAllowed()) {
                this.checkModuleErrors(this.myUnit);
            }
            this.myModule = (Module)this.myUnit.getModules().get(0);
            this.myCompiler = qvtCompiler;
        }
        return this.myModule;
    }

    public QVTOCompiler getCompiler() throws MdaException {
        this.getModule();
        return this.myCompiler;
    }

    public CompiledUnit getUnit() throws MdaException {
        this.getModule();
        return this.myUnit;
    }

    public String toString() {
        return "deployed:/" + this.moduleID;
    }
}

