/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFolder;
import org.eclipse.m2m.internal.qvt.oml.compiler.IImportResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.impl.ExpressionsFactoryImpl;
import org.eclipse.ocl.ecore.EcoreEnvironment;

public class QvtCompilerKernel {
    private final IImportResolver myImportResolver;
    private final IMetamodelRegistryProvider myMetamodelRegistryProvider;
    private final Map<MappingModuleCS, Module> mySyntaxToSemanticMap = new HashMap<MappingModuleCS, Module>();
    private ResourceSet myMetamodelResourceSet;

    public QvtCompilerKernel(IImportResolver importResolver, IMetamodelRegistryProvider metamodelRegistryProvider) {
        this.myImportResolver = importResolver;
        this.myMetamodelRegistryProvider = metamodelRegistryProvider;
    }

    public IImportResolver getImportResolver() {
        return this.myImportResolver;
    }

    public IMetamodelRegistryProvider getMetamodelRegistryProvider() {
        return this.myMetamodelRegistryProvider;
    }

    public String getExpectedPackageName(CFolder folder) {
        String packageName = this.myImportResolver.getPackageName(folder);
        return packageName;
    }

    public Module getModule(MappingModuleCS mmas) {
        return this.mySyntaxToSemanticMap.get(mmas);
    }

    public Module createModule(MappingModuleCS mmas, QvtCompilerOptions options, EcoreEnvironment env, CFile cFile) {
        Module module = ExpressionsFactory.eINSTANCE.createModule();
        module.setEFactoryInstance(new ExpressionsFactoryImpl());
        this.mySyntaxToSemanticMap.put(mmas, module);
        if (options.isGenerateCompletionData()) {
            ASTBindingHelper.createModuleBinding(mmas, module, env, cFile);
        }
        return module;
    }

    public ResourceSet getMetamodelResourceSet() {
        return this.myMetamodelResourceSet;
    }

    public void setMetamodelResourceSet(ResourceSet metamodelResourceSet) {
        this.myMetamodelResourceSet = metamodelResourceSet;
    }
}

