/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFolder;
import org.eclipse.m2m.internal.qvt.oml.common.io.CResource;
import org.eclipse.m2m.internal.qvt.oml.common.io.CResourceRepositoryContext;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerKernel;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.Library;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryCreationException;
import org.eclipse.m2m.internal.qvt.oml.stdlib.LegacyNativeLibSupport;
import org.eclipse.m2m.internal.qvt.oml.stdlib.QVTUMLReflection;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.expressions.ExpressionsFactory;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ProblemOption;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalFileEnv
extends QvtOperationalEnv {
    public static final String THIS_VAR_QNAME_SUFFIX = ".this";
    private final QvtCompilerKernel myKernel;
    private QVTUMLReflection myQvtUMLReflection;
    private final CFile myFile;
    private String myQualifiedThisName;
    private List<Module> myLibs;

    protected QvtOperationalFileEnv(QvtOperationalEnv parent, CFile file, QvtCompilerKernel kernel) {
        super(parent, (EPackage.Registry)new EPackageRegistryImpl());
        this.myFile = file;
        this.myKernel = kernel;
        this.setOption((Option)ProblemOption.ELEMENT_NAME_QUOTE_ESCAPE, ProblemHandler.Severity.OK);
        this.setOption((Option)ProblemOption.STRING_CASE_CONVERSION, ProblemHandler.Severity.OK);
        QvtOperationalStdLibrary.INSTANCE.importTo(this);
    }

    @Override
    public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
        if (this.myQvtUMLReflection == null) {
            this.myQvtUMLReflection = new QVTUMLReflection(super.getUMLReflection(), QvtOperationalStdLibrary.INSTANCE);
        }
        return this.myQvtUMLReflection;
    }

    public QvtCompilerKernel getKernel() {
        return this.myKernel;
    }

    @Override
    public MetamodelRegistry getMetamodelRegistry() {
        MetamodelRegistry registry = this.getKernel().getMetamodelRegistryProvider().getRegistry((IMetamodelRegistryProvider.IRepositoryContext)new CResourceRepositoryContext((CResource)this.myFile));
        if (registry != null) {
            return registry;
        }
        return super.getMetamodelRegistry();
    }

    public CFile getFile() {
        return this.myFile;
    }

    public String getUnitName() {
        return this.myFile.getUnitName();
    }

    public String getExpectedPackageName() {
        CFolder parent = this.myFile.getParent();
        if (parent == null) {
            return "";
        }
        return this.getKernel().getExpectedPackageName(parent);
    }

    public Module getModule(MappingModuleCS mmas) {
        return this.getKernel().getModule(mmas);
    }

    public Module createModule(MappingModuleCS mmas, QvtCompilerOptions options, CFile cFile) {
        Module module = this.getKernel().createModule(mmas, options, this, cFile);
        Variable thisVar = ExpressionsFactory.eINSTANCE.createVariable();
        String prefix = QvtOperationalParserUtil.getMappingModuleSimpleName(mmas.getHeaderCS());
        this.myQualifiedThisName = String.valueOf(prefix) + THIS_VAR_QNAME_SUFFIX;
        thisVar.setName(this.myQualifiedThisName);
        thisVar.setType((Object)module);
        this.addElement(this.myQualifiedThisName, thisVar, false);
        return module;
    }

    public Variable<EClassifier, EParameter> lookup(String name) {
        if ("this".equals(name)) {
            return super.lookup(this.myQualifiedThisName);
        }
        return super.lookup(name);
    }

    @Override
    public final Module getModuleContextType() {
        if (this.myQualifiedThisName != null) {
            Variable<EClassifier, EParameter> var = this.lookup(this.myQualifiedThisName);
            return var != null ? (Module)var.getType() : null;
        }
        return null;
    }

    public String toString() {
        return "Env:" + this.myFile.getFullPath();
    }

    @Override
    public List<Module> getNativeLibs() {
        return this.myLibs == null ? Collections.emptyList() : Collections.unmodifiableList(this.myLibs);
    }

    public Module defineNativeLibrary(Library lib, ResourceSet rs) throws LibraryCreationException {
        if (this.myLibs == null) {
            this.myLibs = new LinkedList<Module>();
        }
        Module libModule = LegacyNativeLibSupport.INSTANCE.defineLibrary(this, lib, rs);
        this.myLibs.add(libModule);
        Variable var = ExpressionsFactory.eINSTANCE.createVariable();
        var.setName(String.valueOf(libModule.getName()) + THIS_VAR_QNAME_SUFFIX);
        var.setType((Object)libModule);
        this.addElement(var.getName(), var, false);
        return libModule;
    }
}

