/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: Document.java,v 1.1 2007/03/18 08:10:11 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfweb;


import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;

import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Document</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.Document#getStatement <em>statement</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.Document#getLocalName <em>localName</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.Document#getXmlBase <em>xmlBase</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.Document#getNamespaceDefinition <em>namespaceDefinition</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#getDocument()
 * @model
 * @generated
 */
public interface Document extends RDFSResource {
	/**
	 * Returns the value of the '<em><b>statement</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFStatement}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getDocument <em>document</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Statement</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>statement</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#getDocument_Statement()
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement#getDocument
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFStatement" opposite="document" required="true"
	 * @generated
	 */
	EList getStatement();

	/**
	 * Returns the value of the '<em><b>localName</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfweb.LocalName}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Local Name</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>localName</em>' containment reference list.
	 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#getDocument_LocalName()
	 * @model type="org.eclipse.eodm.rdf.rdfweb.LocalName" containment="true"
	 * @generated
	 */
	EList getLocalName();

	/**
	 * Returns the value of the '<em><b>xmlBase</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfweb.Namespace}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Xml Base</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>xmlBase</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#getDocument_XmlBase()
	 * @model type="org.eclipse.eodm.rdf.rdfweb.Namespace"
	 * @generated
	 */
	EList getXmlBase();

	/**
	 * Returns the value of the '<em><b>namespaceDefinition</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Namespace Definition</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>namespaceDefinition</em>' containment reference list.
	 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#getDocument_NamespaceDefinition()
	 * @model type="org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition" containment="true"
	 * @generated
	 */
	EList getNamespaceDefinition();	
	/**
	 * The value of the '<em><b>Graphs</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFGraph}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * The Graphs EList of the Document can be operated to add, delete or retrieve RDFGraph.  
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Graphs</em>' containment reference list.
	 * @generated
	 */
	ArrayList getGraphs();
	/**
	 * The resources excluded from EList returned by {@link #getGraphs() getGraphs()}
	 * are included the complemental graph.
	 * @return the value of complemental graph
	 */
	RDFGraph getComplementalGraph();
	
	/**
	 * 
	 * Set the complemental graph of the document.
	 * @param graph the complemental graph
	 */
	void setComplementalGraph(RDFGraph graph);

} // Document
