/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: OWLBasePackage.java,v 1.1 2007/03/18 08:10:13 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase.util;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfs.util.RDFSPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.eodm.owl.owlbase.util.OWLBaseFactory
 * @model kind="package"
 * @generated
 */
public interface OWLBasePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "owlbase";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///odm 2006-02-17/org/omg/odm/OWL/OWLBase.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "odm 2006-02-17.org.omg.odm.OWL.OWLBase";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	OWLBasePackage eINSTANCE = org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.OWLOntologyImpl <em>OWL Ontology</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.OWLOntologyImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getOWLOntology()
	 * @generated
	 */
	int OWL_ONTOLOGY = 0;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__RDF_SIS_DEFINED_BY = RDFBasePackage.RDFS_RESOURCE__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__RDF_SSEE_ALSO = RDFBasePackage.RDFS_RESOURCE__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__RD_FTYPE = RDFBasePackage.RDFS_RESOURCE__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__RDF_SMEMBER = RDFBasePackage.RDFS_RESOURCE__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__NODE_ID = RDFBasePackage.RDFS_RESOURCE__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__RDF_SCOMMENT = RDFBasePackage.RDFS_RESOURCE__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__RDF_SLABEL = RDFBasePackage.RDFS_RESOURCE__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__URI_REF = RDFBasePackage.RDFS_RESOURCE__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__SUBJECT_STATEMENT = RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>OW Lbackward Compatible With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__OW_LBACKWARD_COMPATIBLE_WITH = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>OW Limports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__OW_LIMPORTS = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>OW Lversion Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__OW_LVERSION_INFO = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>OW Lprior Version</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__OW_LPRIOR_VERSION = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>OW Lincompatible With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__OW_LINCOMPATIBLE_WITH = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Owl Graph</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__OWL_GRAPH = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Owl Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__OWL_STATEMENT = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Owl Universe</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY__OWL_UNIVERSE = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the the '<em>OWL Ontology</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_FEATURE_COUNT = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.impl.OWLGraphImpl <em>OWL Graph</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.impl.OWLGraphImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getOWLGraph()
	 * @generated
	 */
	int OWL_GRAPH = 1;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH__RDF_SIS_DEFINED_BY = RDFBasePackage.RDF_GRAPH__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH__RDF_SSEE_ALSO = RDFBasePackage.RDF_GRAPH__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH__RD_FTYPE = RDFBasePackage.RDF_GRAPH__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH__RDF_SMEMBER = RDFBasePackage.RDF_GRAPH__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH__NODE_ID = RDFBasePackage.RDF_GRAPH__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH__RDF_SCOMMENT = RDFBasePackage.RDF_GRAPH__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH__RDF_SLABEL = RDFBasePackage.RDF_GRAPH__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH__URI_REF = RDFBasePackage.RDF_GRAPH__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH__SUBJECT_STATEMENT = RDFBasePackage.RDF_GRAPH__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Graphstatement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH__GRAPHSTATEMENT = RDFBasePackage.RDF_GRAPH__GRAPHSTATEMENT;

	/**
	 * The feature id for the '<em><b>Graph Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH__GRAPH_NAME = RDFBasePackage.RDF_GRAPH__GRAPH_NAME;

	/**
	 * The feature id for the '<em><b>Graphontology</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH__GRAPHONTOLOGY = RDFBasePackage.RDF_GRAPH_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Owl Graph Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH__OWL_GRAPH_STATEMENT = RDFBasePackage.RDF_GRAPH_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>OWL Graph</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_GRAPH_FEATURE_COUNT = RDFBasePackage.RDF_GRAPH_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.StatementImpl <em>Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.StatementImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getStatement()
	 * @generated
	 */
	int STATEMENT = 2;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__RDF_SIS_DEFINED_BY = RDFBasePackage.RDF_STATEMENT__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__RDF_SSEE_ALSO = RDFBasePackage.RDF_STATEMENT__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__RD_FTYPE = RDFBasePackage.RDF_STATEMENT__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__RDF_SMEMBER = RDFBasePackage.RDF_STATEMENT__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__NODE_ID = RDFBasePackage.RDF_STATEMENT__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__RDF_SCOMMENT = RDFBasePackage.RDF_STATEMENT__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__RDF_SLABEL = RDFBasePackage.RDF_STATEMENT__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__URI_REF = RDFBasePackage.RDF_STATEMENT__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__SUBJECT_STATEMENT = RDFBasePackage.RDF_STATEMENT__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Document</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__DOCUMENT = RDFBasePackage.RDF_STATEMENT__DOCUMENT;

	/**
	 * The feature id for the '<em><b>Is Reified Only</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__IS_REIFIED_ONLY = RDFBasePackage.RDF_STATEMENT__IS_REIFIED_ONLY;

	/**
	 * The feature id for the '<em><b>Is Reified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__IS_REIFIED = RDFBasePackage.RDF_STATEMENT__IS_REIFIED;

	/**
	 * The feature id for the '<em><b>RD Fsubject</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__RD_FSUBJECT = RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT;

	/**
	 * The feature id for the '<em><b>RD Fobject</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__RD_FOBJECT = RDFBasePackage.RDF_STATEMENT__RD_FOBJECT;

	/**
	 * The feature id for the '<em><b>RD Fpredicate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__RD_FPREDICATE = RDFBasePackage.RDF_STATEMENT__RD_FPREDICATE;

	/**
	 * The feature id for the '<em><b>Name For Reification</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__NAME_FOR_REIFICATION = RDFBasePackage.RDF_STATEMENT__NAME_FOR_REIFICATION;

	/**
	 * The number of structural features of the the '<em>Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT_FEATURE_COUNT = RDFBasePackage.RDF_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.UniverseImpl <em>Universe</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.UniverseImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getUniverse()
	 * @generated
	 */
	int UNIVERSE = 3;

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIVERSE__ONTOLOGY = 0;

	/**
	 * The number of structural features of the the '<em>Universe</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIVERSE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.OWLOntologyPropertyImpl <em>OWL Ontology Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.OWLOntologyPropertyImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getOWLOntologyProperty()
	 * @generated
	 */
	int OWL_ONTOLOGY_PROPERTY = 4;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__RDF_SIS_DEFINED_BY = RDFBasePackage.RDF_PROPERTY__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__RDF_SSEE_ALSO = RDFBasePackage.RDF_PROPERTY__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__RD_FTYPE = RDFBasePackage.RDF_PROPERTY__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__RDF_SMEMBER = RDFBasePackage.RDF_PROPERTY__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__NODE_ID = RDFBasePackage.RDF_PROPERTY__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__RDF_SCOMMENT = RDFBasePackage.RDF_PROPERTY__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__RDF_SLABEL = RDFBasePackage.RDF_PROPERTY__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__URI_REF = RDFBasePackage.RDF_PROPERTY__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__SUBJECT_STATEMENT = RDFBasePackage.RDF_PROPERTY__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Sdomain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__RDF_SDOMAIN = RDFBasePackage.RDF_PROPERTY__RDF_SDOMAIN;

	/**
	 * The feature id for the '<em><b>RDF Srange</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__RDF_SRANGE = RDFBasePackage.RDF_PROPERTY__RDF_SRANGE;

	/**
	 * The feature id for the '<em><b>RDF Ssub Property Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__RDF_SSUB_PROPERTY_OF = RDFBasePackage.RDF_PROPERTY__RDF_SSUB_PROPERTY_OF;

	/**
	 * The feature id for the '<em><b>Sub Property</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__SUB_PROPERTY = RDFBasePackage.RDF_PROPERTY__SUB_PROPERTY;

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY__ONTOLOGY = RDFBasePackage.RDF_PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>OWL Ontology Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ONTOLOGY_PROPERTY_FEATURE_COUNT = RDFBasePackage.RDF_PROPERTY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.OWLClassImpl <em>OWL Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLClassImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getOWLClass()
	 * @generated
	 */
	int OWL_CLASS = 5;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__RDF_SIS_DEFINED_BY = RDFSPackage.RDFS_CLASS__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__RDF_SSEE_ALSO = RDFSPackage.RDFS_CLASS__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__RD_FTYPE = RDFSPackage.RDFS_CLASS__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__RDF_SMEMBER = RDFSPackage.RDFS_CLASS__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__NODE_ID = RDFSPackage.RDFS_CLASS__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__RDF_SCOMMENT = RDFSPackage.RDFS_CLASS__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__RDF_SLABEL = RDFSPackage.RDFS_CLASS__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__URI_REF = RDFSPackage.RDFS_CLASS__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__SUBJECT_STATEMENT = RDFSPackage.RDFS_CLASS__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__RDF_SSUB_CLASS_OF = RDFSPackage.RDFS_CLASS__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__SUB_CLASS = RDFSPackage.RDFS_CLASS__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__PROPERTY_FOR_DOMAIN = RDFSPackage.RDFS_CLASS__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__PROPERTY_FOR_RANGE = RDFSPackage.RDFS_CLASS__PROPERTY_FOR_RANGE;
	
	int OWL_CLASS__TYPED_RESOURCE = RDFSPackage.RDFS_CLASS__TYPED_RESOURCE ;

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__ONTOLOGY = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__IS_DEPRECATED = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__IS_CLASS_KIND = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__HAS_RESTRICTION_KIND = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__OWL_EQUIVALENT_CLASS = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>OWL disjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS__OW_LDISJOINT_WITH = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>complement class</b></em>' reference list.
	 * It is the reverse of {@link org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#COMPLEMENT_CLASS__OW_LCOMPLEMENT_OF}.
	 * 
	 * @eodmext This is not part of the ODM 2006-04-03 specification. It is added for convenient access. 
	 */
	int OWL_CLASS__COMPLEMENT_CLASS = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 6 ;
	
	/**
	 * The feature id for the '<em><b>Intersection class</b></em>' reference list.
	 * It is the reverse of {@link org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#INTERSECTION_CLASS__OW_LINTERSECTION_OF}.
	 * 
	 * @eodmext This is not part of the ODM 2006-04-03 specification. It is added for convenient access. 
	 */
	int OWL_CLASS__INTERSECTION_CLASS = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 7 ;

	/**
	 * The feature id for the '<em><b>Union class</b></em>' reference list.
	 * It is the reverse of {@link org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#UNION_CLASS__OW_LUNION_OF}.
	 * 
	 * @eodmext This is not part of the ODM 2006-04-03 specification. It is added for convenient access. 
	 */
	int OWL_CLASS__UNION_CLASS = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 8 ;
	
	/**
	 * The feature id for the '<em><b>Disjoint class</b></em>' reference list.
	 * It is the reverse of {@link org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#OWL_CLASS__OW_LDISJOINT_WITH}.
	 * 
	 * @eodmext This is not part of the ODM 2006-04-03 specification. It is added for convenient access. 
	 */
	int OWL_CLASS__DISJOINT_CLASS = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 9 ;
	
	/**
	 * The feature id for the '<em><b>Equivalent class</b></em>' reference list.
	 * It is the reverse of {@link org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#OWL_CLASS__OW_LEQUIVALENT_CLASS}.
	 * 
	 * @eodmext This is not part of the ODM 2006-04-03 specification. It is added for convenient access. 
	 */
	int OWL_CLASS__EQUIVALENT_CLASS = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 10 ;
	
	/**
	 * The number of structural features of the the '<em>OWL Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_CLASS_FEATURE_COUNT = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 11;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.OWLRestrictionImpl <em>OWL Restriction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLRestrictionImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getOWLRestriction()
	 * @generated
	 */
	int OWL_RESTRICTION = 6;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__RDF_SIS_DEFINED_BY = OWL_CLASS__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__RDF_SSEE_ALSO = OWL_CLASS__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__RD_FTYPE = OWL_CLASS__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__RDF_SMEMBER = OWL_CLASS__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__NODE_ID = OWL_CLASS__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__RDF_SCOMMENT = OWL_CLASS__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__RDF_SLABEL = OWL_CLASS__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__URI_REF = OWL_CLASS__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__SUBJECT_STATEMENT = OWL_CLASS__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__RDF_SSUB_CLASS_OF = OWL_CLASS__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__SUB_CLASS = OWL_CLASS__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__PROPERTY_FOR_DOMAIN = OWL_CLASS__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__PROPERTY_FOR_RANGE = OWL_CLASS__PROPERTY_FOR_RANGE;

	/**
 	 * The feature id for the '<em><b>Typed Resource</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */	
	int OWL_RESTRICTION__TYPED_RESOURCE = OWL_CLASS__TYPED_RESOURCE ;

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__ONTOLOGY = OWL_CLASS__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__IS_DEPRECATED = OWL_CLASS__IS_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__IS_CLASS_KIND = OWL_CLASS__IS_CLASS_KIND;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__HAS_RESTRICTION_KIND = OWL_CLASS__HAS_RESTRICTION_KIND;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__EQUIVALENT_CLASS = OWL_CLASS__OWL_EQUIVALENT_CLASS ;

	/**
	 * The feature id for the '<em><b>OW Ldisjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__OW_LDISJOINT_WITH = OWL_CLASS__OW_LDISJOINT_WITH;

	/**
	 * The feature id for the '<em><b>OW Lon Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION__OW_LON_PROPERTY = OWL_CLASS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>OWL Restriction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_RESTRICTION_FEATURE_COUNT = OWL_CLASS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.PropertyImpl <em>Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.PropertyImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getProperty()
	 * @generated
	 */
	int PROPERTY = 8;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__RDF_SIS_DEFINED_BY = RDFBasePackage.RDF_PROPERTY__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__RDF_SSEE_ALSO = RDFBasePackage.RDF_PROPERTY__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__RD_FTYPE = RDFBasePackage.RDF_PROPERTY__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__RDF_SMEMBER = RDFBasePackage.RDF_PROPERTY__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__NODE_ID = RDFBasePackage.RDF_PROPERTY__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__RDF_SCOMMENT = RDFBasePackage.RDF_PROPERTY__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__RDF_SLABEL = RDFBasePackage.RDF_PROPERTY__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__URI_REF = RDFBasePackage.RDF_PROPERTY__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__SUBJECT_STATEMENT = RDFBasePackage.RDF_PROPERTY__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Sdomain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__RDF_SDOMAIN = RDFBasePackage.RDF_PROPERTY__RDF_SDOMAIN;

	/**
	 * The feature id for the '<em><b>RDF Srange</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__RDF_SRANGE = RDFBasePackage.RDF_PROPERTY__RDF_SRANGE;

	/**
	 * The feature id for the '<em><b>RDF Ssub Property Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__RDF_SSUB_PROPERTY_OF = RDFBasePackage.RDF_PROPERTY__RDF_SSUB_PROPERTY_OF;

	/**
	 * The feature id for the '<em><b>Sub Property</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__SUB_PROPERTY = RDFBasePackage.RDF_PROPERTY__SUB_PROPERTY;

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__ONTOLOGY = RDFBasePackage.RDF_PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Property Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__IS_PROPERTY_DEPRECATED = RDFBasePackage.RDF_PROPERTY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Functional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__IS_FUNCTIONAL = RDFBasePackage.RDF_PROPERTY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Is Object Property</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__IS_OBJECT_PROPERTY = RDFBasePackage.RDF_PROPERTY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Is Datatype Property</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__IS_DATATYPE_PROPERTY = RDFBasePackage.RDF_PROPERTY_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>OW Lequivalent Property</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__OW_LEQUIVALENT_PROPERTY = RDFBasePackage.RDF_PROPERTY_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the the '<em>Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_FEATURE_COUNT = RDFBasePackage.RDF_PROPERTY_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.OWLObjectPropertyImpl <em>OWL Object Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLObjectPropertyImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getOWLObjectProperty()
	 * @generated
	 */
	int OWL_OBJECT_PROPERTY = 7;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__RDF_SIS_DEFINED_BY = PROPERTY__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__RDF_SSEE_ALSO = PROPERTY__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__RD_FTYPE = PROPERTY__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__RDF_SMEMBER = PROPERTY__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__NODE_ID = PROPERTY__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__RDF_SCOMMENT = PROPERTY__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__RDF_SLABEL = PROPERTY__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__URI_REF = PROPERTY__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__SUBJECT_STATEMENT = PROPERTY__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Sdomain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__RDF_SDOMAIN = PROPERTY__RDF_SDOMAIN;

	/**
	 * The feature id for the '<em><b>RDF Srange</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__RDF_SRANGE = PROPERTY__RDF_SRANGE;

	/**
	 * The feature id for the '<em><b>RDF Ssub Property Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__RDF_SSUB_PROPERTY_OF = PROPERTY__RDF_SSUB_PROPERTY_OF;

	/**
	 * The feature id for the '<em><b>Sub Property</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__SUB_PROPERTY = PROPERTY__SUB_PROPERTY;

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__ONTOLOGY = PROPERTY__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Property Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__IS_PROPERTY_DEPRECATED = PROPERTY__IS_PROPERTY_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Functional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__IS_FUNCTIONAL = PROPERTY__IS_FUNCTIONAL;

	/**
	 * The feature id for the '<em><b>Is Object Property</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__IS_OBJECT_PROPERTY = PROPERTY__IS_OBJECT_PROPERTY;

	/**
	 * The feature id for the '<em><b>Is Datatype Property</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__IS_DATATYPE_PROPERTY = PROPERTY__IS_DATATYPE_PROPERTY;

	/**
	 * The feature id for the '<em><b>OW Lequivalent Property</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__OW_LEQUIVALENT_PROPERTY = PROPERTY__OW_LEQUIVALENT_PROPERTY;

	/**
	 * The feature id for the '<em><b>Is Inverse Functional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__IS_INVERSE_FUNCTIONAL = PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Symmetric</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__IS_SYMMETRIC = PROPERTY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Transitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__IS_TRANSITIVE = PROPERTY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>OW Linverse Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY__OW_LINVERSE_OF = PROPERTY_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the the '<em>OWL Object Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_OBJECT_PROPERTY_FEATURE_COUNT = PROPERTY_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.OWLDatatypePropertyImpl <em>OWL Datatype Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.OWLDatatypePropertyImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getOWLDatatypeProperty()
	 * @generated
	 */
	int OWL_DATATYPE_PROPERTY = 9;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__RDF_SIS_DEFINED_BY = PROPERTY__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__RDF_SSEE_ALSO = PROPERTY__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__RD_FTYPE = PROPERTY__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__RDF_SMEMBER = PROPERTY__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__NODE_ID = PROPERTY__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__RDF_SCOMMENT = PROPERTY__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__RDF_SLABEL = PROPERTY__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__URI_REF = PROPERTY__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__SUBJECT_STATEMENT = PROPERTY__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Sdomain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__RDF_SDOMAIN = PROPERTY__RDF_SDOMAIN;

	/**
	 * The feature id for the '<em><b>RDF Srange</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__RDF_SRANGE = PROPERTY__RDF_SRANGE;

	/**
	 * The feature id for the '<em><b>RDF Ssub Property Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__RDF_SSUB_PROPERTY_OF = PROPERTY__RDF_SSUB_PROPERTY_OF;

	/**
	 * The feature id for the '<em><b>Sub Property</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__SUB_PROPERTY = PROPERTY__SUB_PROPERTY;

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__ONTOLOGY = PROPERTY__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Property Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__IS_PROPERTY_DEPRECATED = PROPERTY__IS_PROPERTY_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Functional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__IS_FUNCTIONAL = PROPERTY__IS_FUNCTIONAL;

	/**
	 * The feature id for the '<em><b>Is Object Property</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__IS_OBJECT_PROPERTY = PROPERTY__IS_OBJECT_PROPERTY;

	/**
	 * The feature id for the '<em><b>Is Datatype Property</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__IS_DATATYPE_PROPERTY = PROPERTY__IS_DATATYPE_PROPERTY;

	/**
	 * The feature id for the '<em><b>OW Lequivalent Property</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY__OW_LEQUIVALENT_PROPERTY = PROPERTY__OW_LEQUIVALENT_PROPERTY;

	/**
	 * The number of structural features of the the '<em>OWL Datatype Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATATYPE_PROPERTY_FEATURE_COUNT = PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.IndividualImpl <em>Individual</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.IndividualImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getIndividual()
	 * @generated
	 */
	int INDIVIDUAL = 10;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIVIDUAL__RDF_SIS_DEFINED_BY = RDFBasePackage.RDFS_RESOURCE__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIVIDUAL__RDF_SSEE_ALSO = RDFBasePackage.RDFS_RESOURCE__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIVIDUAL__RD_FTYPE = RDFBasePackage.RDFS_RESOURCE__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIVIDUAL__RDF_SMEMBER = RDFBasePackage.RDFS_RESOURCE__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIVIDUAL__NODE_ID = RDFBasePackage.RDFS_RESOURCE__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIVIDUAL__RDF_SCOMMENT = RDFBasePackage.RDFS_RESOURCE__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIVIDUAL__RDF_SLABEL = RDFBasePackage.RDFS_RESOURCE__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIVIDUAL__URI_REF = RDFBasePackage.RDFS_RESOURCE__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIVIDUAL__SUBJECT_STATEMENT = RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIVIDUAL__ONTOLOGY = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>OW Ldifferent From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIVIDUAL__OW_LDIFFERENT_FROM = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>OW Lsame As</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIVIDUAL__OW_LSAME_AS = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the the '<em>Individual</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIVIDUAL_FEATURE_COUNT = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.OWLAllDifferentImpl <em>OWL All Different</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLAllDifferentImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getOWLAllDifferent()
	 * @generated
	 */
	int OWL_ALL_DIFFERENT = 11;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__RDF_SIS_DEFINED_BY = OWL_CLASS__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__RDF_SSEE_ALSO = OWL_CLASS__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__RD_FTYPE = OWL_CLASS__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__RDF_SMEMBER = OWL_CLASS__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__NODE_ID = OWL_CLASS__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__RDF_SCOMMENT = OWL_CLASS__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__RDF_SLABEL = OWL_CLASS__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__URI_REF = OWL_CLASS__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__SUBJECT_STATEMENT = OWL_CLASS__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__RDF_SSUB_CLASS_OF = OWL_CLASS__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__SUB_CLASS = OWL_CLASS__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__PROPERTY_FOR_DOMAIN = OWL_CLASS__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__PROPERTY_FOR_RANGE = OWL_CLASS__PROPERTY_FOR_RANGE;

	/**
 	 * The feature id for the '<em><b>Typed Resource</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */	
	int OWL_ALL_DIFFERENT__TYPED_RESOURCE = OWL_CLASS__TYPED_RESOURCE ;
		
	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__ONTOLOGY = OWL_CLASS__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__IS_DEPRECATED = OWL_CLASS__IS_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__IS_CLASS_KIND = OWL_CLASS__IS_CLASS_KIND;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__HAS_RESTRICTION_KIND = OWL_CLASS__HAS_RESTRICTION_KIND;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__EQUIVALENT_CLASS = OWL_CLASS__OWL_EQUIVALENT_CLASS;

	/**
	 * The feature id for the '<em><b>OW Ldisjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__OW_LDISJOINT_WITH = OWL_CLASS__OW_LDISJOINT_WITH;

	/**
	 * The feature id for the '<em><b>OW Ldistinct Members</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT__OW_LDISTINCT_MEMBERS = OWL_CLASS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>OWL All Different</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ALL_DIFFERENT_FEATURE_COUNT = OWL_CLASS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.OWLDataRangeImpl <em>OWL Data Range</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLDataRangeImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getOWLDataRange()
	 * @generated
	 */
	int OWL_DATA_RANGE = 12;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__RDF_SIS_DEFINED_BY = RDFSPackage.RDFS_CLASS__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__RDF_SSEE_ALSO = RDFSPackage.RDFS_CLASS__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__RD_FTYPE = RDFSPackage.RDFS_CLASS__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__RDF_SMEMBER = RDFSPackage.RDFS_CLASS__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__NODE_ID = RDFSPackage.RDFS_CLASS__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__RDF_SCOMMENT = RDFSPackage.RDFS_CLASS__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__RDF_SLABEL = RDFSPackage.RDFS_CLASS__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__URI_REF = RDFSPackage.RDFS_CLASS__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__SUBJECT_STATEMENT = RDFSPackage.RDFS_CLASS__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__RDF_SSUB_CLASS_OF = RDFSPackage.RDFS_CLASS__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__SUB_CLASS = RDFSPackage.RDFS_CLASS__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__PROPERTY_FOR_DOMAIN = RDFSPackage.RDFS_CLASS__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__PROPERTY_FOR_RANGE = RDFSPackage.RDFS_CLASS__PROPERTY_FOR_RANGE;

	int OWL_DATA_RANGE__TYPED_RESOURCE = RDFSPackage.RDFS_CLASS__TYPED_RESOURCE ;
	
	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__ONTOLOGY = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>OWL Data Rangeone Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__OWL_DATA_RANGEONE_OF = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Datatype</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE__DATATYPE = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the the '<em>OWL Data Range</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_DATA_RANGE_FEATURE_COUNT = RDFSPackage.RDFS_CLASS_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.OWLAnnotationPropertyImpl <em>OWL Annotation Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.OWLAnnotationPropertyImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getOWLAnnotationProperty()
	 * @generated
	 */
	int OWL_ANNOTATION_PROPERTY = 13;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__RDF_SIS_DEFINED_BY = RDFBasePackage.RDF_PROPERTY__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__RDF_SSEE_ALSO = RDFBasePackage.RDF_PROPERTY__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__RD_FTYPE = RDFBasePackage.RDF_PROPERTY__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__RDF_SMEMBER = RDFBasePackage.RDF_PROPERTY__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__NODE_ID = RDFBasePackage.RDF_PROPERTY__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__RDF_SCOMMENT = RDFBasePackage.RDF_PROPERTY__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__RDF_SLABEL = RDFBasePackage.RDF_PROPERTY__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__URI_REF = RDFBasePackage.RDF_PROPERTY__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__SUBJECT_STATEMENT = RDFBasePackage.RDF_PROPERTY__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Sdomain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__RDF_SDOMAIN = RDFBasePackage.RDF_PROPERTY__RDF_SDOMAIN;

	/**
	 * The feature id for the '<em><b>RDF Srange</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__RDF_SRANGE = RDFBasePackage.RDF_PROPERTY__RDF_SRANGE;

	/**
	 * The feature id for the '<em><b>RDF Ssub Property Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__RDF_SSUB_PROPERTY_OF = RDFBasePackage.RDF_PROPERTY__RDF_SSUB_PROPERTY_OF;

	/**
	 * The feature id for the '<em><b>Sub Property</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__SUB_PROPERTY = RDFBasePackage.RDF_PROPERTY__SUB_PROPERTY;

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY__ONTOLOGY = RDFBasePackage.RDF_PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>OWL Annotation Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWL_ANNOTATION_PROPERTY_FEATURE_COUNT = RDFBasePackage.RDF_PROPERTY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.EnumeratedClassImpl <em>Enumerated Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.EnumeratedClassImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getEnumeratedClass()
	 * @generated
	 */
	int ENUMERATED_CLASS = 14;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__RDF_SIS_DEFINED_BY = OWL_CLASS__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__RDF_SSEE_ALSO = OWL_CLASS__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__RD_FTYPE = OWL_CLASS__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__RDF_SMEMBER = OWL_CLASS__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__NODE_ID = OWL_CLASS__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__RDF_SCOMMENT = OWL_CLASS__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__RDF_SLABEL = OWL_CLASS__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__URI_REF = OWL_CLASS__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__SUBJECT_STATEMENT = OWL_CLASS__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__RDF_SSUB_CLASS_OF = OWL_CLASS__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__SUB_CLASS = OWL_CLASS__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__PROPERTY_FOR_DOMAIN = OWL_CLASS__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__PROPERTY_FOR_RANGE = OWL_CLASS__PROPERTY_FOR_RANGE;
	
	int ENUMERATED_CLASS__TYPED_RESOURCE = OWL_CLASS__TYPED_RESOURCE ;

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__ONTOLOGY = OWL_CLASS__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__IS_DEPRECATED = OWL_CLASS__IS_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__IS_CLASS_KIND = OWL_CLASS__IS_CLASS_KIND;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__HAS_RESTRICTION_KIND = OWL_CLASS__HAS_RESTRICTION_KIND;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__EQUIVALENT_CLASS = OWL_CLASS__OWL_EQUIVALENT_CLASS;

	/**
	 * The feature id for the '<em><b>OW Ldisjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__OW_LDISJOINT_WITH = OWL_CLASS__OW_LDISJOINT_WITH;

	/**
	 * The feature id for the '<em><b>OW Lone Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS__OW_LONE_OF = OWL_CLASS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Enumerated Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATED_CLASS_FEATURE_COUNT = OWL_CLASS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.IntersectionClassImpl <em>Intersection Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.IntersectionClassImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getIntersectionClass()
	 * @generated
	 */
	int INTERSECTION_CLASS = 15;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__RDF_SIS_DEFINED_BY = OWL_CLASS__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__RDF_SSEE_ALSO = OWL_CLASS__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__RD_FTYPE = OWL_CLASS__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__RDF_SMEMBER = OWL_CLASS__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__NODE_ID = OWL_CLASS__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__RDF_SCOMMENT = OWL_CLASS__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__RDF_SLABEL = OWL_CLASS__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__URI_REF = OWL_CLASS__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__SUBJECT_STATEMENT = OWL_CLASS__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__RDF_SSUB_CLASS_OF = OWL_CLASS__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__SUB_CLASS = OWL_CLASS__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__PROPERTY_FOR_DOMAIN = OWL_CLASS__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__PROPERTY_FOR_RANGE = OWL_CLASS__PROPERTY_FOR_RANGE;

	/**
	 * The feature id for the '<em><b>Typed Resource</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */	
	int INTERSECTION_CLASS__TYPED_RESOURCE = OWL_CLASS__TYPED_RESOURCE ;

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__ONTOLOGY = OWL_CLASS__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__IS_DEPRECATED = OWL_CLASS__IS_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__IS_CLASS_KIND = OWL_CLASS__IS_CLASS_KIND;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__HAS_RESTRICTION_KIND = OWL_CLASS__HAS_RESTRICTION_KIND;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__EQUIVALENT_CLASS = OWL_CLASS__OWL_EQUIVALENT_CLASS;

	/**
	 * The feature id for the '<em><b>OW Ldisjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__OW_LDISJOINT_WITH = OWL_CLASS__OW_LDISJOINT_WITH;

	/**
	 * The feature id for the '<em><b>OW Lintersection Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS__OW_LINTERSECTION_OF = OWL_CLASS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Intersection Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERSECTION_CLASS_FEATURE_COUNT = OWL_CLASS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.UnionClassImpl <em>Union Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.UnionClassImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getUnionClass()
	 * @generated
	 */
	int UNION_CLASS = 16;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__RDF_SIS_DEFINED_BY = OWL_CLASS__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__RDF_SSEE_ALSO = OWL_CLASS__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__RD_FTYPE = OWL_CLASS__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__RDF_SMEMBER = OWL_CLASS__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__NODE_ID = OWL_CLASS__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__RDF_SCOMMENT = OWL_CLASS__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__RDF_SLABEL = OWL_CLASS__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__URI_REF = OWL_CLASS__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__SUBJECT_STATEMENT = OWL_CLASS__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__RDF_SSUB_CLASS_OF = OWL_CLASS__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__SUB_CLASS = OWL_CLASS__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__PROPERTY_FOR_DOMAIN = OWL_CLASS__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__PROPERTY_FOR_RANGE = OWL_CLASS__PROPERTY_FOR_RANGE;
	
	/**
	* The feature id for the '<em><b>Typed Resource</b></em>' reference list.
	* <!-- begin-user-doc -->
	* <!-- end-user-doc -->
	*/	
	int UNION_CLASS__TYPED_RESOURCE = OWL_CLASS__TYPED_RESOURCE ;
	

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__ONTOLOGY = OWL_CLASS__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__IS_DEPRECATED = OWL_CLASS__IS_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__IS_CLASS_KIND = OWL_CLASS__IS_CLASS_KIND;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__HAS_RESTRICTION_KIND = OWL_CLASS__HAS_RESTRICTION_KIND;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__EQUIVALENT_CLASS = OWL_CLASS__OWL_EQUIVALENT_CLASS;

	/**
	 * The feature id for the '<em><b>OW Ldisjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__OW_LDISJOINT_WITH = OWL_CLASS__OW_LDISJOINT_WITH;

	/**
	 * The feature id for the '<em><b>OW Lunion Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS__OW_LUNION_OF = OWL_CLASS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Union Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNION_CLASS_FEATURE_COUNT = OWL_CLASS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.ComplementClassImpl <em>Complement Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.ComplementClassImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getComplementClass()
	 * @generated
	 */
	int COMPLEMENT_CLASS = 17;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__RDF_SIS_DEFINED_BY = OWL_CLASS__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__RDF_SSEE_ALSO = OWL_CLASS__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__RD_FTYPE = OWL_CLASS__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__RDF_SMEMBER = OWL_CLASS__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__NODE_ID = OWL_CLASS__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__RDF_SCOMMENT = OWL_CLASS__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__RDF_SLABEL = OWL_CLASS__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__URI_REF = OWL_CLASS__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__SUBJECT_STATEMENT = OWL_CLASS__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__RDF_SSUB_CLASS_OF = OWL_CLASS__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__SUB_CLASS = OWL_CLASS__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__PROPERTY_FOR_DOMAIN = OWL_CLASS__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__PROPERTY_FOR_RANGE = OWL_CLASS__PROPERTY_FOR_RANGE;
	
	int COMPLEMENT_CLASS__TYPED_RESOURCE = OWL_CLASS__TYPED_RESOURCE;
	
	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__ONTOLOGY = OWL_CLASS__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__IS_DEPRECATED = OWL_CLASS__IS_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__IS_CLASS_KIND = OWL_CLASS__IS_CLASS_KIND;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__HAS_RESTRICTION_KIND = OWL_CLASS__HAS_RESTRICTION_KIND;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__EQUIVALENT_CLASS = OWL_CLASS__OWL_EQUIVALENT_CLASS;

	/**
	 * The feature id for the '<em><b>OW Ldisjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__OW_LDISJOINT_WITH = OWL_CLASS__OW_LDISJOINT_WITH;
	
	/**
	 * The feature id for the '<em><b>OW Lcomplement Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS__OW_LCOMPLEMENT_OF = OWL_CLASS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Complement Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEMENT_CLASS_FEATURE_COUNT = OWL_CLASS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.HasValueRestrictionImpl <em>Has Value Restriction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.HasValueRestrictionImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getHasValueRestriction()
	 * @generated
	 */
	int HAS_VALUE_RESTRICTION = 18;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__RDF_SIS_DEFINED_BY = OWL_RESTRICTION__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__RDF_SSEE_ALSO = OWL_RESTRICTION__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__RD_FTYPE = OWL_RESTRICTION__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__RDF_SMEMBER = OWL_RESTRICTION__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__NODE_ID = OWL_RESTRICTION__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__RDF_SCOMMENT = OWL_RESTRICTION__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__RDF_SLABEL = OWL_RESTRICTION__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__URI_REF = OWL_RESTRICTION__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__SUBJECT_STATEMENT = OWL_RESTRICTION__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__RDF_SSUB_CLASS_OF = OWL_RESTRICTION__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__SUB_CLASS = OWL_RESTRICTION__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__PROPERTY_FOR_DOMAIN = OWL_RESTRICTION__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__PROPERTY_FOR_RANGE = OWL_RESTRICTION__PROPERTY_FOR_RANGE;
	
	/**
	* The feature id for the '<em><b>Typed Resource</b></em>' reference list.
	* <!-- begin-user-doc -->
	* <!-- end-user-doc -->
	*/	
	int HAS_VALUE_RESTRICTION__TYPED_RESOURCE = OWL_RESTRICTION__TYPED_RESOURCE ;
	

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__ONTOLOGY = OWL_RESTRICTION__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__IS_DEPRECATED = OWL_RESTRICTION__IS_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__IS_CLASS_KIND = OWL_RESTRICTION__IS_CLASS_KIND;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__HAS_RESTRICTION_KIND = OWL_RESTRICTION__HAS_RESTRICTION_KIND;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__EQUIVALENT_CLASS = OWL_RESTRICTION__EQUIVALENT_CLASS;

	/**
	 * The feature id for the '<em><b>OW Ldisjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__OW_LDISJOINT_WITH = OWL_RESTRICTION__OW_LDISJOINT_WITH;

	/**
	 * The feature id for the '<em><b>OW Lon Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__OW_LON_PROPERTY = OWL_RESTRICTION__OW_LON_PROPERTY;

	/**
	 * The feature id for the '<em><b>Has Individual Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__HAS_INDIVIDUAL_VALUE = OWL_RESTRICTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Has Literal Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION__HAS_LITERAL_VALUE = OWL_RESTRICTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>Has Value Restriction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_VALUE_RESTRICTION_FEATURE_COUNT = OWL_RESTRICTION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.AllValuesFromRestrictionImpl <em>All Values From Restriction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.AllValuesFromRestrictionImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getAllValuesFromRestriction()
	 * @generated
	 */
	int ALL_VALUES_FROM_RESTRICTION = 19;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__RDF_SIS_DEFINED_BY = OWL_RESTRICTION__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__RDF_SSEE_ALSO = OWL_RESTRICTION__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__RD_FTYPE = OWL_RESTRICTION__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__RDF_SMEMBER = OWL_RESTRICTION__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__NODE_ID = OWL_RESTRICTION__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__RDF_SCOMMENT = OWL_RESTRICTION__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__RDF_SLABEL = OWL_RESTRICTION__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__URI_REF = OWL_RESTRICTION__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__SUBJECT_STATEMENT = OWL_RESTRICTION__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__RDF_SSUB_CLASS_OF = OWL_RESTRICTION__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__SUB_CLASS = OWL_RESTRICTION__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__PROPERTY_FOR_DOMAIN = OWL_RESTRICTION__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__PROPERTY_FOR_RANGE = OWL_RESTRICTION__PROPERTY_FOR_RANGE;

	/**
	 * The feature id for the '<em><b>Typed Resource</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */	
	int ALL_VALUES_FROM_RESTRICTION__TYPED_RESOURCE = OWL_RESTRICTION__TYPED_RESOURCE ;	

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__ONTOLOGY = OWL_RESTRICTION__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__IS_DEPRECATED = OWL_RESTRICTION__IS_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__IS_CLASS_KIND = OWL_RESTRICTION__IS_CLASS_KIND;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__HAS_RESTRICTION_KIND = OWL_RESTRICTION__HAS_RESTRICTION_KIND;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__EQUIVALENT_CLASS = OWL_RESTRICTION__EQUIVALENT_CLASS;

	/**
	 * The feature id for the '<em><b>OW Ldisjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__OW_LDISJOINT_WITH = OWL_RESTRICTION__OW_LDISJOINT_WITH;

	/**
	 * The feature id for the '<em><b>OW Lon Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__OW_LON_PROPERTY = OWL_RESTRICTION__OW_LON_PROPERTY;

	/**
	 * The feature id for the '<em><b>All Values From Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__ALL_VALUES_FROM_CLASS = OWL_RESTRICTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>All Values From Data Range</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION__ALL_VALUES_FROM_DATA_RANGE = OWL_RESTRICTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>All Values From Restriction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALL_VALUES_FROM_RESTRICTION_FEATURE_COUNT = OWL_RESTRICTION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.SomeValuesFromRestrictionImpl <em>Some Values From Restriction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.SomeValuesFromRestrictionImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getSomeValuesFromRestriction()
	 * @generated
	 */
	int SOME_VALUES_FROM_RESTRICTION = 20;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__RDF_SIS_DEFINED_BY = OWL_RESTRICTION__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__RDF_SSEE_ALSO = OWL_RESTRICTION__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__RD_FTYPE = OWL_RESTRICTION__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__RDF_SMEMBER = OWL_RESTRICTION__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__NODE_ID = OWL_RESTRICTION__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__RDF_SCOMMENT = OWL_RESTRICTION__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__RDF_SLABEL = OWL_RESTRICTION__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__URI_REF = OWL_RESTRICTION__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__SUBJECT_STATEMENT = OWL_RESTRICTION__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__RDF_SSUB_CLASS_OF = OWL_RESTRICTION__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__SUB_CLASS = OWL_RESTRICTION__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__PROPERTY_FOR_DOMAIN = OWL_RESTRICTION__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__PROPERTY_FOR_RANGE = OWL_RESTRICTION__PROPERTY_FOR_RANGE;
	
	/**
	* The feature id for the '<em><b>Typed Resource</b></em>' reference list.
	* <!-- begin-user-doc -->
	* <!-- end-user-doc -->
	*/	
	int SOME_VALUES_FROM_RESTRICTION__TYPED_RESOURCE = OWL_RESTRICTION__TYPED_RESOURCE ;
	

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__ONTOLOGY = OWL_RESTRICTION__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__IS_DEPRECATED = OWL_RESTRICTION__IS_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__IS_CLASS_KIND = OWL_RESTRICTION__IS_CLASS_KIND;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__HAS_RESTRICTION_KIND = OWL_RESTRICTION__HAS_RESTRICTION_KIND;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__EQUIVALENT_CLASS = OWL_RESTRICTION__EQUIVALENT_CLASS;

	/**
	 * The feature id for the '<em><b>OW Ldisjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__OW_LDISJOINT_WITH = OWL_RESTRICTION__OW_LDISJOINT_WITH;

	/**
	 * The feature id for the '<em><b>OW Lon Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__OW_LON_PROPERTY = OWL_RESTRICTION__OW_LON_PROPERTY;

	/**
	 * The feature id for the '<em><b>Some Values From Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__SOME_VALUES_FROM_CLASS = OWL_RESTRICTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Some Values From Data Range</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION__SOME_VALUES_FROM_DATA_RANGE = OWL_RESTRICTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>Some Values From Restriction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOME_VALUES_FROM_RESTRICTION_FEATURE_COUNT = OWL_RESTRICTION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.CardinalityRestrictionImpl <em>Cardinality Restriction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.CardinalityRestrictionImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getCardinalityRestriction()
	 * @generated
	 */
	int CARDINALITY_RESTRICTION = 21;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__RDF_SIS_DEFINED_BY = OWL_RESTRICTION__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__RDF_SSEE_ALSO = OWL_RESTRICTION__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__RD_FTYPE = OWL_RESTRICTION__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__RDF_SMEMBER = OWL_RESTRICTION__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__NODE_ID = OWL_RESTRICTION__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__RDF_SCOMMENT = OWL_RESTRICTION__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__RDF_SLABEL = OWL_RESTRICTION__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__URI_REF = OWL_RESTRICTION__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__SUBJECT_STATEMENT = OWL_RESTRICTION__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__RDF_SSUB_CLASS_OF = OWL_RESTRICTION__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__SUB_CLASS = OWL_RESTRICTION__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__PROPERTY_FOR_DOMAIN = OWL_RESTRICTION__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__PROPERTY_FOR_RANGE = OWL_RESTRICTION__PROPERTY_FOR_RANGE;

	/**
	* The feature id for the '<em><b>Typed Resource</b></em>' reference list.
	* <!-- begin-user-doc -->
	* <!-- end-user-doc -->
	*/	
	int CARDINALITY_RESTRICTION__TYPED_RESOURCE = OWL_RESTRICTION__TYPED_RESOURCE ;
	
	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__ONTOLOGY = OWL_RESTRICTION__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__IS_DEPRECATED = OWL_RESTRICTION__IS_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__IS_CLASS_KIND = OWL_RESTRICTION__IS_CLASS_KIND;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__HAS_RESTRICTION_KIND = OWL_RESTRICTION__HAS_RESTRICTION_KIND;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__EQUIVALENT_CLASS = OWL_RESTRICTION__EQUIVALENT_CLASS;

	/**
	 * The feature id for the '<em><b>OW Ldisjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__OW_LDISJOINT_WITH = OWL_RESTRICTION__OW_LDISJOINT_WITH;

	/**
	 * The feature id for the '<em><b>OW Lon Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__OW_LON_PROPERTY = OWL_RESTRICTION__OW_LON_PROPERTY;

	/**
	 * The feature id for the '<em><b>OW Lcardinality</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION__OW_LCARDINALITY = OWL_RESTRICTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Cardinality Restriction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARDINALITY_RESTRICTION_FEATURE_COUNT = OWL_RESTRICTION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.MaxCardinalityRestrictionImpl <em>Max Cardinality Restriction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.MaxCardinalityRestrictionImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getMaxCardinalityRestriction()
	 * @generated
	 */
	int MAX_CARDINALITY_RESTRICTION = 22;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__RDF_SIS_DEFINED_BY = OWL_RESTRICTION__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__RDF_SSEE_ALSO = OWL_RESTRICTION__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__RD_FTYPE = OWL_RESTRICTION__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__RDF_SMEMBER = OWL_RESTRICTION__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__NODE_ID = OWL_RESTRICTION__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__RDF_SCOMMENT = OWL_RESTRICTION__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__RDF_SLABEL = OWL_RESTRICTION__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__URI_REF = OWL_RESTRICTION__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__SUBJECT_STATEMENT = OWL_RESTRICTION__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__RDF_SSUB_CLASS_OF = OWL_RESTRICTION__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__SUB_CLASS = OWL_RESTRICTION__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__PROPERTY_FOR_DOMAIN = OWL_RESTRICTION__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__PROPERTY_FOR_RANGE = OWL_RESTRICTION__PROPERTY_FOR_RANGE;
	
	/**
	* The feature id for the '<em><b>Typed Resource</b></em>' reference list.
	* <!-- begin-user-doc -->
	* <!-- end-user-doc -->
	*/	
	int MAX_CARDINALITY_RESTRICTION__TYPED_RESOURCE = OWL_RESTRICTION__TYPED_RESOURCE ;
	

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__ONTOLOGY = OWL_RESTRICTION__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__IS_DEPRECATED = OWL_RESTRICTION__IS_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__IS_CLASS_KIND = OWL_RESTRICTION__IS_CLASS_KIND;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__HAS_RESTRICTION_KIND = OWL_RESTRICTION__HAS_RESTRICTION_KIND;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__EQUIVALENT_CLASS = OWL_RESTRICTION__EQUIVALENT_CLASS;

	/**
	 * The feature id for the '<em><b>OW Ldisjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__OW_LDISJOINT_WITH = OWL_RESTRICTION__OW_LDISJOINT_WITH;

	/**
	 * The feature id for the '<em><b>OW Lon Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__OW_LON_PROPERTY = OWL_RESTRICTION__OW_LON_PROPERTY;

	/**
	 * The feature id for the '<em><b>OW Lmax Cardinality</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION__OW_LMAX_CARDINALITY = OWL_RESTRICTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Max Cardinality Restriction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_CARDINALITY_RESTRICTION_FEATURE_COUNT = OWL_RESTRICTION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.owl.owlbase.impl.MinCardinalityRestrictionImpl <em>Min Cardinality Restriction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.owl.owlbase.impl.MinCardinalityRestrictionImpl
	 * @see org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl#getMinCardinalityRestriction()
	 * @generated
	 */
	int MIN_CARDINALITY_RESTRICTION = 23;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__RDF_SIS_DEFINED_BY = OWL_RESTRICTION__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__RDF_SSEE_ALSO = OWL_RESTRICTION__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__RD_FTYPE = OWL_RESTRICTION__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__RDF_SMEMBER = OWL_RESTRICTION__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__NODE_ID = OWL_RESTRICTION__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__RDF_SCOMMENT = OWL_RESTRICTION__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__RDF_SLABEL = OWL_RESTRICTION__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__URI_REF = OWL_RESTRICTION__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__SUBJECT_STATEMENT = OWL_RESTRICTION__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__RDF_SSUB_CLASS_OF = OWL_RESTRICTION__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__SUB_CLASS = OWL_RESTRICTION__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__PROPERTY_FOR_DOMAIN = OWL_RESTRICTION__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__PROPERTY_FOR_RANGE = OWL_RESTRICTION__PROPERTY_FOR_RANGE;
	
	/**
	* The feature id for the '<em><b>Typed Resource</b></em>' reference list.
	* <!-- begin-user-doc -->
	* <!-- end-user-doc -->
	*/	
	int MIN_CARDINALITY_RESTRICTION__TYPED_RESOURCE = OWL_RESTRICTION__TYPED_RESOURCE ;
	

	/**
	 * The feature id for the '<em><b>Ontology</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__ONTOLOGY = OWL_RESTRICTION__ONTOLOGY;

	/**
	 * The feature id for the '<em><b>Is Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__IS_DEPRECATED = OWL_RESTRICTION__IS_DEPRECATED;

	/**
	 * The feature id for the '<em><b>Is Class Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__IS_CLASS_KIND = OWL_RESTRICTION__IS_CLASS_KIND;

	/**
	 * The feature id for the '<em><b>Has Restriction Kind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__HAS_RESTRICTION_KIND = OWL_RESTRICTION__HAS_RESTRICTION_KIND;

	/**
	 * The feature id for the '<em><b>Equivalent Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__EQUIVALENT_CLASS = OWL_RESTRICTION__EQUIVALENT_CLASS;

	/**
	 * The feature id for the '<em><b>OW Ldisjoint With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__OW_LDISJOINT_WITH = OWL_RESTRICTION__OW_LDISJOINT_WITH;

	/**
	 * The feature id for the '<em><b>OW Lon Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__OW_LON_PROPERTY = OWL_RESTRICTION__OW_LON_PROPERTY;

	/**
	 * The feature id for the '<em><b>OW Lmin Cardinality</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION__OW_LMIN_CARDINALITY = OWL_RESTRICTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Min Cardinality Restriction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_CARDINALITY_RESTRICTION_FEATURE_COUNT = OWL_RESTRICTION_FEATURE_COUNT + 1;


	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.OWLOntology <em>OWL Ontology</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>OWL Ontology</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntology
	 * @generated
	 */
	EClass getOWLOntology();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLbackwardCompatibleWith <em>OW Lbackward Compatible With</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>OW Lbackward Compatible With</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLbackwardCompatibleWith()
	 * @see #getOWLOntology()
	 * @generated
	 */
	EReference getOWLOntology_OWLbackwardCompatibleWith();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLimports <em>OW Limports</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>OW Limports</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLimports()
	 * @see #getOWLOntology()
	 * @generated
	 */
	EReference getOWLOntology_OWLimports();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLversionInfo <em>OW Lversion Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>OW Lversion Info</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLversionInfo()
	 * @see #getOWLOntology()
	 * @generated
	 */
	EReference getOWLOntology_OWLversionInfo();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLpriorVersion <em>OW Lprior Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>OW Lprior Version</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLpriorVersion()
	 * @see #getOWLOntology()
	 * @generated
	 */
	EReference getOWLOntology_OWLpriorVersion();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLincompatibleWith <em>OW Lincompatible With</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>OW Lincompatible With</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLincompatibleWith()
	 * @see #getOWLOntology()
	 * @generated
	 */
	EReference getOWLOntology_OWLincompatibleWith();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlGraph <em>Owl Graph</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Owl Graph</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlGraph()
	 * @see #getOWLOntology()
	 * @generated
	 */
	EReference getOWLOntology_OwlGraph();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlStatement <em>Owl Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Owl Statement</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlStatement()
	 * @see #getOWLOntology()
	 * @generated
	 */
	EReference getOWLOntology_OwlStatement();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlUniverse <em>Owl Universe</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Owl Universe</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlUniverse()
	 * @see #getOWLOntology()
	 * @generated
	 */
	EReference getOWLOntology_OwlUniverse();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.OWLGraph <em>OWL Graph</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>OWL Graph</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLGraph
	 * @generated
	 */
	EClass getOWLGraph();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.OWLGraph#getGraphontology <em>Graphontology</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Graphontology</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLGraph#getGraphontology()
	 * @see #getOWLGraph()
	 * @generated
	 */
	EReference getOWLGraph_Graphontology();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.OWLGraph#getOwlGraphStatement <em>Owl Graph Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Owl Graph Statement</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLGraph#getOwlGraphStatement()
	 * @see #getOWLGraph()
	 * @generated
	 */
	EReference getOWLGraph_OwlGraphStatement();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.Statement <em>Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Statement</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.Statement
	 * @generated
	 */
	EClass getStatement();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.Universe <em>Universe</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Universe</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.Universe
	 * @generated
	 */
	EClass getUniverse();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.Universe#getOntology <em>Ontology</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Ontology</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.Universe#getOntology()
	 * @see #getUniverse()
	 * @generated
	 */
	EReference getUniverse_Ontology();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.OWLOntologyProperty <em>OWL Ontology Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>OWL Ontology Property</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntologyProperty
	 * @generated
	 */
	EClass getOWLOntologyProperty();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.OWLClass <em>OWL Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>OWL Class</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLClass
	 * @generated
	 */
	EClass getOWLClass();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.owl.owlbase.OWLClass#isIsDeprecated <em>Is Deprecated</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Deprecated</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLClass#isIsDeprecated()
	 * @see #getOWLClass()
	 * @generated
	 */
	EAttribute getOWLClass_IsDeprecated();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.eodm.owl.owlbase.OWLClass#getIsClassKind <em>Is Class Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Is Class Kind</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLClass#getIsClassKind()
	 * @see #getOWLClass()
	 * @generated
	 */
	EReference getOWLClass_IsClassKind();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.eodm.owl.owlbase.OWLClass#getHasRestrictionKind <em>Has Restriction Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Has Restriction Kind</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLClass#getHasRestrictionKind()
	 * @see #getOWLClass()
	 * @generated
	 */
	EReference getOWLClass_HasRestrictionKind();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.OWLClass#getEquivalentClass <em>Equivalent Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Equivalent Class</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLClass#getEquivalentClass()
	 * @see #getOWLClass()
	 * @generated
	 */
	EReference getOWLClass_OWLEquivalentClass();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.OWLClass#getOWLdisjointWith <em>OW Ldisjoint With</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>OW Ldisjoint With</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLClass#getOWLdisjointWith()
	 * @see #getOWLClass()
	 * @generated
	 */
	EReference getOWLClass_OWLdisjointWith();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.OWLRestriction <em>OWL Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>OWL Restriction</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLRestriction
	 * @generated
	 */
	EClass getOWLRestriction();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.OWLRestriction#getOWLonProperty <em>OW Lon Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>OW Lon Property</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLRestriction#getOWLonProperty()
	 * @see #getOWLRestriction()
	 * @generated
	 */
	EReference getOWLRestriction_OWLonProperty();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty <em>OWL Object Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>OWL Object Property</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLObjectProperty
	 * @generated
	 */
	EClass getOWLObjectProperty();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty#isIsInverseFunctional <em>Is Inverse Functional</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Inverse Functional</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLObjectProperty#isIsInverseFunctional()
	 * @see #getOWLObjectProperty()
	 * @generated
	 */
	EAttribute getOWLObjectProperty_IsInverseFunctional();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty#isIsSymmetric <em>Is Symmetric</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Symmetric</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLObjectProperty#isIsSymmetric()
	 * @see #getOWLObjectProperty()
	 * @generated
	 */
	EAttribute getOWLObjectProperty_IsSymmetric();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty#isIsTransitive <em>Is Transitive</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Transitive</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLObjectProperty#isIsTransitive()
	 * @see #getOWLObjectProperty()
	 * @generated
	 */
	EAttribute getOWLObjectProperty_IsTransitive();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty#getOWLinverseOf <em>OW Linverse Of</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>OW Linverse Of</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLObjectProperty#getOWLinverseOf()
	 * @see #getOWLObjectProperty()
	 * @generated
	 */
	EReference getOWLObjectProperty_OWLinverseOf();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.Property <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Property</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.Property
	 * @generated
	 */
	EClass getProperty();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.owl.owlbase.Property#isIsPropertyDeprecated <em>Is Property Deprecated</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Property Deprecated</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.Property#isIsPropertyDeprecated()
	 * @see #getProperty()
	 * @generated
	 */
	EAttribute getProperty_IsPropertyDeprecated();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.owl.owlbase.Property#isIsFunctional <em>Is Functional</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Functional</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.Property#isIsFunctional()
	 * @see #getProperty()
	 * @generated
	 */
	EAttribute getProperty_IsFunctional();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.owl.owlbase.Property#isIsObjectProperty <em>Is Object Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Object Property</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.Property#isIsObjectProperty()
	 * @see #getProperty()
	 * @generated
	 */
	EAttribute getProperty_IsObjectProperty();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.owl.owlbase.Property#isIsDatatypeProperty <em>Is Datatype Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Datatype Property</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.Property#isIsDatatypeProperty()
	 * @see #getProperty()
	 * @generated
	 */
	EAttribute getProperty_IsDatatypeProperty();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.Property#getOWLequivalentProperty <em>OW Lequivalent Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>OW Lequivalent Property</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.Property#getOWLequivalentProperty()
	 * @see #getProperty()
	 * @generated
	 */
	EReference getProperty_OWLequivalentProperty();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty <em>OWL Datatype Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>OWL Datatype Property</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty
	 * @generated
	 */
	EClass getOWLDatatypeProperty();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.Individual <em>Individual</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Individual</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.Individual
	 * @generated
	 */
	EClass getIndividual();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.Individual#getOWLdifferentFrom <em>OW Ldifferent From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>OW Ldifferent From</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.Individual#getOWLdifferentFrom()
	 * @see #getIndividual()
	 * @generated
	 */
	EReference getIndividual_OWLdifferentFrom();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.Individual#getOWLsameAs <em>OW Lsame As</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>OW Lsame As</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.Individual#getOWLsameAs()
	 * @see #getIndividual()
	 * @generated
	 */
	EReference getIndividual_OWLsameAs();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.OWLAllDifferent <em>OWL All Different</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>OWL All Different</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLAllDifferent
	 * @generated
	 */
	EClass getOWLAllDifferent();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.OWLAllDifferent#getOWLdistinctMembers <em>OW Ldistinct Members</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>OW Ldistinct Members</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLAllDifferent#getOWLdistinctMembers()
	 * @see #getOWLAllDifferent()
	 * @generated
	 */
	EReference getOWLAllDifferent_OWLdistinctMembers();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.OWLDataRange <em>OWL Data Range</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>OWL Data Range</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLDataRange
	 * @generated
	 */
	EClass getOWLDataRange();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.OWLDataRange#getOWLDataRangeoneOf <em>OWL Data Rangeone Of</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>OWL Data Rangeone Of</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLDataRange#getOWLDataRangeOneOf()
	 * @see #getOWLDataRange()
	 * @generated
	 */
	EReference getOWLDataRange_OWLDataRangeOneOf();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.OWLDataRange#getDatatype <em>Datatype</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Datatype</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLDataRange#getDatatype()
	 * @see #getOWLDataRange()
	 * @generated
	 */
	EReference getOWLDataRange_Datatype();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.OWLAnnotationProperty <em>OWL Annotation Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>OWL Annotation Property</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.OWLAnnotationProperty
	 * @generated
	 */
	EClass getOWLAnnotationProperty();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.EnumeratedClass <em>Enumerated Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Enumerated Class</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.EnumeratedClass
	 * @generated
	 */
	EClass getEnumeratedClass();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.EnumeratedClass#getOWLoneOf <em>OW Lone Of</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>OW Lone Of</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.EnumeratedClass#getOWLoneOf()
	 * @see #getEnumeratedClass()
	 * @generated
	 */
	EReference getEnumeratedClass_OWLoneOf();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.IntersectionClass <em>Intersection Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Intersection Class</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.IntersectionClass
	 * @generated
	 */
	EClass getIntersectionClass();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.IntersectionClass#getOWLintersectionOf <em>OW Lintersection Of</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>OW Lintersection Of</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.IntersectionClass#getOWLintersectionOf()
	 * @see #getIntersectionClass()
	 * @generated
	 */
	EReference getIntersectionClass_OWLintersectionOf();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.UnionClass <em>Union Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Union Class</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.UnionClass
	 * @generated
	 */
	EClass getUnionClass();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.owl.owlbase.UnionClass#getOWLunionOf <em>OW Lunion Of</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>OW Lunion Of</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.UnionClass#getOWLunionOf()
	 * @see #getUnionClass()
	 * @generated
	 */
	EReference getUnionClass_OWLunionOf();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.ComplementClass <em>Complement Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Complement Class</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.ComplementClass
	 * @generated
	 */
	EClass getComplementClass();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.ComplementClass#getOWLcomplementOf <em>OW Lcomplement Of</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>OW Lcomplement Of</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.ComplementClass#getOWLcomplementOf()
	 * @see #getComplementClass()
	 * @generated
	 */
	EReference getComplementClass_OWLcomplementOf();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.HasValueRestriction <em>Has Value Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Has Value Restriction</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.HasValueRestriction
	 * @generated
	 */
	EClass getHasValueRestriction();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.HasValueRestriction#getHasIndividualValue <em>Has Individual Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Has Individual Value</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.HasValueRestriction#getHasIndividualValue()
	 * @see #getHasValueRestriction()
	 * @generated
	 */
	EReference getHasValueRestriction_HasIndividualValue();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.HasValueRestriction#getHasLiteralValue <em>Has Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Has Literal Value</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.HasValueRestriction#getHasLiteralValue()
	 * @see #getHasValueRestriction()
	 * @generated
	 */
	EReference getHasValueRestriction_HasLiteralValue();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction <em>All Values From Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>All Values From Restriction</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction
	 * @generated
	 */
	EClass getAllValuesFromRestriction();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction#getAllValuesFromClass <em>All Values From Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>All Values From Class</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction#getAllValuesFromClass()
	 * @see #getAllValuesFromRestriction()
	 * @generated
	 */
	EReference getAllValuesFromRestriction_AllValuesFromClass();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction#getAllValuesFromDataRange <em>All Values From Data Range</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>All Values From Data Range</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction#getAllValuesFromDataRange()
	 * @see #getAllValuesFromRestriction()
	 * @generated
	 */
	EReference getAllValuesFromRestriction_AllValuesFromDataRange();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction <em>Some Values From Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Some Values From Restriction</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction
	 * @generated
	 */
	EClass getSomeValuesFromRestriction();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction#getSomeValuesFromClass <em>Some Values From Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Some Values From Class</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction#getSomeValuesFromClass()
	 * @see #getSomeValuesFromRestriction()
	 * @generated
	 */
	EReference getSomeValuesFromRestriction_SomeValuesFromClass();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction#getSomeValuesFromDataRange <em>Some Values From Data Range</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Some Values From Data Range</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction#getSomeValuesFromDataRange()
	 * @see #getSomeValuesFromRestriction()
	 * @generated
	 */
	EReference getSomeValuesFromRestriction_SomeValuesFromDataRange();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.CardinalityRestriction <em>Cardinality Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Cardinality Restriction</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.CardinalityRestriction
	 * @generated
	 */
	EClass getCardinalityRestriction();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.CardinalityRestriction#getOWLcardinality <em>OW Lcardinality</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>OW Lcardinality</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.CardinalityRestriction#getOWLcardinality()
	 * @see #getCardinalityRestriction()
	 * @generated
	 */
	EReference getCardinalityRestriction_OWLcardinality();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction <em>Max Cardinality Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Max Cardinality Restriction</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction
	 * @generated
	 */
	EClass getMaxCardinalityRestriction();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction#getOWLmaxCardinality <em>OW Lmax Cardinality</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>OW Lmax Cardinality</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction#getOWLmaxCardinality()
	 * @see #getMaxCardinalityRestriction()
	 * @generated
	 */
	EReference getMaxCardinalityRestriction_OWLmaxCardinality();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction <em>Min Cardinality Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Min Cardinality Restriction</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction
	 * @generated
	 */
	EClass getMinCardinalityRestriction();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction#getOWLminCardinality <em>OW Lmin Cardinality</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>OW Lmin Cardinality</em>'.
	 * @see org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction#getOWLminCardinality()
	 * @see #getMinCardinalityRestriction()
	 * @generated
	 */
	EReference getMinCardinalityRestriction_OWLminCardinality();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	OWLBaseFactory getowlbaseFactory();

} //OWLBasePackage
