/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: Property.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase;

import org.eclipse.emf.common.util.EList;

import org.eclipse.eodm.rdf.rdfbase.RDFProperty;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Property</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.Property#isIsPropertyDeprecated <em>isPropertyDeprecated</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.Property#isIsFunctional <em>isFunctional</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.Property#isIsObjectProperty <em>isObjectProperty</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.Property#isIsDatatypeProperty <em>isDatatypeProperty</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.Property#getOWLequivalentProperty <em>OWLequivalentProperty</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getProperty()
 * @model abstract="true"
 * @generated
 */
public interface Property extends RDFProperty, Universe {
	/**
	 * Returns the value of the '<em><b>isPropertyDeprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Property Deprecated</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>isPropertyDeprecated</em>' attribute.
	 * @see #setIsPropertyDeprecated(boolean)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getProperty_IsPropertyDeprecated()
	 * @model required="true"
	 * @generated
	 */
	boolean isIsPropertyDeprecated();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.Property#isIsPropertyDeprecated <em>isPropertyDeprecated</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>isPropertyDeprecated</em>' attribute.
	 * @see #isIsPropertyDeprecated()
	 * @generated
	 */
	void setIsPropertyDeprecated(boolean value);

	/**
	 * Returns the value of the '<em><b>isFunctional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Functional</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>isFunctional</em>' attribute.
	 * @see #setIsFunctional(boolean)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getProperty_IsFunctional()
	 * @model required="true"
	 * @generated
	 */
	boolean isIsFunctional();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.Property#isIsFunctional <em>isFunctional</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>isFunctional</em>' attribute.
	 * @see #isIsFunctional()
	 * @generated
	 */
	void setIsFunctional(boolean value);

	/**
	 * Returns the value of the '<em><b>isObjectProperty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Object Property</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>isObjectProperty</em>' attribute.
	 * @see #setIsObjectProperty(boolean)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getProperty_IsObjectProperty()
	 * @model required="true" derived="true"
	 * @generated
	 */
	boolean isIsObjectProperty();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.Property#isIsObjectProperty <em>isObjectProperty</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>isObjectProperty</em>' attribute.
	 * @see #isIsObjectProperty()
	 * @generated
	 */
	void setIsObjectProperty(boolean value);

	/**
	 * Returns the value of the '<em><b>isDatatypeProperty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Datatype Property</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>isDatatypeProperty</em>' attribute.
	 * @see #setIsDatatypeProperty(boolean)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getProperty_IsDatatypeProperty()
	 * @model required="true" derived="true"
	 * @generated
	 */
	boolean isIsDatatypeProperty();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.Property#isIsDatatypeProperty <em>isDatatypeProperty</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>isDatatypeProperty</em>' attribute.
	 * @see #isIsDatatypeProperty()
	 * @generated
	 */
	void setIsDatatypeProperty(boolean value);

	/**
	 * Returns the value of the '<em><b>OWLequivalentProperty</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.Property}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>OW Lequivalent Property</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>OWLequivalentProperty</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getProperty_OWLequivalentProperty()
	 * @model type="org.eclipse.eodm.owl.owlbase.Property"
	 * @generated
	 */
	EList getOWLequivalentProperty();

} // Property
