/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: RDFSURIConstant.java,v 1.2 2007/03/18 08:39:02 lzhang Exp $
 */

package org.eclipse.eodm.rdf.resource.parser.element;

import org.eclipse.eodm.vocabulary.RDF;
import org.eclipse.eodm.vocabulary.RDFS;

/**
 * RDFSURIConstant
 * 
 */
public final class RDFSURIConstant {
    public static final URIReference C_STATEMENT_URI = new URIReference(
            RDF.C_STATEMENT_STR);

    public static final URIReference C_XMLLITERAL_URI = new URIReference(
            RDF.C_XMLLITERAL_STR);

    public static final URIReference P_SUBJECT_URI = new URIReference(
            RDF.P_SUBJECT_STR);

    public static final URIReference P_PREDICATE_URI = new URIReference(
            RDF.P_PREDICATE_STR);

    public static final URIReference P_OBJECT_URI = new URIReference(
            RDF.P_OBJECT_STR);

    public static final URIReference P_TYPE_URI = new URIReference(
            RDF.P_TYPE_STR);

    public static final URIReference P_FIRST_URI = new URIReference(
            RDF.P_FIRST_STR);

    public static final URIReference P_REST_URI = new URIReference(
            RDF.P_REST_STR);

    public static final String NIL = "nil";

    public static final String NIL_STR = RDF.NAMESPACE + NIL;

    public static final URIReference NIL_URI = new URIReference(NIL_STR);

    public static final URIReference P_ABOUTEACH_URI = new URIReference(
            RDF.P_ABOUTEACH_STR);

    public static final URIReference P_ABOUTEACHPREFIX_URI = new URIReference(
            RDF.P_ABOUTEACHPREFIX_STR);

    public static final URIReference P_BAGID_URI = new URIReference(
            RDF.P_BAGID_STR);

    public static final URIReference C_XSDString_URI = new URIReference(
            RDFS.XSD_NAMESPACE, "string");

}
