/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.rdf.transformer;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.eodm.RDFFactory;
import org.eclipse.eodm.rdf.rdfbase.PlainLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFProperty;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfs.RDFBag;
import org.eclipse.eodm.rdf.rdfs.RDFSClass;
import org.eclipse.eodm.rdf.rdfs.RDFSDatatype;
import org.eclipse.eodm.rdf.rdfweb.Document;
import org.eclipse.eodm.rdf.resource.RDFXMLSaver;
import org.eclipse.eodm.rdf.transformer.EODMRDFSTransformerException;

public class Ecore2RDFS {
    private static String XSD_BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    private static String XSD_FLOAT = "http://www.w3.org/2001/XMLSchema#float";
    private static String XSD_BYTE = "http://www.w3.org/2001/XMLSchema#byte";
    private static String XSD_INT = "http://www.w3.org/2001/XMLSchema#int";
    private static String XSD_LONG = "http://www.w3.org/2001/XMLSchema#long";
    private static String XSD_DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    private static String XSD_SHORT = "http://www.w3.org/2001/XMLSchema#short";
    private static String XSD_INTEGER = "http://www.w3.org/2001/XMLSchema#integer";
    private static String XSD_STRING = "http://www.w3.org/2001/XMLSchema#string";
    static /* synthetic */ Class class$0;

    public static RDFGraph ecore2RDF(String ecoreFilePath, Map options) throws EODMRDFSTransformerException {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResource(URI.createFileURI((String)ecoreFilePath), true);
        File inputFile = new File(ecoreFilePath);
        URI absoluteInputURI = URI.createFileURI((String)inputFile.getAbsolutePath());
        Resource resource = resourceSet.getResource(absoluteInputURI, true);
        return Ecore2RDFS.ecore2RDF(resource, options);
    }

    public static void ecore2RDF(String ecoreFilePath, String rdfFilePath, Map options) throws EODMRDFSTransformerException {
        RDFGraph graph = Ecore2RDFS.ecore2RDF(ecoreFilePath, options);
        try {
            Ecore2RDFS.saveRDFGraph(graph, rdfFilePath, null);
        }
        catch (URISyntaxException e1) {
            throw new EODMRDFSTransformerException("Cannot create Documents:" + e1.getMessage());
        }
        catch (IOException e2) {
            throw new EODMRDFSTransformerException("Cannot save RDF Graph:" + e2.getMessage());
        }
    }

    public static RDFGraph ecore2RDF(Resource ecoreResource, Map options) throws EODMRDFSTransformerException {
        if (options == null) {
            options = Collections.EMPTY_MAP;
        }
        EPackage ePackage = (EPackage)ecoreResource.getContents().get(0);
        return Ecore2RDFS.ecore2RDF(ePackage, options);
    }

    public static RDFGraph ecore2RDF(EPackage ePackage, Map options) throws EODMRDFSTransformerException {
        String nsUri = ePackage.getNsURI();
        RDFGraph graph = null;
        try {
            RDFFactory factory = RDFFactory.eINSTANCE;
            graph = factory.createGraph(nsUri);
            List eclassifierLst = Ecore2RDFS.getEclassifier(ePackage);
            HashMap ecore2rdfMap = new HashMap();
            Iterator it = eclassifierLst.iterator();
            while (it.hasNext()) {
                RDFProperty prop;
                String pname;
                EClassifier eclassifier = (EClassifier)it.next();
                RDFSResource rsource = Ecore2RDFS.eclass2RDF(eclassifier, graph, ecore2rdfMap);
                if (!(eclassifier instanceof EClass)) continue;
                RDFSClass rclass = (RDFSClass)rsource;
                EClass eclass = (EClass)eclassifier;
                Iterator itSuper = eclass.getESuperTypes().iterator();
                while (itSuper.hasNext()) {
                    EClassifier eSuper = (EClassifier)itSuper.next();
                    if (eSuper.eIsProxy()) continue;
                    RDFSClass parents = (RDFSClass)Ecore2RDFS.eclass2RDF(eSuper, graph, ecore2rdfMap);
                    parents.getSubClass().add((Object)rclass);
                }
                Iterator itAtt = eclass.getEAttributes().iterator();
                while (itAtt.hasNext()) {
                    EAttribute eatt = (EAttribute)itAtt.next();
                    pname = eatt.getName();
                    prop = factory.createRDFProperty(graph, pname);
                    prop.getRDFScomment().addAll((Collection)Ecore2RDFS.eAnnotation2Literal((ENamedElement)eatt));
                    prop.getRDFSlabel().add((Object)factory.createPlainLiteral("EAttribute-" + pname));
                    prop.getRDFSdomain().add((Object)rclass);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.emf.ecore.EEnum");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz.isInstance(eatt.getEType())) {
                        RDFSDatatype type;
                        String xsdName = null;
                        if (eatt.getEType() == EcorePackage.eINSTANCE.getEBoolean()) {
                            xsdName = XSD_BOOLEAN;
                        } else if (eatt.getEType() == EcorePackage.eINSTANCE.getEFloat()) {
                            xsdName = XSD_FLOAT;
                        } else if (eatt.getEType() == EcorePackage.eINSTANCE.getEByte()) {
                            xsdName = XSD_BYTE;
                        } else if (eatt.getEType() == EcorePackage.eINSTANCE.getEInt()) {
                            xsdName = XSD_INT;
                        } else if (eatt.getEType() == EcorePackage.eINSTANCE.getELong()) {
                            xsdName = XSD_LONG;
                        } else if (eatt.getEType() == EcorePackage.eINSTANCE.getEDouble()) {
                            xsdName = XSD_DOUBLE;
                        } else if (eatt.getEType() == EcorePackage.eINSTANCE.getEShort()) {
                            xsdName = XSD_SHORT;
                        } else if (eatt.getEType() == EcorePackage.eINSTANCE.getEIntegerObject()) {
                            xsdName = XSD_INTEGER;
                        } else if (eatt.getEType() == EcorePackage.eINSTANCE.getEString()) {
                            xsdName = XSD_STRING;
                        }
                        if (xsdName != null) {
                            type = factory.createRDFSDatatype(graph, xsdName);
                            prop.getRDFSrange().add((Object)type);
                            continue;
                        }
                        type = factory.createRDFSDatatype(graph, eatt.getEType().getName());
                        prop.getRDFSrange().add((Object)type);
                        continue;
                    }
                    RDFBag bag = (RDFBag)Ecore2RDFS.eclass2RDF(eatt.getEType(), graph, ecore2rdfMap);
                    if (bag == null) continue;
                    RDFSDatatype dummy = factory.createRDFSDatatype(graph, (URIReference)bag.getUriRef().get(0));
                    dummy.getRDFSisDefinedBy().add((Object)bag);
                    prop.getRDFSrange().add((Object)dummy);
                }
                Iterator itRef = eclass.getEReferences().iterator();
                while (itRef.hasNext()) {
                    EReference eref = (EReference)itRef.next();
                    pname = eref.getName();
                    prop = factory.createRDFProperty(graph, pname);
                    prop.getRDFScomment().addAll((Collection)Ecore2RDFS.eAnnotation2Literal((ENamedElement)eref));
                    prop.getRDFSlabel().add((Object)factory.createPlainLiteral("EReference-" + pname));
                    prop.getRDFSdomain().add((Object)rclass);
                    RDFSClass range = factory.createRDFSClass(graph, eref.getEReferenceType().getName());
                    prop.getRDFSrange().add((Object)range);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new EODMRDFSTransformerException("Something wrong when creating RDF Resource:" + e.getMessage());
        }
        return graph;
    }

    private static List eAnnotation2Literal(ENamedElement eNameElem) {
        ArrayList<PlainLiteral> alist = new ArrayList<PlainLiteral>();
        Iterator itAn = eNameElem.getEAnnotations().iterator();
        while (itAn.hasNext()) {
            EAnnotation an = (EAnnotation)itAn.next();
            if (an == null) continue;
            PlainLiteral literal = RDFFactory.eINSTANCE.createPlainLiteral(Ecore2RDFS.eAnnotation2String(an));
            alist.add(literal);
        }
        return alist;
    }

    private static RDFSResource eclass2RDF(EClassifier eclassifier, RDFGraph graph, Map ecore2rdfMap) throws EODMRDFSTransformerException {
        RDFSResource rsource = (RDFSResource)ecore2rdfMap.get(eclassifier);
        if (rsource == null) {
            try {
                RDFFactory factory = RDFFactory.eINSTANCE;
                String name = eclassifier.getName();
                if (eclassifier instanceof EClass) {
                    RDFSClass rclass = factory.createRDFSClass(graph, name);
                    rclass.getRDFScomment().addAll((Collection)Ecore2RDFS.eAnnotation2Literal((ENamedElement)eclassifier));
                    rclass.getRDFSlabel().add((Object)factory.createPlainLiteral("EClass-" + name));
                    rsource = rclass;
                } else if (eclassifier instanceof EEnum) {
                    RDFBag rbag = name == null ? factory.createRDFBag(graph, "EEnum") : factory.createRDFBag(graph, name);
                    rbag.getRDFScomment().addAll((Collection)Ecore2RDFS.eAnnotation2Literal((ENamedElement)eclassifier));
                    rbag.getRDFSlabel().add((Object)factory.createPlainLiteral("EEnum-" + name));
                    Iterator et = ((EEnum)eclassifier).getELiterals().iterator();
                    while (et.hasNext()) {
                        EEnumLiteral eLiteral = (EEnumLiteral)et.next();
                        rbag.getRDFSmember().add((Object)factory.createPlainLiteral(eLiteral.getName()));
                    }
                    rsource = rbag;
                } else if (eclassifier instanceof EDataType) {
                    RDFSDatatype rdatatype = factory.createRDFSDatatype(graph, name);
                    rdatatype.getRDFScomment().addAll((Collection)Ecore2RDFS.eAnnotation2Literal((ENamedElement)eclassifier));
                    rdatatype.getRDFSlabel().add((Object)factory.createPlainLiteral("EDatatype-" + name));
                    rsource = rdatatype;
                }
                ecore2rdfMap.put(eclassifier, rsource);
            }
            catch (URISyntaxException e) {
                throw new EODMRDFSTransformerException("Something wrong when creating RDF Resource:" + e.getMessage());
            }
        }
        return rsource;
    }

    private static String eAnnotation2String(EAnnotation an) {
        String str = String.valueOf(an.getSource()) + ": ";
        EMap detail = an.getDetails();
        Iterator iter = detail.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            str = String.valueOf(str) + "  " + key + ":" + detail.get(key);
        }
        return Ecore2RDFS.replaceKeywords(str);
    }

    private static String replaceKeywords(String str) {
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("'", "&apos;");
        str = str.replaceAll("\"", "&quot;");
        return str;
    }

    static void saveRDFGraph(RDFGraph graph, String filePath, String docURI) throws URISyntaxException, IOException {
        Document document = RDFFactory.eINSTANCE.createDocument(docURI);
        document.setComplementalGraph(graph);
        RDFXMLSaver.saveToFile(document, filePath, "UTF-8");
    }

    static List getEclassifier(EPackage ePackage) {
        EList lst = ePackage.getEClassifiers();
        Iterator iter = ePackage.getESubpackages().iterator();
        while (iter.hasNext()) {
            EPackage sube = (EPackage)iter.next();
            lst.addAll(Ecore2RDFS.getEclassifier(sube));
        }
        return lst;
    }
}

