/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.gmf.runtime.common.ui.preferences.AbstractPreferencePage;
import org.eclipse.gmf.runtime.common.ui.preferences.CheckBoxFieldEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.uml2.diagram.common.Messages;

public abstract class IconStylePreferencePage
extends AbstractPreferencePage {
    private CheckBoxFieldEditor myShowStereotypeIconOnly;
    private static final String ICONSTYLE_GROUPBOX_LABEL = Messages.IconStylePreferencePage_icon_style_group;
    private static final String ALTERNATIVE_STYLE_ICON_LABEL = Messages.IconStylePreferencePage_cheerful_style;
    private static final String ECLIPSE_STYLE_ICON_LABEL = Messages.IconStylePreferencePage_eclipse_style;
    protected static final String LABEL_SHOW_HIDE_STEREOTYPE_GROUP = Messages.IconStylePreferencePage_group_stereotype_images;
    protected static final String LABEL_SHOW_HIDE_STEREOTYPE_MODE = Messages.IconStylePreferencePage_label_show_stereotype;
    protected static final String LABEL_SHOW_HIDE_MODE = Messages.IconStylePreferencePage_group_metaclass_images;
    protected static final String LABEL_HIDE_ALL = Messages.IconStylePreferencePage_label_hide_all;
    protected static final String LABEL_SHOW_ALL = Messages.IconStylePreferencePage_label_show_all;
    protected static final String LABEL_SHOW_BY_VISUAL_ID = Messages.IconStylePreferencePage_label_show_for_selected;
    private RadioGroupFieldEditor myIconStyleFieldEditor;

    public static String getConnectionLabelPreference(int visualId) {
        return "show.label.visual.id" + visualId;
    }

    protected void addFields(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        main.setLayoutData((Object)new GridData(768));
        this.createIconStyleGroup(main);
        this.createShowHideMetaclassIconGroup(main);
    }

    protected void createIconStyleGroup(Composite parent) {
        String[][] choices = new String[][]{{ALTERNATIVE_STYLE_ICON_LABEL, "iconstyle.pink"}, {ECLIPSE_STYLE_ICON_LABEL, "iconstyle.blue"}};
        this.myIconStyleFieldEditor = new RadioGroupFieldEditor("iconstyle", ICONSTYLE_GROUPBOX_LABEL, 1, choices, parent, true);
        this.addField((FieldEditor)this.myIconStyleFieldEditor);
    }

    protected void createShowHideMetaclassIconGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setText(LABEL_SHOW_HIDE_STEREOTYPE_GROUP);
        group.setLayoutData((Object)new GridData(768));
        this.myShowStereotypeIconOnly = new CheckBoxFieldEditor("iconstyle.show-stereotype-icon.mode", LABEL_SHOW_HIDE_STEREOTYPE_MODE, (Composite)group);
        group.setLayout((Layout)new GridLayout());
        this.addField((FieldEditor)this.myShowStereotypeIconOnly);
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault("iconstyle", "iconstyle.blue");
        store.setDefault("iconstyle.show-hide.mode", "show.all");
        store.setDefault("iconstyle.show-stereotype-icon.mode", true);
    }

    protected Composite getFieldEditorParent() {
        Composite parent = super.getFieldEditorParent();
        ScrolledComposite s = this.createScrolledComposite(parent);
        Composite sbody = IconStylePreferencePage.createComposite((Composite)s);
        s.setContent((Control)sbody);
        return sbody;
    }

    protected Composite createExpansibleComposite(Composite parent, String title) {
        ExpandableComposite ecomp = new ExpandableComposite(parent, 0, 18);
        ecomp.setText(title);
        ecomp.setLayoutData((Object)new GridData());
        ecomp.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Object obj = e.getSource();
                IconStylePreferencePage.this.handleExpand(IconStylePreferencePage.this.getScrollingParent(obj));
            }
        });
        Composite client = IconStylePreferencePage.createComposite((Composite)ecomp);
        ecomp.setClient((Control)client);
        return client;
    }

    protected static Composite createComposite(Composite parent) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout());
        g.setFont(parent.getFont());
        g.setLayoutData((Object)new GridData(1808));
        return g;
    }

    private ScrolledComposite getScrollingParent(Object obj) {
        if (obj instanceof ExpandableComposite) {
            ExpandableComposite ecomp = (ExpandableComposite)obj;
            Composite parent = ecomp.getParent();
            while (parent != null && !(parent instanceof ScrolledComposite)) {
                parent = parent.getParent();
            }
            if (parent != null) {
                return (ScrolledComposite)parent;
            }
        }
        if (obj instanceof ScrolledComposite) {
            return (ScrolledComposite)obj;
        }
        return null;
    }

    private void handleExpand(ScrolledComposite composite) {
        if (composite == null) {
            return;
        }
        try {
            composite.setRedraw(false);
            Composite c = (Composite)composite.getContent();
            if (c == null) {
                return;
            }
            Point newSize = c.computeSize(-1, -1);
            composite.setMinSize(newSize);
            c.layout(true);
        }
        finally {
            composite.setRedraw(true);
        }
    }

    private ScrolledComposite createScrolledComposite(Composite parent) {
        ScrolledComposite scomp = new ScrolledComposite(parent, 768);
        scomp.setExpandHorizontal(true);
        scomp.setExpandVertical(true);
        scomp.setLayout((Layout)new GridLayout());
        scomp.setLayoutData((Object)new GridData(4, 4, true, true));
        scomp.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                IconStylePreferencePage.this.handleExpand(IconStylePreferencePage.this.getScrollingParent(event.widget));
            }
        });
        return scomp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ShowHideConnectorLabelGroup {
        private final List<CheckBoxFieldEditor> myConnectorLabelsByVisualIdEditors = new ArrayList<CheckBoxFieldEditor>();

        public Composite createShowHideConnectorLabelGroup(Composite parent, Map<String, Integer> fields) {
            Composite result = new Composite(parent, 0);
            result.setLayoutData((Object)new GridData(768));
            result.setLayout((Layout)new GridLayout());
            Group group = new Group(result, 0);
            group.setFont(result.getFont());
            group.setText(Messages.IconStylePreferencePage_group_show_hide_connector_labels);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)new GridLayout());
            Composite checkBoxesPanel = this.createCheckboxesPanel((Composite)group);
            this.addAllFields(checkBoxesPanel, fields);
            this.createButtonsPanel((Composite)group);
            return result;
        }

        private Composite createCheckboxesPanel(Composite parent) {
            Composite e = IconStylePreferencePage.this.createExpansibleComposite(parent, Messages.IconStylePreferencePage_composite_connector_labels);
            Composite checkBoxesPanel = new Composite(e, 0);
            checkBoxesPanel.setLayout((Layout)new GridLayout());
            checkBoxesPanel.setLayoutData((Object)new GridData(768));
            return checkBoxesPanel;
        }

        private Composite createButtonsPanel(Composite parent) {
            Composite buttonsPanel = new Composite(parent, 0);
            buttonsPanel.setLayout((Layout)new GridLayout(2, true));
            buttonsPanel.setLayoutData((Object)new GridData(768));
            Button selectAll = this.addSelectAllButton(buttonsPanel, true);
            selectAll.setText(Messages.IconStylePreferencePage_button_select_all);
            Button deselectAll = this.addSelectAllButton(buttonsPanel, false);
            deselectAll.setText(Messages.IconStylePreferencePage_button_deselect_all);
            return buttonsPanel;
        }

        private void addAllFields(Composite parent, Map<String, Integer> fields) {
            ArrayList<String> sortedLabels = new ArrayList<String>(fields.keySet());
            Collections.sort(sortedLabels);
            for (String label : sortedLabels) {
                this.addCheckBoxForLabelVisualIds(parent, label, fields.get(label));
            }
        }

        private CheckBoxFieldEditor addCheckBoxForLabelVisualIds(Composite parent, String commonLabel, int visualId) {
            CheckBoxFieldEditor result = new CheckBoxFieldEditor(IconStylePreferencePage.getConnectionLabelPreference(visualId), commonLabel, parent);
            this.myConnectorLabelsByVisualIdEditors.add(result);
            IconStylePreferencePage.this.addField((FieldEditor)result);
            return result;
        }

        private Button addSelectAllButton(Composite parent, final boolean selectNotDeselect) {
            Button selectButton = new Button(parent, 8);
            selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (CheckBoxFieldEditor next : ShowHideConnectorLabelGroup.this.myConnectorLabelsByVisualIdEditors) {
                        next.getCheckbox().setSelection(selectNotDeselect);
                    }
                }
            });
            int widthHint = IconStylePreferencePage.this.convertHorizontalDLUsToPixels(61);
            Dialog.applyDialogFont((Control)selectButton);
            GridData data = new GridData(256);
            Point minButtonSize = selectButton.computeSize(-1, -1, true);
            data.widthHint = Math.max(widthHint, minButtonSize.x);
            selectButton.setLayoutData((Object)data);
            return selectButton;
        }
    }
}

