/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: Element.java,v 1.2 2007/03/18 08:39:03 lzhang Exp $
 */

package org.eclipse.eodm.rdf.resource.parser.xml;

/**
 * The basic element in RDF/XML files
 */
public class Element {
    private String xmlLang;

    private String xmlBase;

    /**
     * Get the xml:lang attribute.
     * 
     * @return the xml:lang attribute
     */
    public String getXmlLang() {
        return xmlLang;
    }

    /**
     * Set the xml:lang attribute.
     * 
     * @param xmlLang
     *            the xml:lang attribute
     */
    public void setXmlLang(String xmlLang) {
        this.xmlLang = xmlLang;
    }

    /**
     * @return Returns the xmlBase.
     */
    public String getXmlBase() {
        return xmlBase;
    }

    /**
     * @param xmlBase
     *            The xmlBase to set.
     */
    public void setXmlBase(String xmlBase) {
        this.xmlBase = xmlBase;
    }
}