/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d;

import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.ImageUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class RotatedImageOfString
extends ImageFigure {
    private String text;
    private Font imageFont = null;
    private Color foregroundColor = null;
    private Color backgroundColor = null;

    public void setText(String text) {
        this.text = text;
        this.updateImage();
    }

    public String getText() {
        return this.text;
    }

    public void addNotify() {
        this.updateImage();
        super.addNotify();
    }

    public void removeNotify() {
        if (super.getImage() != null) {
            super.getImage().dispose();
        }
        super.removeNotify();
    }

    public Image getImage() {
        boolean update = false;
        if (this.imageFont != this.getFont()) {
            this.imageFont = this.getFont();
            update = true;
        }
        if (this.foregroundColor == null && this.getForegroundColor() != null || !this.foregroundColor.equals((Object)this.getForegroundColor())) {
            this.foregroundColor = this.getForegroundColor();
            update = true;
        }
        if (this.backgroundColor == null && this.getBackgroundColor() != null || !this.backgroundColor.equals((Object)this.getBackgroundColor())) {
            this.backgroundColor = this.getBackgroundColor();
            update = true;
        }
        if (update) {
            return this.updateImage();
        }
        return super.getImage();
    }

    private Image updateImage() {
        if (super.getImage() != null) {
            super.getImage().dispose();
        }
        if (this.text == null) {
            return null;
        }
        Image image = ImageUtilities.createRotatedImageOfString((String)this.text, (Font)this.getFont(), (Color)this.getForegroundColor(), (Color)this.getBackgroundColor());
        super.setImage(image);
        return image;
    }
}

