/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.edit.policies;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.sequence.edit.policies.OrderedLayoutEditPolicy;
import org.eclipse.uml2.diagram.sequence.part.UMLVisualIDRegistry;

public class SDXYLayoutEditPolicy
extends XYLayoutEditPolicy
implements OrderedLayoutEditPolicy {
    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof IBorderItemEditPart) {
            return new BorderItemSelectionEditPolicy();
        }
        EditPolicy result = super.createChildEditPolicy(child);
        if (result == null) {
            return new ResizableShapeEditPolicy();
        }
        return result;
    }

    public OrderedLayoutEditPolicy.AnchoredSibling findAnchoredSibling(Point relativeLocation) {
        OrderedLayoutEditPolicy.AnchoredSibling result = this.findAnchorAbove(relativeLocation);
        if (result == null) {
            result = this.findAnchorBelow(relativeLocation);
        }
        return result;
    }

    private OrderedLayoutEditPolicy.AnchoredSibling findAnchorAbove(Point relativeLocation) {
        View hostView = this.getHostImpl().getNotationView();
        Node result = null;
        int maxFoundPositionBefore = Integer.MIN_VALUE;
        for (Object next : hostView.getChildren()) {
            int nextMaxY;
            Bounds bounds;
            Node nextChild;
            if (!(next instanceof Node) || !SDXYLayoutEditPolicy.isConsiderableNode(nextChild = (Node)next) || !(nextChild.getLayoutConstraint() instanceof Bounds) || !(bounds = (Bounds)nextChild.getLayoutConstraint()).eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y()) || !bounds.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height()) || (nextMaxY = bounds.getY() + bounds.getHeight()) <= maxFoundPositionBefore || nextMaxY >= relativeLocation.y) continue;
            maxFoundPositionBefore = nextMaxY;
            result = nextChild;
        }
        return result == null ? null : new OrderedLayoutEditPolicy.AnchoredSibling((View)result, false);
    }

    private OrderedLayoutEditPolicy.AnchoredSibling findAnchorBelow(Point relativeLocation) {
        View hostView = this.getHostImpl().getNotationView();
        Node result = null;
        int minFoundPositionAfter = Integer.MAX_VALUE;
        for (Object next : hostView.getChildren()) {
            int nextY;
            Bounds bounds;
            Node nextChild;
            if (!(next instanceof Node) || !SDXYLayoutEditPolicy.isConsiderableNode(nextChild = (Node)next) || !(nextChild.getLayoutConstraint() instanceof Bounds) || !(bounds = (Bounds)nextChild.getLayoutConstraint()).eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y()) || !bounds.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height()) || (nextY = bounds.getY()) >= minFoundPositionAfter || nextY <= relativeLocation.y) continue;
            minFoundPositionAfter = nextY;
            result = nextChild;
        }
        return result == null ? null : new OrderedLayoutEditPolicy.AnchoredSibling((View)result, true);
    }

    private IGraphicalEditPart getHostImpl() {
        return (IGraphicalEditPart)this.getHost();
    }

    private static boolean isConsiderableNode(Node node) {
        int vid = UMLVisualIDRegistry.getVisualID((View)node);
        if (vid == -1) {
            return false;
        }
        if (UMLVisualIDRegistry.isCompartmentVisualID(vid)) {
            return false;
        }
        return vid <= 5000;
    }
}

