/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.pde.api.tools.internal.model.AbstractApiTypeRoot;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Signatures;

public class ArchiveApiTypeContainer
extends ApiElement
implements IApiTypeContainer {
    private static final Map<Path, FileSystem> JRTS = new ConcurrentHashMap<Path, FileSystem>();
    String fLocation;
    private Map<String, Map<String, String>> fPackages;
    private String[] fPackageNames;

    public ArchiveApiTypeContainer(IApiElement parent, String path) {
        super(parent, 3, path);
        this.fLocation = path;
    }

    private Path getLocation() throws IOException {
        Path path = Path.of(this.fLocation, new String[0]);
        if (this.fLocation.endsWith("jrt-fs.jar")) {
            AtomicReference exception = new AtomicReference();
            FileSystem jrtFileSystem = JRTS.computeIfAbsent(path.toRealPath(new LinkOption[0]), it -> {
                Path jrePath = it.getParent().getParent();
                try {
                    return FileSystems.newFileSystem(URI.create("jrt:/"), Map.of("java.home", jrePath.toString()));
                }
                catch (IOException e) {
                    exception.set(e);
                    return null;
                }
            });
            if (exception.get() != null) {
                throw (IOException)exception.get();
            }
            return jrtFileSystem.getPath("modules", new String[0]);
        }
        return JRTUtil.getJarFileSystem((Path)path).getPath("/", new String[0]);
    }

    @Override
    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this)) {
            this.init();
            for (Map.Entry<String, Map<String, String>> entry : this.fPackages.entrySet()) {
                String pkg = entry.getKey();
                if (!visitor.visitPackage(pkg)) continue;
                Map<String, String> classes = entry.getValue();
                ArrayList<ArchiveApiTypeRoot> classFiles = new ArrayList<ArchiveApiTypeRoot>(classes.size());
                for (Map.Entry<String, String> classEntry : classes.entrySet()) {
                    classFiles.add(new ArchiveApiTypeRoot(this, classEntry.getKey(), classEntry.getValue()));
                }
                for (ArchiveApiTypeRoot classfile : classFiles) {
                    visitor.visit(pkg, classfile);
                    visitor.end(pkg, classfile);
                }
                visitor.endVisitPackage(pkg);
            }
        }
        visitor.end(this);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Archive Class File Container: " + this.getName());
        return buff.toString();
    }

    @Override
    public synchronized void close() throws CoreException {
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        String fileName;
        this.init();
        String packageName = Signatures.getPackageName(qualifiedName);
        Map<String, String> classFileNames = this.fPackages.get(packageName);
        if (classFileNames != null && (fileName = classFileNames.get(qualifiedName)) != null) {
            return new ArchiveApiTypeRoot(this, qualifiedName, fileName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPackageNames() throws CoreException {
        this.init();
        ArchiveApiTypeContainer archiveApiTypeContainer = this;
        synchronized (archiveApiTypeContainer) {
            if (this.fPackageNames == null) {
                this.fPackageNames = (String[])this.fPackages.keySet().toArray(String[]::new);
            }
            return this.fPackageNames;
        }
    }

    private synchronized void init() throws CoreException {
        if (this.fPackages == null) {
            this.fPackages = new TreeMap<String, Map<String, String>>();
            try {
                Path location = this.getLocation();
                boolean isJrt = "jrt".equals(location.toUri().getScheme());
                Throwable throwable = null;
                Object var4_6 = null;
                try (Stream<Path> walk = Files.walk(location, new FileVisitOption[0]);){
                    walk.forEach(it -> {
                        String name = location.relativize((Path)it).toString();
                        if (name.endsWith(".class")) {
                            String className = name.substring(isJrt ? name.indexOf(47) + 1 : 0, name.length() - ".class".length()).replace('/', '.');
                            String pkg = Signatures.getPackageName(className);
                            Map fileNames = this.fPackages.computeIfAbsent(pkg, p -> new TreeMap());
                            fileNames.put(className, name);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.abort("Failed to process archive: " + this.fLocation, e);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArchiveApiTypeContainer) {
            return this.fLocation.equals(((ArchiveApiTypeContainer)obj).fLocation);
        }
        return false;
    }

    public int hashCode() {
        return this.fLocation.hashCode();
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        return this.findTypeRoot(qualifiedName);
    }

    @Override
    public int getContainerType() {
        return 1;
    }

    static class ArchiveApiTypeRoot
    extends AbstractApiTypeRoot
    implements Comparable<Object> {
        private final String fTypeName;
        private byte[] fContents = null;

        public ArchiveApiTypeRoot(ArchiveApiTypeContainer container, String typeName, String entryName) {
            super(container, entryName);
            this.fTypeName = typeName;
        }

        @Override
        public String getTypeName() {
            return this.fTypeName;
        }

        @Override
        public int compareTo(Object o) {
            return this.getTypeName().compareTo(((ArchiveApiTypeRoot)o).getTypeName());
        }

        public boolean equals(Object obj) {
            if (obj instanceof ArchiveApiTypeRoot) {
                ArchiveApiTypeRoot classFile = (ArchiveApiTypeRoot)obj;
                return this.getName().equals(classFile.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        public byte[] getContents() throws CoreException {
            if (this.fContents != null) {
                return this.fContents;
            }
            ArchiveApiTypeContainer archive = (ArchiveApiTypeContainer)this.getParent();
            try {
                Path location = archive.getLocation();
                Path classLocation = location.resolve(this.getName());
                this.fContents = Files.readAllBytes(classLocation);
            }
            catch (IOException e) {
                this.abort("Failed to open class file: " + this.getTypeName() + " in archive: " + archive.fLocation, e);
            }
            return this.fContents;
        }

        public String toString() {
            return this.getTypeName();
        }
    }
}

