/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationService;

public class OpenInCommitViewerHandler
extends AbstractHistoryCommandHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(event);
        List<RevCommit> commits = this.getSelectedCommits(event);
        for (RevCommit commit : commits) {
            try {
                CommitEditor.open(new RepositoryCommit(repository, commit));
            }
            catch (PartInitException e) {
                Activator.showError("Error opening commit viewer", e);
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IStructuredSelection selection = SelectionUtils.getSelection(((IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class)).getCurrentState());
        if (selection.size() > 1) {
            element.setText(UIText.GitHistoryPage_OpenAllInCommitViewerLabel);
        }
    }
}

