/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.plugin;

import java.io.PrintWriter;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.text.DocumentTextNode;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.plugin.PluginParentNode;

public class PluginElementNode
extends PluginParentNode
implements IPluginElement {
    private static final long serialVersionUID = 1L;
    private transient ISchemaElement elementInfo;

    @Override
    public IPluginElement createCopy() {
        return null;
    }

    @Override
    public IPluginAttribute getAttribute(String name) {
        return (IPluginAttribute)((TreeMap)this.getNodeAttributesMap()).get(name);
    }

    @Override
    public IPluginAttribute[] getAttributes() {
        return ((TreeMap)this.getNodeAttributesMap()).values().toArray(new IPluginAttribute[((TreeMap)this.getNodeAttributesMap()).size()]);
    }

    @Override
    public int getAttributeCount() {
        return ((TreeMap)this.getNodeAttributesMap()).size();
    }

    @Override
    public String getText() {
        IDocumentTextNode node = this.getTextNode();
        return node == null ? "" : node.getText();
    }

    @Override
    public void setAttribute(String name, String value) throws CoreException {
        this.setXMLAttribute(name, value);
    }

    @Override
    public void setText(String text) throws CoreException {
        String oldText;
        IDocumentTextNode node = this.getTextNode();
        String string = oldText = node == null ? null : node.getText();
        if (node == null) {
            node = new DocumentTextNode();
            node.setEnclosingElement(this);
            this.addTextNode(node);
        }
        node.setText(text.trim());
        this.firePropertyChanged(node, "text", oldText, text);
    }

    @Override
    public String write(boolean indent) {
        String sep = this.getLineDelimiter();
        StringBuilder buffer = new StringBuilder();
        if (indent) {
            buffer.append(this.getIndent());
        }
        IDocumentElementNode[] children = this.getChildNodes();
        String text = this.getText();
        buffer.append(this.writeShallow(false));
        if (this.getAttributeCount() > 0 || children.length > 0 || text.length() > 0) {
            buffer.append(sep);
        }
        if (children.length > 0 || text.length() > 0) {
            if (text.length() > 0) {
                buffer.append(this.getIndent());
                buffer.append("   ");
                buffer.append(text);
                buffer.append(sep);
            }
            IDocumentElementNode[] iDocumentElementNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IDocumentElementNode childNode = iDocumentElementNodeArray[n2];
                childNode.setLineIndent(this.getLineIndent() + 3);
                buffer.append(childNode.write(true));
                buffer.append(sep);
                ++n2;
            }
        }
        if (this.getAttributeCount() > 0 || children.length > 0 || text.length() > 0) {
            buffer.append(this.getIndent());
        }
        buffer.append("</" + this.getXMLTagName() + ">");
        return buffer.toString();
    }

    @Override
    public String writeShallow(boolean terminate) {
        IDocumentAttributeNode[] attrs;
        String sep = this.getLineDelimiter();
        StringBuilder buffer = new StringBuilder("<" + this.getXMLTagName());
        IDocumentAttributeNode[] iDocumentAttributeNodeArray = attrs = this.getNodeAttributes();
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentAttributeNode attrNode = iDocumentAttributeNodeArray[n2];
            if (attrNode.getAttributeValue().length() > 0) {
                buffer.append(sep + this.getIndent() + "      " + attrNode.write());
            }
            ++n2;
        }
        if (terminate) {
            buffer.append("/");
        }
        buffer.append(">");
        return buffer.toString();
    }

    @Override
    public String getName() {
        return this.getXMLTagName();
    }

    @Override
    public void setName(String name) throws CoreException {
        this.setXMLTagName(name);
    }

    @Override
    public Object getElementInfo() {
        if (this.elementInfo == null) {
            IPluginExtension extension;
            ISchema schema;
            IDocumentElementNode node;
            for (node = this.getParentNode(); node != null && !(node instanceof IPluginExtension); node = node.getParentNode()) {
            }
            if (node != null && (schema = (ISchema)(extension = (IPluginExtension)((Object)node)).getSchema()) != null) {
                this.elementInfo = schema.findElement(this.getName());
            }
        }
        return this.elementInfo;
    }

    @Override
    public void reconnect(IDocumentElementNode parent, IModel model) {
        super.reconnect(parent, model);
        this.elementInfo = null;
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.write(this.write(true));
    }
}

