/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.command.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.edit.command.ChangeCommand;

public abstract class AbstractCopyCommand
extends ChangeCommand
implements ICompareCopyCommand {
    protected final List<? extends Diff> differences;
    protected final boolean leftToRight;
    protected final IMerger.Registry mergerRegistry;

    public AbstractCopyCommand(ChangeRecorder changeRecorder, Collection<Notifier> notifiers, List<? extends Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        super(changeRecorder, notifiers);
        this.differences = ImmutableList.copyOf(differences);
        this.leftToRight = leftToRight;
        this.mergerRegistry = mergerRegistry;
    }

    @Override
    public boolean isLeftToRight() {
        return this.leftToRight;
    }

    public Collection<?> getAffectedObjects() {
        return this.differences;
    }

    public boolean canExecute() {
        return super.canExecute() && !this.differences.isEmpty();
    }

    public Multimap<DifferenceState, Diff> getChangedDiffs() {
        return AbstractCopyCommand.getChangedDiffs(this.getChangeDescription(), this.differences);
    }

    public static Multimap<DifferenceState, Diff> getChangedDiffs(ChangeDescription changeDescription, Collection<? extends Diff> relevantDiffs) {
        LinkedHashMultimap ret = LinkedHashMultimap.create();
        if (changeDescription != null) {
            EMap objectChanges = changeDescription.getObjectChanges();
            block0: for (Diff diff : relevantDiffs) {
                EList featureChanges = (EList)objectChanges.get((Object)diff);
                if (featureChanges == null) continue;
                for (FeatureChange featureChange : featureChanges) {
                    if (featureChange.getFeature() != ComparePackage.Literals.DIFF__STATE) continue;
                    ret.put((Object)diff.getState(), (Object)diff);
                    continue block0;
                }
            }
        }
        return ret;
    }

    public void dispose() {
        ChangeDescription changes = this.getChangeDescription();
        if (changes != null) {
            changes.getObjectsToAttach().clear();
        }
        super.dispose();
    }
}

