/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedFileManager;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedSourceFolderManager;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;
import org.eclipse.jdt.core.IJavaProject;

public class AptProject {
    private final IJavaProject _javaProject;
    private final GeneratedFileManager _main_gfm;
    private final GeneratedSourceFolderManager _main_gsfm;
    private final GeneratedFileManager _test_gfm;
    private final GeneratedSourceFolderManager _test_gsfm;

    public AptProject(IJavaProject javaProject) {
        this._javaProject = javaProject;
        this._main_gsfm = new GeneratedSourceFolderManager(this, false);
        this._main_gfm = new GeneratedFileManager(this, this._main_gsfm);
        this._test_gsfm = new GeneratedSourceFolderManager(this, true);
        this._test_gfm = new GeneratedFileManager(this, this._test_gsfm);
    }

    public IJavaProject getJavaProject() {
        return this._javaProject;
    }

    public GeneratedFileManager getGeneratedFileManager(boolean isTestCode) {
        return isTestCode ? this._test_gfm : this._main_gfm;
    }

    public GeneratedSourceFolderManager getGeneratedSourceFolderManager(boolean isTestCode) {
        return isTestCode ? this._test_gsfm : this._main_gsfm;
    }

    public void compilationStarted() {
        this.getGeneratedFileManager(false).compilationStarted();
        this.getGeneratedFileManager(true).compilationStarted();
    }

    public void preferenceChanged(String key) {
        if ("org.eclipse.jdt.apt.genSrcDir".equals(key)) {
            this._main_gsfm.folderNamePreferenceChanged();
        } else if ("org.eclipse.jdt.apt.genTestSrcDir".equals(key)) {
            this._test_gsfm.folderNamePreferenceChanged();
        } else if ("org.eclipse.jdt.apt.aptEnabled".equals(key)) {
            this._main_gsfm.enabledPreferenceChanged();
            this._test_gsfm.enabledPreferenceChanged();
        }
    }

    public void projectClean(boolean deleteFiles, boolean cleanMain, boolean cleanTest) {
        if (cleanMain) {
            this._main_gfm.projectCleaned();
        }
        if (cleanTest) {
            this._test_gfm.projectCleaned();
        }
        if (deleteFiles) {
            int i;
            IResource[] members;
            IFolder f;
            if (cleanMain && (f = this._main_gsfm.getFolder()) != null && f.exists()) {
                try {
                    members = f.members();
                    i = 0;
                    while (i < members.length) {
                        FileSystemUtil.deleteDerivedResources(members[i]);
                        ++i;
                    }
                }
                catch (CoreException ce) {
                    AptPlugin.log(ce, "Could not delete generated files");
                }
            }
            if (cleanMain && (f = this._test_gsfm.getFolder()) != null && f.exists()) {
                try {
                    members = f.members();
                    i = 0;
                    while (i < members.length) {
                        FileSystemUtil.deleteDerivedResources(members[i]);
                        ++i;
                    }
                }
                catch (CoreException ce) {
                    AptPlugin.log(ce, "Could not delete generated files");
                }
            }
        }
    }

    public void projectClosed() {
        this._main_gfm.projectClosed();
        this._test_gfm.projectClosed();
    }

    public void projectDeleted() {
        if (AptPlugin.DEBUG) {
            AptPlugin.trace("AptProject.projectDeleted cleaning state for project " + this._javaProject.getElementName());
        }
        this._main_gfm.projectDeleted();
        this._test_gfm.projectDeleted();
    }
}

