/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.exports;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.core.Property;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.build.site.QualifierReplacer;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.exports.BuildUtilities;
import org.eclipse.pde.internal.core.exports.ExecutionEnvironmentProfileManager;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.WorkspaceExportHelper;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.target.TargetMetadataCollector;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.osgi.framework.InvalidSyntaxException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FeatureExportOperation
extends Job {
    protected String fBuildTempLocation;
    protected String fBuildTempMetadataLocation;
    private String fDevProperties;
    private static boolean fHasErrors;
    protected HashMap<String, String> fAntBuildProperties;
    protected WorkspaceExportHelper fWorkspaceExportHelper;
    protected State fStateCopy;
    protected static String FEATURE_POST_PROCESSING;
    protected static String PLUGIN_POST_PROCESSING;
    private static final String[] GENERIC_CONFIG;
    protected FeatureExportInfo fInfo;
    private boolean isPreviewFeatureEnabled;

    static {
        FEATURE_POST_PROCESSING = "features.postProcessingSteps.properties";
        PLUGIN_POST_PROCESSING = "plugins.postProcessingSteps.properties";
        GENERIC_CONFIG = new String[]{"*", "*", "*", ""};
    }

    public FeatureExportOperation(FeatureExportInfo info, String name) {
        super(name);
        this.fInfo = info;
        String qualifier = info.qualifier;
        if (qualifier == null) {
            qualifier = QualifierReplacer.getDateQualifier();
        }
        QualifierReplacer.setGlobalQualifier((String)qualifier);
        this.fBuildTempLocation = PDECore.getDefault().getStateLocation().append("temp").toString();
        this.fBuildTempMetadataLocation = PDECore.getDefault().getStateLocation().append("tempp2metadata").toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.createDestination();
            String[][] configurations = this.fInfo.targets;
            if (configurations == null) {
                configurations = new String[1][];
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Exporting...", (int)(this.fInfo.items.length * 23 + 5 + 10));
            IStatus status = this.testBuildWorkspaceBeforeExport((IProgressMonitor)subMonitor.split(10));
            if (this.fInfo.exportSource && this.fInfo.exportSourceBundle) {
                String featureID = "org.eclipse.pde.container.feature";
                String fFeatureLocation = String.valueOf(this.fBuildTempLocation) + File.separator + featureID;
                this.createFeature(featureID, fFeatureLocation, this.fInfo.items, null, null, null);
                ExternalFeatureModel model = new ExternalFeatureModel();
                model.setInstallLocation(fFeatureLocation);
                Throwable throwable = null;
                Object var9_16 = null;
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(new File(String.valueOf(fFeatureLocation) + File.separator + "feature.xml")));){
                    model.load(stream, true);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                this.doExport(model, null, (IProgressMonitor)subMonitor.split(20));
                return status;
            }
            Object[] objectArray = this.fInfo.items;
            int n = this.fInfo.items.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return status;
                }
                Object item = objectArray[n2];
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    try {
                        this.doExport((IFeatureModel)item, configurations, (IProgressMonitor)subMonitor.split(20));
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        this.cleanup((IProgressMonitor)subMonitor.split(3));
                        return iStatus;
                    }
                }
                finally {
                    this.cleanup((IProgressMonitor)subMonitor.split(3));
                }
                ++n2;
            }
        }
        catch (InvocationTargetException | CoreException e) {
            Throwable throwable;
            if (e.getCause() != null) {
                throwable = e.getCause();
                return Status.error((String)PDECoreMessages.FeatureBasedExportOperation_ProblemDuringExport, (Throwable)throwable);
            }
            throwable = e;
            return Status.error((String)PDECoreMessages.FeatureBasedExportOperation_ProblemDuringExport, (Throwable)throwable);
        }
        catch (IOException e) {
            return Status.error((String)PDECoreMessages.FeatureBasedExportOperation_ProblemDuringExport, (Throwable)e);
        }
    }

    protected void save(File file, Properties properties, String header) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream stream = new FileOutputStream(file);){
                properties.store(stream, header);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    protected void appendMetadataToArchive(String[] configuration, IProgressMonitor monitor) {
        String filename = this.fInfo.zipFileName;
        if (configuration != null) {
            int i = filename.lastIndexOf(46);
            filename = String.valueOf(filename.substring(0, i)) + '.' + configuration[0] + '.' + configuration[1] + '.' + configuration[2] + filename.substring(i);
        }
        String archive = String.valueOf(this.fInfo.destinationDirectory) + File.separator + filename;
        File scriptFile = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            try {
                scriptFile = this.createScriptFile("append.xml");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().newDocument();
                Element root = doc.createElement("project");
                root.setAttribute("name", "temp");
                root.setAttribute("default", "append");
                root.setAttribute("basedir", ".");
                doc.appendChild(root);
                Element target = doc.createElement("target");
                target.setAttribute("name", "clean");
                Element child = doc.createElement("delete");
                child.setAttribute("dir", this.fBuildTempMetadataLocation);
                target.appendChild(child);
                root.appendChild(target);
                target = doc.createElement("target");
                target.setAttribute("name", "append");
                child = doc.createElement("zip");
                child.setAttribute("zipfile", archive);
                child.setAttribute("basedir", this.fBuildTempMetadataLocation);
                child.setAttribute("update", "true");
                target.appendChild(child);
                root.appendChild(target);
                XMLPrintHandler.writeFile(doc, scriptFile);
                String[] targets = new String[]{"append", "clean"};
                AntRunner runner = new AntRunner();
                runner.setBuildFileLocation(scriptFile.getAbsolutePath());
                runner.setExecutionTargets(targets);
                runner.run((IProgressMonitor)subMonitor.split(1));
            }
            catch (IOException | FactoryConfigurationError | ParserConfigurationException | CoreException e) {
                PDECore.logException(e);
                if (scriptFile != null && scriptFile.exists()) {
                    scriptFile.delete();
                }
            }
        }
        finally {
            if (scriptFile != null && scriptFile.exists()) {
                scriptFile.delete();
            }
        }
    }

    private void createDestination(String os, String ws, String arch) throws InvocationTargetException {
        if (!this.fInfo.toDirectory || this.groupedConfigurations()) {
            return;
        }
        File file = new File(this.fInfo.destinationDirectory, String.valueOf(os) + '.' + ws + '.' + arch);
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            throw new InvocationTargetException(new Exception(PDECoreMessages.ExportWizard_badDirectory));
        }
    }

    private void doExport(IFeatureModel model, String[][] configs, IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        IFeature feature = model.getFeature();
        if (configs == null || configs.length == 0 || configs[0] == null) {
            configs = new String[][]{{this.getOS(feature), this.getWS(feature), this.getOSArch(feature)}};
        } else {
            String[][] stringArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                String[] config = stringArray[n2];
                this.createDestination(config[0], config[1], config[2]);
                ++n2;
            }
        }
        try {
            String location = model.getInstallLocation();
            if (this.fInfo.useJarFormat) {
                this.createPostProcessingFile(new File(location, FEATURE_POST_PROCESSING));
                this.createPostProcessingFile(new File(location, PLUGIN_POST_PROCESSING));
            }
            this.doExport(feature.getId(), feature.getVersion(), location, configs, monitor);
        }
        finally {
            this.deleteBuildFiles(model);
        }
    }

    protected void createPostProcessingFile(File file) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileOutputStream stream = new FileOutputStream(file);){
                Properties prop = new Properties();
                prop.put("*", "updateJar");
                prop.store(stream, "");
                stream.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    protected void doExport(String featureID, String version, String featureLocation, String[][] configs, IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        String[] config;
        fHasErrors = false;
        int subTaskLength = 6 + configs.length * 4 + (this.publishingP2Metadata() ? 2 : 0);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDECoreMessages.FeatureExportJob_taskName, (int)subTaskLength);
        HashMap<String, String> properties = this.createAntBuildProperties(configs);
        BuildScriptGenerator generator = new BuildScriptGenerator();
        this.setupGenerator(generator, featureID, version, configs, featureLocation);
        generator.generate();
        subMonitor.split(1);
        subMonitor.setTaskName(PDECoreMessages.FeatureExportOperation_runningBuildScript);
        this.runScript(String.valueOf(featureLocation) + '/' + "compile." + featureID + ".xml", new String[]{"main"}, properties, (IProgressMonitor)subMonitor.split(1));
        if (this.fInfo.exportSource && !this.fInfo.exportSourceBundle) {
            this.runScript(this.getBuildScriptName(featureLocation), new String[]{"build.sources"}, properties, (IProgressMonitor)subMonitor.split(1));
        }
        if (this.publishingP2Metadata()) {
            subMonitor.setTaskName(PDECoreMessages.FeatureExportOperation_publishingMetadata);
            this.runScript(this.getAssembleP2ScriptName(featureID, featureLocation), new String[]{"main"}, properties, (IProgressMonitor)subMonitor.split(2));
            if (this.groupedConfigurations()) {
                configs = new String[][]{{"group", "group", "group"}};
            }
        }
        subMonitor.setTaskName(PDECoreMessages.FeatureExportOperation_runningAssemblyScript);
        String[][] stringArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            config = stringArray[n2];
            this.setArchiveLocation(properties, config[0], config[1], config[2]);
            this.runScript(this.getAssemblyScriptName(featureID, config[0], config[1], config[2], featureLocation), new String[]{"main"}, properties, (IProgressMonitor)subMonitor.split(2));
            ++n2;
        }
        subMonitor.setTaskName(PDECoreMessages.FeatureExportOperation_runningPackagerScript);
        stringArray = configs;
        n = configs.length;
        n2 = 0;
        while (n2 < n) {
            config = stringArray[n2];
            this.setArchiveLocation(properties, config[0], config[1], config[2]);
            this.runScript(this.getPackagerScriptName(featureID, config[0], config[1], config[2], featureLocation), null, properties, (IProgressMonitor)subMonitor.split(2));
            ++n2;
        }
        properties.put("destination.temp.folder", String.valueOf(this.fBuildTempLocation) + "/pde.logs");
        this.runScript(this.getBuildScriptName(featureLocation), new String[]{"gather.logs"}, properties, (IProgressMonitor)subMonitor.split(2));
    }

    protected boolean groupedConfigurations() {
        return this.publishingP2Metadata();
    }

    private void setArchiveLocation(Map<String, String> antProperties, String os, String ws, String arch) {
        if (!this.fInfo.toDirectory) {
            String filename = this.fInfo.zipFileName;
            if (this.fInfo.targets != null && !this.groupedConfigurations()) {
                int i = filename.lastIndexOf(46);
                filename = String.valueOf(filename.substring(0, i)) + '.' + os + '.' + ws + '.' + arch + filename.substring(i);
            }
            antProperties.put("archiveFullPath", String.valueOf(this.fInfo.destinationDirectory) + File.separator + filename);
        } else {
            String dir = this.fInfo.destinationDirectory;
            if (this.fInfo.targets != null && !this.groupedConfigurations()) {
                dir = String.valueOf(dir) + File.separatorChar + os + '.' + ws + '.' + arch;
            }
            antProperties.put("assemblyTempDir", dir);
        }
    }

    public void deleteBuildFiles(Object object) throws CoreException {
        int i;
        String directory;
        File dir;
        File[] children;
        IModel model = null;
        if (object instanceof BundleDescription) {
            model = PluginRegistry.findModel((BundleDescription)object);
        } else if (object instanceof IModel) {
            model = (IModel)object;
        }
        if (model == null) {
            return;
        }
        if (model.getUnderlyingResource() != null && !this.isCustomBuild(model) && (children = (dir = new File(directory = model instanceof IFeatureModel ? ((IFeatureModel)model).getInstallLocation() : ((IPluginModelBase)model).getInstallLocation())).listFiles()) != null) {
            i = 0;
            while (i < children.length) {
                if (!children[i].isDirectory()) {
                    String filename = children[i].getName();
                    if (filename.equals("build.xml") || filename.startsWith("javaCompiler.") && filename.endsWith(".args") || filename.startsWith("assemble.") && filename.endsWith(".xml") || filename.startsWith("package.") && filename.endsWith(".xml") || filename.startsWith("compile.") && filename.endsWith(".xml") || filename.equals(FEATURE_POST_PROCESSING) || filename.equals(PLUGIN_POST_PROCESSING)) {
                        children[i].delete();
                    }
                } else if (children[i].getName().equals("temp.folder")) {
                    CoreUtility.deleteContent(children[i]);
                }
                ++i;
            }
        }
        if (model instanceof IFeatureModel) {
            IFeaturePlugin[] plugins;
            IFeatureChild[] children2;
            IFeature feature = ((IFeatureModel)model).getFeature();
            IFeatureChild[] iFeatureChildArray = children2 = feature.getIncludedFeatures();
            int n = children2.length;
            i = 0;
            while (i < n) {
                IFeatureChild featureChild = iFeatureChildArray[i];
                IFeature ref = ((FeatureChild)featureChild).getReferencedFeature();
                if (ref != null) {
                    this.deleteBuildFiles(ref.getModel());
                }
                ++i;
            }
            IFeaturePlugin[] iFeaturePluginArray = plugins = feature.getPlugins();
            int n2 = plugins.length;
            n = 0;
            while (n < n2) {
                IFeaturePlugin featurePlugin = iFeaturePluginArray[n];
                IPluginModelBase plugin = PluginRegistry.findModel(featurePlugin.getId());
                if (plugin != null) {
                    this.deleteBuildFiles(plugin);
                }
                ++n;
            }
        }
    }

    private String getBuildScriptName(String featureLocation) {
        return String.valueOf(featureLocation) + '/' + "build.xml";
    }

    protected String getAssemblyScriptName(String featureID, String os, String ws, String arch, String featureLocation) {
        return String.valueOf(featureLocation) + '/' + "assemble." + featureID + "." + os + "." + ws + "." + arch + ".xml";
    }

    protected String getAssembleP2ScriptName(String featureID, String featureLocation) {
        return String.valueOf(featureLocation) + '/' + "assemble." + featureID + ".p2.xml";
    }

    protected void runScript(String location, String[] targets, Map<String, String> properties, IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        AntCorePreferences preferences;
        IAntClasspathEntry entry;
        AntRunner runner = new AntRunner();
        runner.addUserProperties(properties);
        runner.setAntHome(location);
        runner.setBuildFileLocation(location);
        runner.addBuildListener("org.eclipse.pde.internal.core.ant.ExportBuildListener");
        runner.setExecutionTargets(targets);
        if (this.fInfo.signingInfo != null && (entry = (preferences = AntCorePlugin.getPlugin().getPreferences()).getToolsJarEntry()) != null) {
            URL[] urls;
            block7: {
                IAntClasspathEntry[] classpath = preferences.getAntHomeClasspathEntries();
                urls = new URL[classpath.length + 2];
                int i = 0;
                while (i < classpath.length) {
                    urls[i] = classpath[i].getEntryURL();
                    ++i;
                }
                IPath path = new Path(entry.getEntryURL().toString()).removeLastSegments(2);
                path = path.append("bin");
                try {
                    try {
                        urls[classpath.length] = new URL(path.toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        urls[classpath.length] = entry.getEntryURL();
                        urls[classpath.length + 1] = entry.getEntryURL();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    urls[classpath.length + 1] = entry.getEntryURL();
                    throw throwable;
                }
                urls[classpath.length + 1] = entry.getEntryURL();
            }
            runner.setCustomClasspath(urls);
        }
        runner.run(monitor);
    }

    protected String getPackagerScriptName(String featureID, String os, String ws, String arch, String featureLocation) {
        return String.valueOf(featureLocation) + '/' + "package." + featureID + "." + os + "." + ws + "." + arch + ".xml";
    }

    protected HashMap<String, String> createAntBuildProperties(String[][] configs) {
        if (this.fAntBuildProperties == null) {
            String target;
            IExecutionEnvironment[] envs;
            this.fAntBuildProperties = new HashMap(15);
            List defaultProperties = AntCorePlugin.getPlugin().getPreferences().getProperties();
            ListIterator li = defaultProperties.listIterator();
            while (li.hasNext()) {
                Property prop = (Property)li.next();
                this.fAntBuildProperties.put(prop.getName(), prop.getValue());
            }
            if (this.fInfo.signingInfo != null) {
                this.fAntBuildProperties.put("sign.alias", this.fInfo.signingInfo[0]);
                this.fAntBuildProperties.put("sign.keystore", this.fInfo.signingInfo[1]);
                this.fAntBuildProperties.put("sign.storepass", this.fInfo.signingInfo[2]);
                this.fAntBuildProperties.put("sign.keypass", this.fInfo.signingInfo[3]);
            }
            if (this.fInfo.jnlpInfo != null) {
                this.fAntBuildProperties.put("jnlp.codebase", this.fInfo.jnlpInfo[0]);
                this.fAntBuildProperties.put("jnlp.j2se", this.fInfo.jnlpInfo[1]);
            }
            this.fAntBuildProperties.put("buildTempFolder", String.valueOf(this.fBuildTempLocation) + "/destination");
            this.fAntBuildProperties.put("feature.temp.folder", String.valueOf(this.fBuildTempLocation) + "/destination");
            this.fAntBuildProperties.put("include.children", "true");
            this.fAntBuildProperties.put("eclipse.running", "true");
            this.fAntBuildProperties.put("generateAPIDescription", "true");
            this.fAntBuildProperties.put("baseos", TargetPlatform.getOS());
            this.fAntBuildProperties.put("basews", TargetPlatform.getWS());
            this.fAntBuildProperties.put("basearch", TargetPlatform.getOSArch());
            this.fAntBuildProperties.put("basenl", TargetPlatform.getNL());
            this.fAntBuildProperties.put("bootclasspath", BuildUtilities.getBootClasspath());
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            IExecutionEnvironment[] iExecutionEnvironmentArray = envs = manager.getExecutionEnvironments();
            int n = envs.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutionEnvironment env = iExecutionEnvironmentArray[n2];
                String id = env.getId();
                if (id != null) {
                    this.fAntBuildProperties.put(id, BuildUtilities.getBootClasspath(id));
                }
                ++n2;
            }
            this.fAntBuildProperties.put("javacFailOnError", "false");
            this.fAntBuildProperties.put("javacDebugInfo", "on");
            this.fAntBuildProperties.put("javacVerbose", "false");
            if (this.isPreviewFeatureEnabled) {
                this.fAntBuildProperties.put("compilerArg", "--enable-preview");
            }
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.core");
            IEclipsePreferences def = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.core");
            String source = prefs.get("org.eclipse.jdt.core.compiler.source", null);
            if (source == null) {
                source = def.get("org.eclipse.jdt.core.compiler.source", null);
            }
            if (source != null) {
                this.fAntBuildProperties.put("javacSource", source);
            }
            if ((target = prefs.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform", null)) == null) {
                target = def.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform", null);
            }
            if (target != null) {
                float tar = Float.parseFloat(target);
                if ((double)tar < 1.8) {
                    target = "1.8";
                }
                this.fAntBuildProperties.put("javacTarget", target);
            }
            this.fAntBuildProperties.put("buildDirectory", String.valueOf(this.fBuildTempLocation) + "/assemblyLocation");
            this.fAntBuildProperties.put("buildLabel", ".");
            this.fAntBuildProperties.put("collectingFolder", ".");
            String prefix = Platform.getOS().equals("macosx") ? "." : "";
            this.fAntBuildProperties.put("archivePrefix", prefix);
            this.fAntBuildProperties.put("tarargs", "");
            this.fAntBuildProperties.put("runPackager", "true");
        }
        this.setP2MetaDataProperties(this.fAntBuildProperties);
        return this.fAntBuildProperties;
    }

    protected boolean publishingP2Metadata() {
        return this.fInfo.useJarFormat && this.fInfo.exportMetadata;
    }

    protected URI[] getMetadataContextFromTargetPlatform() {
        try {
            URI[] context = TargetMetadataCollector.getMetadataRepositories(null);
            if (context.length > 0) {
                return context;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    protected String getCategoryDefinition() {
        return this.fInfo.categoryDefinition;
    }

    protected void setP2MetaDataProperties(Map<String, String> map) {
        if (this.fInfo.useJarFormat && this.fInfo.exportMetadata) {
            map.put("generate.p2.metadata", "true");
            map.put("p2.flavor", "tooling");
            map.put("p2.publish.artifacts", "false");
            map.put("p2.final.mode.override", "true");
            map.put("p2.compress", "true");
            map.put("p2.gathering", Boolean.toString(this.publishingP2Metadata()));
            if (this.getCategoryDefinition() != null) {
                map.put("p2.category.definition", this.getCategoryDefinition());
            }
            try {
                String destination = "";
                if (this.publishingP2Metadata()) {
                    destination = new File(this.fBuildTempMetadataLocation).toURL().toString();
                    map.put("p2.build.repo", destination);
                } else {
                    destination = this.fInfo.toDirectory ? new File(this.fInfo.destinationDirectory).toURL().toString() : new File(this.fBuildTempMetadataLocation).toURI().toURL().toString();
                    map.put("p2.metadata.repo", destination);
                    map.put("p2.artifact.repo", destination);
                }
                map.put("p2.metadata.repo.name", PDECoreMessages.FeatureExportOperation_0);
                map.put("p2.artifact.repo.name", PDECoreMessages.FeatureExportOperation_0);
            }
            catch (MalformedURLException e) {
                PDECore.log(e);
            }
        }
    }

    private String getOS(IFeature feature) {
        String os = feature.getOS();
        if (os == null || os.trim().length() == 0 || os.indexOf(44) != -1 || os.equals("*")) {
            return TargetPlatform.getOS();
        }
        return os;
    }

    private String getWS(IFeature feature) {
        String ws = feature.getWS();
        if (ws == null || ws.trim().length() == 0 || ws.indexOf(44) != -1 || ws.equals("*")) {
            return TargetPlatform.getWS();
        }
        return ws;
    }

    private String getOSArch(IFeature feature) {
        String arch = feature.getArch();
        if (arch == null || arch.trim().length() == 0 || arch.indexOf(44) != -1 || arch.equals("*")) {
            return TargetPlatform.getOSArch();
        }
        return arch;
    }

    protected void createDestination() throws InvocationTargetException {
        File file = new File(this.fInfo.destinationDirectory);
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            throw new InvocationTargetException(new Exception(PDECoreMessages.ExportWizard_badDirectory));
        }
        File metadataTemp = new File(this.fBuildTempMetadataLocation);
        if (metadataTemp.exists()) {
            this.deleteDir(metadataTemp);
        }
    }

    protected void deleteDir(File dir) {
        if (dir.exists()) {
            File[] children;
            if (dir.isDirectory() && (children = dir.listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File element = fileArray[n2];
                    this.deleteDir(element);
                    ++n2;
                }
            }
            dir.delete();
        }
    }

    private String getConfigInfo(String[][] configs) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < configs.length) {
            if (i > 0) {
                buffer.append('&');
            }
            buffer.append(configs[i][0]);
            buffer.append(',');
            buffer.append(configs[i][1]);
            buffer.append(',');
            buffer.append(configs[i][2]);
            ++i;
        }
        return buffer.toString();
    }

    private String getArchivesFormat(String[][] configs) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < configs.length) {
            if (i > 0) {
                buffer.append('&');
            }
            buffer.append(configs[i][0]);
            buffer.append(',');
            buffer.append(configs[i][1]);
            buffer.append(',');
            buffer.append(configs[i][2]);
            buffer.append('-');
            buffer.append(this.fInfo.toDirectory ? "folder" : "antZip");
            ++i;
        }
        if (this.groupedConfigurations()) {
            buffer.append('&');
            buffer.append("group,group,group-");
            buffer.append(this.fInfo.toDirectory ? "folder" : "antZip");
        }
        return buffer.toString();
    }

    protected void setupGenerator(BuildScriptGenerator generator, String featureID, String versionId, String[][] configs, String featureLocation) throws CoreException {
        URI[] contexts;
        IExecutionEnvironment[] envs;
        generator.setChildren(true);
        generator.setWorkingDirectory(featureLocation);
        generator.setDevEntries(this.getDevProperties());
        generator.setElements(new String[]{"feature@" + featureID + (versionId == null ? "" : ":" + versionId)});
        generator.setPluginPath(this.getPaths());
        generator.setReportResolutionErrors(false);
        generator.setIgnoreMissingPropertiesFile(true);
        generator.setSignJars(this.fInfo.signingInfo != null);
        generator.setGenerateJnlp(this.fInfo.jnlpInfo != null);
        generator.setFlattenDependencies(true);
        AbstractScriptGenerator.setConfigInfo((String)this.getConfigInfo(configs));
        generator.setArchivesFormat(this.getArchivesFormat(configs));
        generator.setPDEState(this.getBuildState());
        generator.setNextId(TargetPlatformHelper.getPDEState().getNextId());
        if (this.fInfo.useWorkspaceCompiledClasses) {
            generator.setUseWorkspaceBinaries(true);
            generator.setStateExtraData(TargetPlatformHelper.getBundleClasspaths(TargetPlatformHelper.getPDEState()), TargetPlatformHelper.getPatchMap(TargetPlatformHelper.getPDEState()), this.getWorkspaceExportHelper().getWorkspaceOutputFolders(this.fInfo.items));
        } else {
            generator.setStateExtraData(TargetPlatformHelper.getBundleClasspaths(TargetPlatformHelper.getPDEState()), TargetPlatformHelper.getPatchMap(TargetPlatformHelper.getPDEState()));
        }
        AbstractScriptGenerator.setForceUpdateJar((boolean)false);
        AbstractScriptGenerator.setEmbeddedSource((this.fInfo.exportSource && !this.fInfo.exportSourceBundle ? 1 : 0) != 0);
        Properties properties = new Properties();
        properties.put("allowBinaryCycles", Boolean.toString(this.fInfo.allowBinaryCycles));
        properties.put("p2.gathering", Boolean.toString(this.publishingP2Metadata()));
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] iExecutionEnvironmentArray = envs = manager.getExecutionEnvironments();
        int n = envs.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment env = iExecutionEnvironmentArray[n2];
            String id = env.getId();
            if (id != null) {
                properties.put(id, BuildUtilities.getBootClasspath(id));
            }
            ++n2;
        }
        generator.setImmutableAntProperties(properties);
        String[] extraLocations = ExecutionEnvironmentProfileManager.getCustomProfileLocations();
        if (extraLocations != null) {
            generator.setEESources(extraLocations);
        }
        if (this.publishingP2Metadata() && (contexts = this.getMetadataContextFromTargetPlatform()) != null) {
            generator.setContextMetadataRepositories(contexts);
        }
    }

    protected State getState(String os, String ws, String arch) {
        Dictionary[] dictionaries;
        State main = TargetPlatformHelper.getState();
        if (os.equals(TargetPlatform.getOS()) && ws.equals(TargetPlatform.getWS()) && arch.equals(TargetPlatform.getOSArch())) {
            return main;
        }
        if (this.fStateCopy == null) {
            this.copyState(main);
        }
        Dictionary[] dictionaryArray = dictionaries = this.fStateCopy.getPlatformProperties();
        int n = dictionaries.length;
        int n2 = 0;
        while (n2 < n) {
            Dictionary properties = dictionaryArray[n2];
            properties.put("osgi.os", os);
            properties.put("osgi.ws", ws);
            properties.put("osgi.arch", arch);
            ++n2;
        }
        this.fStateCopy.resolve(false);
        return this.fStateCopy;
    }

    protected State getBuildState() {
        State main = TargetPlatformHelper.getState();
        if (this.fStateCopy == null) {
            this.copyState(main);
        }
        return this.fStateCopy;
    }

    protected void copyState(State state) {
        this.fStateCopy = state.getFactory().createState(state);
        this.fStateCopy.setResolver(Platform.getPlatformAdmin().createResolver());
        this.fStateCopy.setPlatformProperties(state.getPlatformProperties());
    }

    private String getDevProperties() throws CoreException {
        if (this.fDevProperties == null) {
            this.fDevProperties = ClasspathHelper.getDevEntriesProperties(String.valueOf(this.fBuildTempLocation) + "/dev.properties", false);
        }
        return this.fDevProperties;
    }

    protected boolean isCustomBuild(IModel model) throws CoreException {
        IBuildModel buildModel = null;
        IFile buildFile = PDEProject.getBuildProperties(model.getUnderlyingResource().getProject());
        if (buildFile.exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        if (buildModel != null) {
            IBuild build = buildModel.getBuild();
            if (build == null) {
                return false;
            }
            IBuildEntry entry = build.getEntry("custom");
            if (entry != null) {
                String[] tokens;
                String[] stringArray = tokens = entry.getTokens();
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    if (token.equals("true")) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    protected String[] getPaths() {
        IFeatureModel[] models;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        FeatureModelManager fmm = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel[] iFeatureModelArray = models = fmm.getExternalModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            if (model.getInstallLocation() != null) {
                map.put(model.getFeature().getId(), model.getInstallLocation());
            }
            ++n2;
        }
        models = fmm.getWorkspaceModels();
        String[] locations = new String[models.length];
        int i = 0;
        while (i < models.length) {
            map.remove(models[i].getFeature().getId());
            locations[i] = models[i].getInstallLocation();
            ++i;
        }
        String[] paths = new String[map.size() + models.length];
        paths = map.values().toArray(paths);
        System.arraycopy(locations, 0, paths, map.size(), models.length);
        return paths;
    }

    protected void cleanup(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        this.fDevProperties = null;
        this.fAntBuildProperties = null;
        File scriptFile = null;
        try {
            try {
                String[] stringArray;
                scriptFile = this.createScriptFile("zip.xml");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().newDocument();
                Element root = doc.createElement("project");
                root.setAttribute("name", "temp");
                root.setAttribute("default", "clean");
                root.setAttribute("basedir", ".");
                doc.appendChild(root);
                Element target = doc.createElement("target");
                target.setAttribute("name", "clean");
                Element child = doc.createElement("delete");
                child.setAttribute("dir", this.fBuildTempLocation);
                target.appendChild(child);
                root.appendChild(target);
                if (this.hasAntErrors()) {
                    target = doc.createElement("target");
                    target.setAttribute("name", "zip.logs");
                    child = doc.createElement("zip");
                    child.setAttribute("zipfile", String.valueOf(this.fInfo.destinationDirectory) + this.logName(null));
                    child.setAttribute("basedir", String.valueOf(this.fBuildTempLocation) + "/pde.logs");
                    target.appendChild(child);
                    root.appendChild(target);
                }
                XMLPrintHandler.writeFile(doc, scriptFile);
                if (this.hasAntErrors()) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "zip.logs";
                    stringArray = stringArray2;
                    stringArray2[1] = "clean";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "clean";
                }
                String[] targets = stringArray;
                AntRunner runner = new AntRunner();
                runner.setBuildFileLocation(scriptFile.getAbsolutePath());
                runner.setExecutionTargets(targets);
                runner.run((IProgressMonitor)subMonitor.split(1));
            }
            catch (IOException | FactoryConfigurationError | ParserConfigurationException | CoreException throwable) {
                if (scriptFile != null && scriptFile.exists()) {
                    scriptFile.delete();
                }
            }
        }
        finally {
            if (scriptFile != null && scriptFile.exists()) {
                scriptFile.delete();
            }
        }
    }

    protected File createScriptFile(String filename) throws IOException {
        String path = PDECore.getDefault().getStateLocation().toOSString();
        File zip = new File(path, filename);
        if (zip.exists()) {
            zip.delete();
            zip.createNewFile();
        }
        return zip;
    }

    private String logName(String[] config) {
        if (config == null) {
            return "/logs.zip";
        }
        return "/logs." + config[0] + '.' + config[1] + '.' + config[2] + ".zip";
    }

    private void createFeature(String featureID, String featureLocation, Object[] featuresExported, Document doc, Element root, Properties prop) throws IOException {
        try {
            if (doc == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                doc = factory.newDocumentBuilder().newDocument();
                root = doc.createElement("feature");
                root.setAttribute("id", featureID);
                root.setAttribute("version", "1.0");
                doc.appendChild(root);
                prop = new Properties();
                prop.put("pde", "marker");
                prop.put("individualSourceBundles", "true");
            }
            boolean returnAfterLoop = false;
            Object[] objectArray = featuresExported;
            int n = featuresExported.length;
            int n2 = 0;
            while (n2 < n) {
                Element includes;
                IFeature feature;
                Object element = objectArray[n2];
                if (element instanceof IFeatureModel) {
                    feature = ((IFeatureModel)element).getFeature();
                    if (feature.getIncludedFeatures().length > 0) {
                        this.createFeature(featureID, featureLocation, feature.getIncludedFeatures(), doc, root, prop);
                    }
                    includes = doc.createElement("includes");
                    includes.setAttribute("id", String.valueOf(feature.getId()) + ".source");
                    includes.setAttribute("version", feature.getVersion());
                    root.appendChild(includes);
                    prop.put("generate.feature@" + feature.getId() + ".source", feature.getId());
                    includes = doc.createElement("includes");
                    includes.setAttribute("id", feature.getId());
                    includes.setAttribute("version", feature.getVersion());
                    root.appendChild(includes);
                } else if (element instanceof IFeatureChild) {
                    returnAfterLoop = true;
                    feature = ((FeatureChild)element).getReferencedFeature();
                    if (feature != null) {
                        if (feature.getIncludedFeatures().length > 0) {
                            this.createFeature(featureID, featureLocation, feature.getIncludedFeatures(), doc, root, prop);
                        }
                        includes = doc.createElement("includes");
                        includes.setAttribute("id", String.valueOf(feature.getId()) + ".source");
                        includes.setAttribute("version", feature.getVersion());
                        root.appendChild(includes);
                        prop.put("generate.feature@" + feature.getId() + ".source", feature.getId());
                    }
                }
                ++n2;
            }
            if (returnAfterLoop) {
                return;
            }
            File file = new File(featureLocation);
            if (!file.exists() || !file.isDirectory()) {
                file.mkdirs();
            }
            this.save(new File(file, "build.properties"), prop, "Marker File");
            XMLPrintHandler.writeFile(doc, new File(file, "feature.xml"));
        }
        catch (FactoryConfigurationError | ParserConfigurationException | DOMException throwable) {}
    }

    private Dictionary<String, String> getEnvironment(String[] config) {
        Hashtable<String, String> environment = new Hashtable<String, String>(4);
        ((Dictionary)environment).put("osgi.os", config[0]);
        ((Dictionary)environment).put("osgi.ws", config[1]);
        ((Dictionary)environment).put("osgi.arch", config[2]);
        ((Dictionary)environment).put("osgi.nl", config[3]);
        return environment;
    }

    private void setFilterAttributes(Element plugin, String[] config) {
        if (config != GENERIC_CONFIG) {
            plugin.setAttribute("os", config[0]);
            plugin.setAttribute("ws", config[1]);
            plugin.setAttribute("arch", config[2]);
        }
    }

    private BundleDescription getMatchingLauncher(String[] configuration, BundleDescription[] fragments) {
        Dictionary<String, String> environment = this.getEnvironment(configuration);
        int i = 0;
        while (i < fragments.length) {
            if (!this.isNLFragment(fragments[i]) && this.shouldAddPlugin(fragments[i], environment)) {
                return fragments[i];
            }
            ++i;
        }
        return null;
    }

    private boolean isNLFragment(BundleDescription fragment) {
        String symbolicName = fragment.getSymbolicName();
        int idx = symbolicName.lastIndexOf(46);
        return idx > -1 && symbolicName.regionMatches(true, idx + 1, "nl", 0, 2);
    }

    protected void createFeature(String featureID, String featureLocation, String[][] configurations, boolean includeLauncher) throws IOException {
        File file = new File(featureLocation);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().newDocument();
            Element root = doc.createElement("feature");
            root.setAttribute("id", featureID);
            root.setAttribute("version", "1.0");
            doc.appendChild(root);
            if (includeLauncher) {
                IFeatureModel model = PDECore.getDefault().getFeatureModelManager().getDeltaPackFeature();
                if (model != null) {
                    IFeature feature = model.getFeature();
                    Element includes = doc.createElement("includes");
                    includes.setAttribute("id", feature.getId());
                    includes.setAttribute("version", feature.getVersion());
                    root.appendChild(includes);
                } else {
                    BundleDescription bundle;
                    IPluginModelBase launcherPlugin = PluginRegistry.findModel("org.eclipse.equinox.launcher");
                    if (launcherPlugin != null && (bundle = launcherPlugin.getBundleDescription()) != null) {
                        Element plugin = doc.createElement("plugin");
                        plugin.setAttribute("id", bundle.getSymbolicName());
                        plugin.setAttribute("version", bundle.getVersion().toString());
                        plugin.setAttribute("unpack", "false");
                        root.appendChild(plugin);
                        BundleDescription[] fragments = bundle.getFragments();
                        String[][] stringArray = configurations;
                        int n = configurations.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object configuration = stringArray[n2];
                            BundleDescription launcherFragment = this.getMatchingLauncher((String[])configuration, fragments);
                            if (launcherFragment != null) {
                                Element fragment = doc.createElement("plugin");
                                fragment.setAttribute("id", launcherFragment.getSymbolicName());
                                fragment.setAttribute("version", launcherFragment.getVersion().toString());
                                fragment.setAttribute("fragment", "true");
                                this.setFilterAttributes(fragment, (String[])configuration);
                                root.appendChild(fragment);
                            }
                            ++n2;
                        }
                    }
                }
            }
            List<IPluginModelBase> workspacePlugins = Arrays.asList(PluginRegistry.getWorkspaceModels());
            Object[] objectArray = this.fInfo.items;
            int n = this.fInfo.items.length;
            int n3 = 0;
            while (n3 < n) {
                Object item = objectArray[n3];
                if (item instanceof IFeatureModel) {
                    IFeature feature = ((IFeatureModel)item).getFeature();
                    Element includes = doc.createElement("includes");
                    includes.setAttribute("id", feature.getId());
                    includes.setAttribute("version", feature.getVersion());
                    root.appendChild(includes);
                    if (this.fInfo.exportSource && this.fInfo.exportSourceBundle) {
                        includes = doc.createElement("includes");
                        includes.setAttribute("id", String.valueOf(feature.getId()) + ".source");
                        includes.setAttribute("version", feature.getVersion());
                        root.appendChild(includes);
                    }
                } else {
                    String option;
                    IProject project;
                    IJavaProject iJavaProject;
                    BundleDescription bundle = null;
                    if (item instanceof BundlePluginModel && (iJavaProject = JavaCore.create((IProject)(project = ((BundlePluginModel)item).getUnderlyingResource().getProject()))) != null && (option = iJavaProject.getOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", true)) != null && option.equals("enabled")) {
                        this.isPreviewFeatureEnabled = true;
                    }
                    if (item instanceof IPluginModelBase) {
                        bundle = ((IPluginModelBase)item).getBundleDescription();
                    }
                    if (bundle == null && item instanceof BundleDescription) {
                        bundle = (BundleDescription)item;
                    }
                    if (bundle != null) {
                        ArrayList<Object> configs = new ArrayList<Object>();
                        if (configurations.length > 1) {
                            configs.add(GENERIC_CONFIG);
                        }
                        configs.addAll(Arrays.asList(configurations));
                        for (String[] stringArray : configs) {
                            Dictionary<String, String> environment = this.getEnvironment(stringArray);
                            if (!this.shouldAddPlugin(bundle, environment)) continue;
                            Element plugin = doc.createElement("plugin");
                            plugin.setAttribute("id", bundle.getSymbolicName());
                            plugin.setAttribute("version", bundle.getVersion().toString());
                            this.setFilterAttributes(plugin, stringArray);
                            this.setAdditionalAttributes(plugin, bundle);
                            root.appendChild(plugin);
                            if (this.fInfo.exportSource && this.fInfo.exportSourceBundle) {
                                if (workspacePlugins.contains(PluginRegistry.findModel(bundle))) {
                                    plugin = doc.createElement("plugin");
                                    plugin.setAttribute("id", String.valueOf(bundle.getSymbolicName()) + ".source");
                                    plugin.setAttribute("version", bundle.getVersion().toString());
                                    this.setFilterAttributes(plugin, stringArray);
                                    this.setAdditionalAttributes(plugin, bundle);
                                    root.appendChild(plugin);
                                } else {
                                    IPluginModelBase model = PluginRegistry.findModel(String.valueOf(bundle.getSymbolicName()) + ".source");
                                    if (model != null) {
                                        bundle = model.getBundleDescription();
                                        plugin = doc.createElement("plugin");
                                        plugin.setAttribute("id", bundle.getSymbolicName());
                                        plugin.setAttribute("version", bundle.getVersion().toString());
                                        this.setFilterAttributes(plugin, stringArray);
                                        this.setAdditionalAttributes(plugin, bundle);
                                        root.appendChild(plugin);
                                    }
                                }
                            }
                            if (stringArray == GENERIC_CONFIG) break;
                        }
                    }
                }
                ++n3;
            }
            XMLPrintHandler.writeFile(doc, new File(file, "feature.xml"));
        }
        catch (FactoryConfigurationError | ParserConfigurationException | DOMException throwable) {}
    }

    protected void setAdditionalAttributes(Element plugin, BundleDescription bundle) {
    }

    public static void errorFound() {
        fHasErrors = true;
    }

    public boolean hasAntErrors() {
        return fHasErrors;
    }

    protected boolean shouldAddPlugin(BundleDescription bundle, Dictionary<String, String> environment) {
        String filterSpec = bundle.getPlatformFilter();
        try {
            return filterSpec == null || PDECore.getDefault().getBundleContext().createFilter(filterSpec).match(environment);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    protected IStatus testBuildWorkspaceBeforeExport(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        if (this.fInfo.useWorkspaceCompiledClasses) {
            this.getWorkspaceExportHelper().buildBeforeExport(this.fInfo.items, (IProgressMonitor)subMonitor.split(45));
            Set<IProject> errors = this.getWorkspaceExportHelper().checkForErrors(this.fInfo.items);
            subMonitor.split(5);
            if (!errors.isEmpty()) {
                return Status.error((String)NLS.bind((String)PDECoreMessages.FeatureExportOperation_workspaceBuildErrorsFoundDuringExport, errors));
            }
        }
        return Status.OK_STATUS;
    }

    protected WorkspaceExportHelper getWorkspaceExportHelper() {
        if (this.fWorkspaceExportHelper == null) {
            this.fWorkspaceExportHelper = new WorkspaceExportHelper();
        }
        return this.fWorkspaceExportHelper;
    }
}

