/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.metrics.library;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.metrics.extensionpoints.interfaces.IDefaultQuerySwitch;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class SysMLRequirementsDefaultQuerySwitch
implements IDefaultQuerySwitch {
    public Object calculateValue(String operationName, Element element) {
        switch (operationName) {
            case "countRequirementsInAllOwnedElements": {
                return SysMLRequirementsDefaultQuerySwitch.countRequirementsInAllOwnedElements(element);
            }
            case "countUnsatisfiedRequirementsInAllOwnedElements": {
                return SysMLRequirementsDefaultQuerySwitch.countUnsatisfiedRequirementsInAllOwnedElements(element);
            }
            case "countSatisfiedRequirementsInAllOwnedElements": {
                return SysMLRequirementsDefaultQuerySwitch.countSatisfiedRequirementsInAllOwnedElements(element);
            }
        }
        return null;
    }

    public static Integer countSatisfiedRequirementsInAllOwnedElements(Element element) {
        return SysMLRequirementsDefaultQuerySwitch.countRequirementsInAllOwnedElements(element) - SysMLRequirementsDefaultQuerySwitch.countUnsatisfiedRequirementsInAllOwnedElements(element);
    }

    public static Integer countRequirementsInAllOwnedElements(Element element) {
        int numberOfRequirements = 0;
        for (Element e : element.allOwnedElements()) {
            if (e.getAppliedStereotype("SysML::Requirements::Requirement") == null) continue;
            ++numberOfRequirements;
        }
        return numberOfRequirements;
    }

    public static Integer countUnsatisfiedRequirementsInAllOwnedElements(Element element) {
        int numberOfUnsatisfiedRequirements = 0;
        for (Element e : element.allOwnedElements()) {
            EList list;
            Stereotype reqStereotype;
            Object listOfObjectsThatSatisfyRequirement;
            if (e.getAppliedStereotype("SysML::Requirements::Requirement") == null || !((listOfObjectsThatSatisfyRequirement = e.getValue(reqStereotype = e.getAppliedStereotype("SysML::Requirements::Requirement"), "satisfiedBy")) instanceof EList) || !(list = (EList)listOfObjectsThatSatisfyRequirement).isEmpty()) continue;
            ++numberOfUnsatisfiedRequirements;
        }
        return numberOfUnsatisfiedRequirements;
    }
}

