/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.papyrusre.modellibrary.papyrusrestandardutils.requirementclassificationconcerns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum WorkloadCapacitiesKind implements Enumerator
{
    BOUND(0, "Bound", "Bound"),
    MEMORY(1, "Memory", "Memory"),
    SPEED(2, "Speed", "Speed"),
    THROUGHPUT(3, "Throughput", "Throughput"),
    TIME(4, "Time", "Time"),
    VOLUME(5, "Volume", "Volume");

    public static final int BOUND_VALUE = 0;
    public static final int MEMORY_VALUE = 1;
    public static final int SPEED_VALUE = 2;
    public static final int THROUGHPUT_VALUE = 3;
    public static final int TIME_VALUE = 4;
    public static final int VOLUME_VALUE = 5;
    private static final WorkloadCapacitiesKind[] VALUES_ARRAY;
    public static final List<WorkloadCapacitiesKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new WorkloadCapacitiesKind[]{BOUND, MEMORY, SPEED, THROUGHPUT, TIME, VOLUME};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static WorkloadCapacitiesKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WorkloadCapacitiesKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static WorkloadCapacitiesKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WorkloadCapacitiesKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static WorkloadCapacitiesKind get(int value) {
        switch (value) {
            case 0: {
                return BOUND;
            }
            case 1: {
                return MEMORY;
            }
            case 2: {
                return SPEED;
            }
            case 3: {
                return THROUGHPUT;
            }
            case 4: {
                return TIME;
            }
            case 5: {
                return VOLUME;
            }
        }
        return null;
    }

    private WorkloadCapacitiesKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

