/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.documentview.ui.internal.editor;

import java.lang.reflect.Constructor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.AbstractPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.AbstractEditorFactory;
import org.eclipse.papyrus.infra.ui.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.papyrus.model2doc.documentview.Document;
import org.eclipse.papyrus.model2doc.documentview.ui.Activator;
import org.eclipse.papyrus.model2doc.documentview.ui.internal.editor.DocumentViewEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;

public class DocumentViewEditorFactory
extends AbstractEditorFactory {
    public DocumentViewEditorFactory() {
        super(DocumentViewEditor.class, "");
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        ServicesRegistry services = this.getServiceRegistry();
        return new DocumentViewEditorModel(pageIdentifier, services, new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                if (element instanceof Document) {
                    return ((Document)element).getName();
                }
                return null;
            }

            public Image getImage(Object element) {
                return null;
            }
        });
    }

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        return pageIdentifier instanceof Document;
    }

    class DocumentViewEditorModel
    extends AbstractPageModel
    implements IEditorModel {
        private ServicesRegistry servicesRegistry;
        private IEditorPart editor;
        private Document rawModel;

        public DocumentViewEditorModel(Object pageIdentifier, ServicesRegistry servicesRegistry, ILabelProvider labels) {
            super(labels);
            this.rawModel = (Document)pageIdentifier;
            this.servicesRegistry = servicesRegistry;
        }

        public IEditorPart createIEditorPart() throws PartInitException {
            try {
                IEditorPart newEditor;
                Constructor c = DocumentViewEditorFactory.this.getDiagramClass().getConstructor(ServicesRegistry.class, Document.class);
                this.editor = newEditor = (IEditorPart)c.newInstance(this.servicesRegistry, this.rawModel);
                return this.editor;
            }
            catch (Exception e) {
                throw new PartInitException("Can't create DocumentView", (Throwable)e);
            }
        }

        public EditorActionBarContributor getActionBarContributor() {
            ActionBarContributorRegistry registry;
            String actionBarId = DocumentViewEditorFactory.this.editorDescriptor.getActionBarContributorId();
            if (actionBarId == null || actionBarId.length() == 0) {
                return null;
            }
            try {
                registry = (ActionBarContributorRegistry)this.servicesRegistry.getService(ActionBarContributorRegistry.class);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
            try {
                return registry.getActionBarContributor((Object)actionBarId);
            }
            catch (BackboneException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
        }

        public Object getRawModel() {
            return this.rawModel;
        }
    }
}

